//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.OperatorPartTraits;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;
using SharpDX.Direct3D;

namespace Framefield.Core.IDc4cb68c1_dadf_45c5_90bc_b6cb88f2ab25
{
    public class Class_Twist : FXSourceCodeFunction, IFXSceneSourceCode
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            CenterX = 1,
            CenterY = 2,
            CenterZ = 3,
            StartAngle = 4,
            BendAngle = 5,
            SpiralEffect = 6,
            NeutralRadius = 7,
            RotateDirection = 8,
            RotateTilt = 9,
            Mesh = 10,
            BendAxis = 11
        }
        //<<< _inputids

        public Class_Twist()
        {
        }

        public override void Dispose() 
        {
            Utilities.DisposeObj(ref _mesh);
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            try
            {
                UpdateMesh(context, inputs);
                context.Mesh = _mesh;
            }
            catch (Exception exception)
            {
                Logger.Error(this, "Load Effect error: {0}", exception.Message);
            }

            return context;
        }

        bool _firstEval = true;
        private void UpdateMesh(OperatorPartContext context, List<OperatorPart> inputs)
        {
            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            if (!Changed && _mesh.Vertices != null)
                return;

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var CenterZ = inputs[(int)InputId.CenterZ].Eval(context).Value;
            var Center = new Vector3(CenterX, CenterY, CenterZ);
            var StartAngle = inputs[(int)InputId.StartAngle].Eval(context).Value;
            var BendAngle = inputs[(int)InputId.BendAngle].Eval(context).Value;
            var SpiralEffect = inputs[(int)InputId.SpiralEffect].Eval(context).Value;
            var NeutralRadius = inputs[(int)InputId.NeutralRadius].Eval(context).Value;
            var RotateDirection = inputs[(int)InputId.RotateDirection].Eval(context).Value;
            var RotateTilt = inputs[(int)InputId.RotateTilt].Eval(context).Value;
            var Rotate = new Vector2(RotateDirection, RotateTilt);
            var Mesh = inputs[(int)InputId.Mesh].Eval(context).Mesh;
            var BendAxis = (int) inputs[(int)InputId.BendAxis].Eval(context).Value;
            //<<< _params

            
            //Logger.Info(this, "collect meshes");
//            Scene.Func.Changed = false;

            if (Mesh == null)
                return;

            _mesh.AttributesSize = Mesh.AttributesSize;
            _mesh.NumTriangles = Mesh.NumTriangles;
            _mesh.InputElements = Mesh.InputElements;
            if (_mesh.Vertices == null || _mesh.Vertices.Description.SizeInBytes != Mesh.Vertices.Description.SizeInBytes)
            {
                if (_mesh.Vertices != null)
                    _mesh.Vertices.Dispose();

                _mesh.Vertices = new Buffer(D3DDevice.Device, new BufferDescription()
                                                                    {
                                                                        BindFlags = BindFlags.StreamOutput | BindFlags.VertexBuffer,
                                                                        CpuAccessFlags = CpuAccessFlags.None,
                                                                        OptionFlags = ResourceOptionFlags.None,
                                                                        SizeInBytes = _mesh.NumTriangles*Mesh.AttributesSize*3,
                                                                        Usage = ResourceUsage.Default
                                                                    });
            }
            
            Vector3 Axis, Orientation, RotateAxis, TiltAxis;
            if(BendAxis < 0.5f) {
                Axis = new Vector3(1,0,0);
                Orientation = new Vector3(0,0,-1);
                RotateAxis = new Vector3(0,1,0);
                TiltAxis = new Vector3(1,0,0);
            }
            else if (BendAxis < 1.5f) {
                Axis = new Vector3(0,1,0);            
                Orientation = new Vector3(1,0,0);
                RotateAxis = new Vector3(0,0,1);
                TiltAxis = new Vector3(0,1,0);
            }
            else {
                Axis = new Vector3(0,0,1);            
                Orientation = new Vector3(1,0,0);
                RotateAxis = new Vector3(0,1,0);
                TiltAxis = new Vector3(1,0,0);
            }

            var toRad =  3.141578f /  180f;

            var mRotate =  Matrix.Identity;
            Matrix.RotationAxis( ref RotateAxis, RotateDirection * toRad, out mRotate);
            
            var mTilt =  Matrix.Identity;
            Matrix.RotationAxis( ref TiltAxis, RotateTilt * toRad, out mTilt);
            mRotate*= mTilt;
            
            var rotatedOrientation  = Vector3.Transform( Orientation, mRotate);
            var rotatedAxis = Vector3.Transform( Axis, mRotate);
            
            SetVector("Orientation", Vector3.Normalize( new Vector3( rotatedOrientation.X , rotatedOrientation.Y, rotatedOrientation.Z)));
            SetVector("Axis",       Vector3.Normalize( new Vector3( rotatedAxis.X, rotatedAxis.Y, rotatedAxis.Z)));
            
            SetVector("Center", Center);
            SetScalar("StartAngle", StartAngle * toRad);
            SetScalar("AngleEnd", ( BendAngle - StartAngle) * toRad);
            SetScalar("SpiralEffect", SpiralEffect);
            SetScalar("NeutralRadius", NeutralRadius);
            
            SetVector2("Rotate", Rotate);

            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(_mesh.Vertices, 0) });
            context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState = new DepthStencilState(context.D3DDevice,
                                                                                                        new DepthStencilStateDescription()
                                                                                                            {
                                                                                                                IsDepthEnabled = false,
                                                                                                                IsStencilEnabled = false
                                                                                                            });
            context.D3DDevice.ImmediateContext.InputAssembler.InputLayout = context.InputLayout;
            context.D3DDevice.ImmediateContext.InputAssembler.PrimitiveTopology = PrimitiveTopology.TriangleList;
            context.D3DDevice.ImmediateContext.InputAssembler.SetVertexBuffers(0, new VertexBufferBinding(Mesh.Vertices, Mesh.AttributesSize, 0));
            var technique = _effect.GetTechniqueByIndex(0);
            technique.GetPassByIndex(0).Apply(context.D3DDevice.ImmediateContext);
            context.D3DDevice.ImmediateContext.Draw(_mesh.NumTriangles*3, 0);
            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(null, 0) });

            Changed = false;
        }

        private Mesh _mesh = new Mesh();
    }
}
    


