using System;
using System.Collections.Generic;
using SharpDX;
using SharpDX.Direct3D;
using SharpDX.Direct3D11;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.ID7612629f_f10e_4f05_9218_49945aba12f0
{
    public class Class_PointRenderer : FXSourceCodeFunction, IFXSceneSourceCode
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Points = 2
        }
        //<<< _inputids

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _inputLayout);
            base.Dispose();
        }

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            if (_firstEval) 
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }
            
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var Points = inputs[(int)InputId.Points].Eval(context).Dynamic;  // Needs to be checked for null!
            //<<< _params
            
            if (Image == null)
            {
                Logger.Error(this, "No input image set.");
                return context;
            }
            
            if (Points == null)
            {
                Logger.Error(this, "No input points set.");
                return context;
            }
            
            if (Changed || _inputElements == null)
            {
               _inputElements = new InputElement[]
                                    {
                                        new InputElement("POSITION", 0, SharpDX.DXGI.Format.R32G32B32_Float, 0, 0),
                                    };


                Utilities.DisposeObj(ref _inputLayout);
                if (_effect != null)
                {
                    var technique = _effect.GetTechniqueByIndex(0);
                    var pass = technique.GetPassByIndex(0);
                    _inputLayout = new InputLayout(Core.D3DDevice.Device, pass.Description.Signature, _inputElements);
                }
            }


            Changed = false;

            var D3DDevice = context.D3DDevice;

            try 
            {
                context.D3DDevice.ImmediateContext.ClearState();

                context.ObjectTWorld = Matrix.Identity;
                var matrixVariable = _effect.GetVariableByName("objectToWorldMatrix").AsMatrix();
                matrixVariable.SetMatrix(context.ObjectTWorld);
                matrixVariable = _effect.GetVariableByName("worldToCameraMatrix").AsMatrix();
                matrixVariable.SetMatrix(context.WorldToCamera);
                matrixVariable = _effect.GetVariableByName("cameraToObjectMatrix").AsMatrix();
                var cameraToObject = Matrix.Invert(/*context.ObjectTWorld */ context.WorldToCamera);
                matrixVariable.SetMatrix(cameraToObject);
                matrixVariable = _effect.GetVariableByName("projMatrix").AsMatrix();
                matrixVariable.SetMatrix(context.CameraProjection);
                
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    if (context.DepthStencilView != null)
                        context.D3DDevice.ImmediateContext.OutputMerger.SetTargets(context.DepthStencilView, context.RenderTargetView);
                    else
                        context.D3DDevice.ImmediateContext.OutputMerger.SetTargets(context.RenderTargetView);
    
                    if (context.BlendState != null)
                    {
                        context.D3DDevice.ImmediateContext.OutputMerger.BlendState = context.BlendState;
                    }
    
                    if (context.DepthStencilState != null)
                    {
                        context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState = context.DepthStencilState;
                    }
    
                    if (context.RasterizerState != null)
                    {
                        context.D3DDevice.ImmediateContext.Rasterizer.State = context.RasterizerState;
                    }

                    context.D3DDevice.ImmediateContext.Rasterizer.SetViewports(new [] { context.Viewport });
                    context.D3DDevice.ImmediateContext.InputAssembler.InputLayout = _inputLayout;
                    context.D3DDevice.ImmediateContext.InputAssembler.PrimitiveTopology = PrimitiveTopology.PointList;
                    var pointsBuffer = Points.PosBuffer;
                    context.D3DDevice.ImmediateContext.InputAssembler.SetVertexBuffers(0, new VertexBufferBinding(pointsBuffer, 64, 48));
    
                    int numPoints = pointsBuffer.Description.SizeInBytes/12;
                    var technique = _effect.GetTechniqueByIndex(0);
                    for (int i = 0; i < technique.Description.PassCount; ++i)
                    {
                        technique.GetPassByIndex(i).Apply(context.D3DDevice.ImmediateContext);
                        context.D3DDevice.ImmediateContext.Draw(numPoints, 0);
                    }
                }
            }
            catch (Exception exception) 
            {
                Logger.Error(this,"Load Effect error: {0}", exception.Message);
            }

            return context;
        }

        InputLayout _inputLayout = null;
        InputElement[] _inputElements = null;
        Texture2D _image = null;
    }
}


