//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
using Framefield.Core.IDb03022e3_8b4f_4d33_b749_ef30a03ef098; // CurveProviderFunc
//<<< _using

namespace Framefield.Core.IDcac86d7b_6fe4_4e15_af72_b7fbd7bf7798
{
    public class Class___AddParameterCurve : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value1 = 0,
            Value2 = 1,
            ParameterCurve = 2
        }
        //<<< _inputids
        

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            if (Changed)
            {
                //>>> _params
                var Value1 = inputs[(int)InputId.Value1].Eval(context).Value;
                var Value2 = inputs[(int)InputId.Value2].Eval(context).Value;
                var ParameterCurve = inputs[(int)InputId.ParameterCurve].Eval(context).Dynamic;  // Needs to be checked for null!
                //<<< _params
                
                var c = ParameterCurve as Curve.ICurve;
                if(c != null) {
                    var v2 = c.GetSampledValue(Value1);
                    Logger.Info("curve value is"+ v2);
                }
                _sum = Value1 + Value2;
                Changed = false;
                
            }
            
            context.Value = _sum;
            return context;
        }
        float _sum;
    }
}

