//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDacd916cc_06f8_4cae_b14c_a4a1335289ac
{
    public class Class_triTunnel : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            iTime = 1,
            turnSpeed = 2,
            saturation = 3,
            outline = 4,
            dotSize = 5,
            FFT = 6,
            CenterX = 7,
            CenterY = 8
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var iTime = inputs[(int)InputId.iTime].Eval(context).Value;
            var turnSpeed = inputs[(int)InputId.turnSpeed].Eval(context).Value;
            var saturation = inputs[(int)InputId.saturation].Eval(context).Value;
            var outline = inputs[(int)InputId.outline].Eval(context).Value;
            var dotSize = inputs[(int)InputId.dotSize].Eval(context).Value;
            var FFT = inputs[(int)InputId.FFT].Eval(context).Value;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            //<<< _params
            
//            if(Image == null)
//                return context;

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("iTime").AsScalar().Set(iTime);
                    _effect.GetVariableByName("turnSpeed").AsScalar().Set(turnSpeed);
                    _effect.GetVariableByName("saturation").AsScalar().Set(saturation);
                    _effect.GetVariableByName("outline").AsScalar().Set(outline);
                    _effect.GetVariableByName("dotSize").AsScalar().Set(dotSize);
                    _effect.GetVariableByName("FFT").AsScalar().Set(FFT);
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

