<?php
$eol = "\r\n";
$grList = array(
 	array(
		'file' => 'atebit.img',
		'y' => 4,
		'scr' => 0xC041,
		'attr' => 0xD841,
	),
	
	array(
		'file' => 'excess.img',
		'y' => 3,
		'scr' => 0xC88C,
		'attr' => 0xD98C,
	),
	array(
		'file' => 'fenomen.img',
		'y' => 4,
		'scr' => 0xC068,
		'attr' => 0xD868,
	),
	
	array(
		'file' => 'gemba.img',
		'y' => 4,
		'scr' => 0xD023,
		'attr' => 0xDA23,
	),
	//---------------
	array(
		'file' => 'lifeonmars.img',
		'y' => 4,
		'scr' => 0xC820,
		'attr' => 0xD920,
	),
	array(
		'file' => 'mayhem.img',
		'y' => 4,
		'scr' => 0xC065,
		'attr' => 0xD865,
	),
	array(
		'file' => 'outsiders.img',
		'y' => 4,
		'scr' => 0xD025,
		'attr' => 0xDA25,
	),
	array(
		'file' => 'qbone.img',
		'y' => 4,
		'scr' => 0xC822,
		'attr' => 0xD922,
	),
	//---------------
	array(
		'file' => 'scoopex.img',
		'y' => 3,
		'scr' => 0xC04A,
		'attr' => 0xD84A,
	),
	array(
		'file' => 'sibkrew.img',
		'y' => 4,
		'scr' => 0xD022,
		'attr' => 0xDA22,
	),
	array(
		'file' => 'stardust.img',
		'y' => 4,
		'scr' => 0xC827,
		'attr' => 0xD927,
	),
	array(
		'file' => 'tbk4d.img',
		'y' => 4,
		'scr' => 0xC061,
		'attr' => 0xD861,
	),
	//---------------
	array(
		'file' => 'technolab.img',
		'y' => 4,
		'scr' => 0xC842,
		'attr' => 0xD942,
	),
	array(
		'file' => 'thesuper.img',
		'y' => 4,
		'scr' => 0xD022,
		'attr' => 0xDA22,
	),
	
	array(
		'file' => 'andyou.img',
		'y' => 4,
		'scr' => 0xC821,
		'attr' => 0xD921,
	),
    
);


$grCode = '';
foreach ($grList as $grId => $grData) {
    $grCode .= "//----------------------" . $grData['file'] . $eol;
    $grCode .= "GREETZ_" . $grId . $eol;
    $grCode .= "\tDW\t#" . asHex($grData['scr']) . $eol;
    $grCode .= "\tDW\t#" . asHex($grData['attr']) . $eol;
    $grCode .= "\t;------" . $eol;
    $img = file_get_contents(__DIR__ . '/images/' . $grData['file']);
    for ($y = 0; $y < $grData['y']; $y++) {
        $szx = 0;
        for ($x = 0; $x < 32; $x++) {
            $adrPix0 = $y*32 + $x;
            $adrPix1 = 256*4 + $y*32 + $x;
            $adrAttr = 6144 + $y*32 + $x;
            if (ord($img[$adrAttr]) != 0x41 || ord($img[$adrPix0]) != 0xFF || ord($img[$adrPix1]) != 0xFF) {
                $szx = $x + 1;
            }
        }
        //---
        $x = 0;
        $emptyQty = 0;
        while ($x < $szx) {
            $adrPix0 = $y*32 + $x;
            $adrPix1 = 256*4 + $y*32 + $x;
            $adrAttr = 6144 + $y*32 + $x;
            if (ord($img[$adrAttr]) == 0x41 && ord($img[$adrPix0]) == 0xFF && ord($img[$adrPix1]) == 0xFF) {
                $emptyQty++;
            } else {
                if ($emptyQty != 0) {
                    $grCode .= "\tDB\tlow GR_DX," . $emptyQty . $eol;
                    $emptyQty = 0;
                }
                if (ord($img[$adrAttr]) == 0x41) { //mask
                    $grCode .= "\tDB\tlow GR_MASK, #" . asHex(ord($img[$adrPix0])) . ", #" . asHex(ord($img[$adrPix1])) . $eol;
                } else { //out
                    $grCode .= "\tDB\tlow GR_" . asHex(ord($img[$adrPix0])) . "_" . asHex(ord($img[$adrPix1])) . ", #" . asHex(ord($img[$adrAttr])) . $eol;
                }
            }
            $x++;
        }
        if ($y != $grData['y'] - 1) {
            $grCode .= "\tDB\tlow GR_LN," . (32 - $x + $emptyQty) . $eol;
            $grCode .= "\t;------" . $eol;
        } else {
            $grCode .= "\tDB\tlow GR_RET" . $eol;
        }
        
    }
    file_put_contents(__DIR__ . '/greetz_data.asm', $grCode);
}

function asHex($num) {
    $result = strtoupper(dechex($num));
    if (strlen($result)%2 != 0) {
        $result = '0' . $result;
    }
    return $result;
}