<?php
$greetzList = array(
	array(
		'filename' => 'atebit.img',
		'size_x' => 17,
		'size_y' => 6,
		'scr' => 0xC041,
		'attr' => 0xD841,
	),
	
	array(
		'filename' => 'excess.img',
		'size_x' => 18,
		'size_y' => 6,
		'scr' => 0xC8CC,
		'attr' => 0xD9CC,
	),
	array(
		'filename' => 'fenomen.img',
		'size_x' => 22,
		'size_y' => 6,
		'scr' => 0xC0C9,
		'attr' => 0xD8C9,
	),
	
	array(
		'filename' => 'gemba.img',
		'size_x' => 17,
		'size_y' => 6,
		'scr' => 0xD063,
		'attr' => 0xDA63,
	),
	//---------------
	array(
		'filename' => 'life_on_mars.img',
		'size_x' => 31,
		'size_y' => 6,
		'scr' => 0xC841,
		'attr' => 0xD941,
	),
	array(
		'filename' => 'mayhem.img',
		'size_x' => 22,
		'size_y' => 6,
		'scr' => 0xC0C5,
		'attr' => 0xD8C5,
	),
	array(
		'filename' => 'outsiders.img',
		'size_x' => 32-6,
		'size_y' => 6,
		'scr' => 0xD065,
		'attr' => 0xDA65,
	),
	
	array(
		'filename' => 'q-bone.img',
		'size_x' => 17,
		'size_y' => 6,
		'scr' => 0xC822,
		'attr' => 0xD922,
	),
	//---------------
	array(
		'filename' => 'scoopex.img',
		'size_x' => 32-11,
		'size_y' => 6,
		'scr' => 0xC04B,
		'attr' => 0xD84B,
	),
	
	array(
		'filename' => 'sibkrew.img',
		'size_x' => 22,
		'size_y' => 6,
		'scr' => 0xD042,
		'attr' => 0xDA42,
	),
	array(
		'filename' => 'stardust.img',
		'size_x' => 32-8,
		'size_y' => 6,
		'scr' => 0xC868,
		'attr' => 0xD968,
	),
	array(
		'filename' => 'tbk_4d.img',
		'size_x' => 16,
		'size_y' => 6,
		'scr' => 0xC061,
		'attr' => 0xD861,
	),
	//---------------
	array(
		'filename' => 'technolab.img',
		'size_x' => 32-7,
		'size_y' => 6,
		'scr' => 0xC042,
		'attr' => 0xD842,
	),
	
	array(
		'filename' => 'thesuper.img',
		'size_x' => 32-8,
		'size_y' => 6,
		'scr' => 0xD062,
		'attr' => 0xDA62,
	),
	
	array(
		'filename' => 'and_you.img',
		'size_x' => 20,
		'size_y' => 6,
		'scr' => 0xC868,
		'attr' => 0xD968,
	),

	array(
		'filename' => '_empty.img',
		'size_x' => 1,
		'size_y' => 6,
		'scr' => 0xC042,
		'attr' => 0xD842,
	),
);

$greetzCode = '';
foreach ($greetzList as $n => $greetz) {
	$greetzCode .= "GREETZ_" . $n . " ;------------------\r\n";
	$greetzCode .= "\tDW\t" . $greetz['scr'] . "\r\n";
	$greetzCode .= "\tDB\t" . $greetz['size_x'] . "\r\n";
	$img = file_get_contents(__DIR__ . "/greetz/" . $greetz['filename']);
	for ($y = 0; $y < $greetz['size_y']; $y++) {
		for ($x = 0; $x < $greetz['size_x']; $x++) {
			$adrAttr = 6144 + floor($y/2) * 32 + $x;
			$attr = ord(substr($img, $adrAttr, 1));
			$adr = 1024 * ($y%2) + 32 * floor($y/2) + $x;
			$byte = ord(substr($img, $adr, 1));
			$greetzCode .= "\tDB\t" . ($attr==8 ? 1 : $byte)  . "\r\n";
		}
	}
	$greetzCode .= "\tDW\t" . $greetz['attr'] . "\r\n";
	for ($y = 0; $y < floor($greetz['size_y']/2); $y++) {
		for ($x = 0; $x < $greetz['size_x']; $x++) {
			$adrAttr = 6144 + $y * 32 + $x;
			$attr = ord(substr($img, $adrAttr, 1));
			$greetzCode .= "\tDB\t" . ($attr==8 ? 0 : ($y==2 ? 7 : $attr)) . "\r\n";
		}
	}
	
}

file_put_contents(__DIR__ . "/greetz_list.asm", $greetzCode);

echo "123\r\n";