<?

$chunks = imagecreatefrompng('chunks_03.png');
ob_start();
imagepng($chunks);
$chunksImg = ob_get_clean();
$chunksImg = 'data:image/gif;base64,' . base64_encode($chunksImg);

$texture = imagecreatefrompng('rombs.png');
ob_start();
imagepng($texture);
$textureImg = ob_get_clean();
$textureImg = 'data:image/gif;base64,' . base64_encode($textureImg);
?>

<!DOCTYPE html>
<html>
    <head>
        <script>
            var zoom = 1;
            var renderFrames = 3;
            var jsInterval = 20 * renderFrames;
            var chunksSizeX = 8;
            var chunksSizeY = 4;
            var chunkSetQty = 32;
            var chunksQtyX = Math.floor(256 / chunksSizeX);
            var chunksQtyY = Math.floor(256 / chunksSizeY);
            var shadow = 12;
            
            var buffer = [];
            for (y=0; y < chunksQtyY + shadow*2; y++) {
                buffer[y] = [];
                for (x=0; x < chunksQtyX; x++) {
                    buffer[y][x] = 0;
                }
            }
        
        

            var dt = new Date;
        
            var maxY = chunksQtyY + shadow;
            var maxX = chunksQtyX;
            
            console.log(maxY);
        
            var frame = 0;
            

            var alpha = 0.0;
            var betha = 0.0;

            var ax = 0.0;
            var ay = 0.0;
            var x0 = 0;
            var y0 = 0;
            var tzoom = 1;
            
            var canvas;
            var ctx;
            
            var tCanvas;
            var tCanvasCtx;
            var texture = new Image();
            texture.src = '<?= $textureImg ?>';
            texture.onload = function() {
                tCanvas = document.getElementById('tCanvas');
                tCanvasCtx = tCanvas.getContext('2d');
                tCanvasCtx.drawImage(
                    texture,
                    0, 0, 256, 32,
                    0, 0, 256, 32
                );
            }
            
            
            var chunks = new Image();
            chunks.src = '<?= $chunksImg ?>';
            chunks.onload = function() {
                canvas = document.getElementById('canvas');
                ctx = canvas.getContext('2d');
                setTimeout(function() {
                    setInterval(function(){
                        renderFrame();
                    }, jsInterval)
                }, 500);
            }
            var speed = 0.65;
            function renderFrame() {
                alpha += 2 * speed;
                if (alpha >= 360) { alpha -= 360; }
                var a = 128 * Math.cos(Math.PI * alpha / 180);

                ax += 5 * speed; if (ax >= 360) { ax -= 360; }
                ay += 3 * speed; if (ax >= 360) { ax -= 360; }                

                x0 = 56 * Math.cos(Math.PI * ax / 180);
                y0 = 32 * Math.sin(Math.PI * ay / 180);
                
                var zX = 1.5;
                var zY = 1.75;
                
                for (var y = 0; y < maxY; y++) {
                    for (var x = 0; x < maxX; x++) {
                        buffer[y][x] = 0;
                    }
                }
                
                for (var y = 0; y < maxY; y++) {
                    var zoom_y = zY + zY * ((maxY - y)/maxY);
                    var zoom_x = zX + zX * ((maxY - y)/maxY);
                    for (var x = 0; x < maxX; x++) {
                        var sx = zoom_x * (x - 16);
                        var sy = zoom_y * (y - 12);

                        tx = sx * Math.cos(Math.PI * a / 180) - sy * Math.sin(Math.PI * a / 180);
                        ty = sx * Math.sin(Math.PI * a / 180) + sy * Math.cos(Math.PI * a / 180);
                        
                        tx = x0 + tx * tzoom;
                        ty = y0 + ty * tzoom;
                        
                        tx = Math.round(tx);
                        ty = Math.round(ty);
                        while(tx < 0) { tx += 56; }
                        while(ty < 0) { ty += 32; }
                        
                        
                        tx = tx & 255;
                        ty = ty & 31;
                        

                        
                        var imgd = tCanvasCtx.getImageData(tx, ty, 1, 1);
                        var pix = imgd.data;
                        var color = [];
                        pix[0]; // red
                        pix[1]; // green
                        pix[2]; // blue
                        
                        var val = 0;
                        if (pix[0] != 0 || pix[1] != 0 || pix[2] != 0) {
                            val = 31;
                        }
                        if (val > 0) {
                            var valL = 15;
                            var LightIntens = 0.85;
                            var LightMlt = 8;
                            if (pix[0]!=0) {
                                valL = Math.round(31 - LightIntens * Math.abs(LightMlt * Math.cos(Math.PI * (a + 30) / 180)));
                            } else if (pix[2]!=0)  {
                                valL = Math.round(31 - LightIntens * Math.abs(LightMlt * Math.sin(Math.PI * (a) / 180)));
                            } else if (pix[1]!=0)  {
                                valL = Math.round(31 - LightIntens * Math.abs(LightMlt * Math.cos(Math.PI * (a - 30) / 180)));
                            }
                            for (var dl = 0; dl < shadow; dl++) {
                                var valDL = valL - dl;
                                buffer[y+dl][x] = dl==0 ? val : valDL;
                            }
                        }
                    }
                }
                
                
                
                for (var y = 0; y < chunksQtyY; y++) {
                    for (var x = 0; x < chunksQtyX; x++) {
                        var val = buffer[y + shadow][x];
                        var cX = chunksSizeX * val;
                        ctx.drawImage(
                            chunks,
                            zoom * cX, 0, zoom * 8, zoom * 8,
                            zoom * x * chunksSizeX, zoom * y * chunksSizeY, zoom * 8, zoom * 8
                        );
                    }
                }
            }
        </script>
    </head>
    <body style="background-color:#000;">
        <canvas style="position:absolute;top:50%;left:50%;margin-left:-128px;margin-top:-96px;background-color:black;" id="canvas" width="256px" height="192px"></canvas>
        <canvas style="position:absolute;left:-999px;top:-999px;" id="tCanvas" width="256px" height="32px"></canvas>
    </body>
</html>