	ORG	#8000-#0b00

TBLYYY	INCLUDE "bin/landscape_yyy.asm"
TBLYYY_END
	SAVEBIN "compile/landscape_yyy.bin", TBLYYY, TBLYYY_END-TBLYYY


	ORG	#8000
//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
		JP	EFF_SET_BLINK	;8006 = blink
		JP	EFF_SET_PARAMS	;8009

EFF_SET_BLINK
	LD	A,7		
	LD	(ISBLINK),A
	RET
EFF_SET_PARAMS
	CP	2
	JP	Z,EFF_SET_P_2
	
	LD	HL,M3DY0 * 256 + M3DX0
	LD	(MDX),HL
	LD	A,M3DX_STEP
	LD	(MDX_STEP_ADR),A
	LD	A,M3DY_STEP
	LD	(MDY_STEP_ADR),A
	RET

EFF_SET_P_2
	LD	HL,M2DY0 * 256 + M2DX0
	LD	(MDX),HL
	LD	A,M2DX_STEP
	LD	(MDX_STEP_ADR),A
	LD	A,M2DY_STEP
	LD	(MDY_STEP_ADR),A
	RET
//======================================================== FX_CONST
	DEFINE	MAKEFAZE	1


	IF	MAKEFAZE = 1
MDX0	EQU	#00
MDY0	EQU	#0F
MDX_STEP EQU	1
MDY_STEP EQU	0
	ENDIF

	IF	MAKEFAZE = 2
MDX0	EQU	#00
MDY0	EQU	#18+5
MDX_STEP EQU	1
MDY_STEP EQU	0
	ENDIF

	IF	MAKEFAZE = 4
MDX0	EQU	#00
MDY0	EQU	#18+5
MDX_STEP EQU	0-1
MDY_STEP EQU	0
	ENDIF


	IF	MAKEFAZE = 3
MDX0	EQU	#00
MDY0	EQU	#1A
MDX_STEP EQU	0
MDY_STEP EQU	1
	ENDIF
	

M2DX0	EQU	#00
M2DY0	EQU	#18+5
M2DX_STEP EQU	1
M2DY_STEP EQU	0

M3DX0	EQU	#01
M3DY0	EQU	#1A
M3DX_STEP EQU	0
M3DY_STEP EQU	1


//======================================================== FX_INIT
EFF_INI_
	LD	A,#17
	CALL	PAGER
	;--
	LD	C,6
	LD	HL,#D800
	CALL	FINI00
	LD	C,5
	LD	HL,#5800
	CALL	FINI00
	LD	C,1
	LD	HL,#4400
	LD	LX,15
	LD	DE,#FFFF
	CALL	FINI0
	LD	HL,#4000
	LD	DE,#4001
	LD	BC,64
	LD	(HL),#FF
	LDIR
	RET
FINI00	LD	LX,16
	LD	DE,#0000
FINI0	LD	(SOHRSP_INI),SP
	LD	SP,HL
FINI2	LD	B,LX
FINI1	DUP	32
	PUSH	DE
	EDUP
	DJNZ	FINI1
	;-
	LD	A,D
	XOR	#FF
	LD	D,A
	LD	E,A
	;-
	DEC	C
	JP	NZ,FINI2
	;----
	LD	SP,#3131
SOHRSP_INI EQU $-2
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_

	LD	A,0
ISBLINK	EQU	$-1
	OR	A
	JP	Z,NOBLNK

	EI
	HALT
	LD	A,7
	OUT	(#FE),A
	LD	(BORDER1),A
	LD	A,#17
	CALL	PAGER
	LD	DE,#D800
	CALL	FX_BLINK
	EI
	HALT
	LD	DE,#5800
	CALL	FX_BLINK


NOBLNK	EI
	HALT
	LD	A,7
BORDER1	EQU	$-1
	OUT	(#FE),A
	CALL	MRTOUT_A

	EI
	HALT
	LD	A,7
BORDER2	EQU	$-1
	OUT	(#FE),A
	CALL	MRTOUT_B

	CALL	MRTCLR
	CALL	NEXT
	
	EI
	HALT
	CALL	LAND1
	EI
	HALT
	CALL	LAND2
	EI
	HALT
	CALL	LAND3
	EI
	HALT
	CALL	LAND4

	XOR	A
	LD	(ISBLINK),A
	LD	(BORDER2),A
	
	RET
//======================================================== FX_PROCEDURES
NEXT	LD	A,(MDY)
	ADD	A,MDY_STEP
MDY_STEP_ADR EQU $-1
	AND	63
	LD	(MDY),A
	LD	A,(MDX)
	ADD	A,MDX_STEP
MDX_STEP_ADR EQU $-1
	AND	63
	LD	(MDX),A
	RET
;-------------------------
LHH	EQU	14

LAND4
	;LD	HL,MAPTBL + (2*32*LHH *3)
	LD	IY,#C080 + LHH*256*3
	EXX
	LD	L,LHH*3*3
	EXX
	LD	A,#18
	LD	LX,LHH
	JP	LANDSCAPE
LAND3
	;LD	HL,MAPTBL + (2*32*LHH *2)
	LD	IY,#C080 + LHH*256*2
	EXX
	LD	L,LHH*3*2
	EXX
	LD	A,#10
	LD	LX,LHH
	JP	LANDSCAPE

LAND2
	;LD	HL,MAPTBL + (2*32*LHH *1)
	LD	IY,#C080 + LHH*256*1
	EXX
	LD	L,LHH*3*1
	EXX
	LD	A,#18
	LD	LX,LHH
	JP	LANDSCAPE

LAND1
	;LD	HL,MAPTBL + (2*32*LHH *0)
	LD	IY,#C080 + LHH*256*0
	EXX
	LD	L,LHH*3*0
	EXX
	LD	A,#10
	LD	LX,LHH
	JP	LANDSCAPE
;-------------------------
LANDSCAPE
	CALL	PAGER
	;---
	LD	(SOHRSP),SP
	LD	DE,MDY0 * 256 + MDX0
MDX	EQU	$-2
MDY	EQU	$-1
	EXX
	LD	D,BUFF/256
	LD	C,D
	LD	B,L
	EXX
LP1	LD	SP,IY
	INC	HY
	;----------
	DUP	31
	;----------
	POP	HL	;10	HL = mapYX
	ADD	HL,DE	;11	HL+DE = mapYX+dYdX
	LD	A,H	;4	ограничниваем по Y областью #C0..#FF
	OR	#C0	;7
	LD	H,A	;4
	LD	A,(HL)	;7 /43	A = height
	;----
	EXX		;4
	LD	H,A	;4	H = height, L = scrY * 3
	LD	E,(HL)	;7	E = buffY
	INC	L	;4
	LDI		;16 /35 top color to buff
	;----
	LD	A,(HL)	;7	bottom color to buff 8 //52
	DUP	4
	LD	(DE),A	;7
	INC	E	;4 11*3=33
	EDUP
	LD	(DE),A	;7 /47
	;----
	LD	L,B	;4
	INC	D	;4
	EXX		;4 /12 //137
	;---
	EDUP
	;----------------------------
	POP	HL	;10	HL = mapYX
	ADD	HL,DE	;11	HL+DE = mapYX+dYdX
	LD	A,H	;4	ограничниваем по Y областью #C0..#FF
	OR	#C0	;7
	LD	H,A	;4
	LD	A,(HL)	;7 /43	A = height
	;----
	EXX		;4
	LD	H,A	;4	H = height, L = scrY * 3
	LD	E,(HL)	;7	E = buffY
	INC	L	;4
	LDI		;16 /35 top color to buff
	;----
	LD	A,(HL)	;7	bottom color to buff 8 //52
	DUP	4
	LD	(DE),A	;7
	INC	E	;4 11*3=33
	EDUP
	LD	(DE),A	;7 /47
	;---- next line
	LD	D,BUFF/256 ;7
	INC	L	;4
	LD	B,L	;4
	LD	C,D	;4
	EXX		;4
	;------------------
	DEC	LX
	JP	NZ,LP1
	;----
	LD	SP,0
SOHRSP	EQU $-2
	RET
;---------------------------------------------------------------
MRTCLR
	LD	(MRTCLR_SOHR_SP),SP
	;---
	LD	B,32
	LD	DE,0
	LD	HL,BUFF+26
MRTCLR1	LD	SP,HL
	DUP	13
	PUSH	DE
	EDUP
	INC	H
	DJNZ	MRTCLR1
	;---
	LD	SP,0
MRTCLR_SOHR_SP EQU $-2
	RET
;---------------------------------------------------------------
FX_BLINK
	LD	A,D
	XOR	#80
	LD	D,A
	LD	H,D
	LD	L,E
	INC	E
	LD	(HL),7*8+7
	LD	BC,767
	LDIR
	RET
;---------------------------------------------------------------
MRTOUT_A
	LD	A,#17
	LD	B,PAL_A / 256
	LD	DE,#D800
	JP	MRTOUT
;----------------
MRTOUT_B
	LD	A,#17+#08
	LD	B,PAL_B / 256
	LD	DE,#5800
	JP	MRTOUT
;------------------	
MRTOUT	;----
	EXX
	CALL	PAGER
	EXX

	LD	A,(BORDER2)
	OR	A
	JP	NZ,FX_BLINK
	LD	(BORDER1),A

	;----
MRTOUT0	LD	LX,24
	LD	L,low BUFF
	PUSH	DE
MRTOUT1	;---
	LD	H,BUFF / 256
	;-
	DUP	31
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4
	INC	H	;4
	EDUP
	;-
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	DE	;6
	INC	L	;4
	INC	L	;4
	;--
	DEC	LX	   ;8
	JP	NZ,MRTOUT1 ;10
	;----------------------
	POP	HL
	LD	LX,24
	LD	E,low BUFF + 1
	INC	B
MRTOUT3 ;---
	LD	D,BUFF / 256
	;-
	DUP	31
	LD	A,(DE)	;7
	LD	C,A	;4
	LD	A,(BC)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	L	;4
	INC	D	;4
	EDUP
	;-
	LD	A,(DE)	;7
	LD	C,A	;4
	LD	A,(BC)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	HL	;4
	INC	E	;4
	INC	E	;4
	;--
	DEC	LX	   ;8
	JP	NZ,MRTOUT3 ;10
	RET

//======================================================== FX_INCLUDE_DATA
	DISPLAY "CODE END ", /A, $
//======================================================== FX_TABLES
	ALIGN	256
PAL_A
	DB	#00,#00,#00,#04,#44,#04,#04,#04,#44,#47,#47
	DB	#01
	DB	#01
	DB	#05
	DB	#47
;----------------------------------------------
	ALIGN	256
PAL_AD
	DB	#00,#00,#00,#04*8,#40+4*8,#04*8,#04*8,#04*8,#40+4*8,#40+7*8,#40+7*8
	DB	#01*8
	DB	#01*8
	DB	#05*8
	DB	#40+7*8
;----------------------------------------------
	ALIGN	256
PAL_B
	DB	#00,#00,#00,#00,#00,#04,#44,#44,#44,#44,#44
	DB	#01
	DB	#41
	DB	#43
	DB	#47
;----------------------------------------------
	ALIGN	256
PAL_BD
	DB	#00,#00,#00,#00,#00,#04*8,#40+4*8,#40+4*8,#40+4*8,#40+4*8,#40+4*8
	DB	#01*8
	DB	#40+1*8
	DB	#40+3*8
	DB	#40+7*8
;----------------------------------------------
	ALIGN	256
BUFF

MAPTBL
	IF	MAKEFAZE = 1
		INCLUDE "bin/maptbl1_56.asm"
	ENDIF
	IF	MAKEFAZE = 2
		INCLUDE "bin/maptbl3_56.asm"
	ENDIF
	IF	MAKEFAZE = 3
		INCLUDE "bin/maptbl_56.asm"
	ENDIF	
	IF	MAKEFAZE = 4
		INCLUDE "bin/maptbl_56.asm"
	ENDIF
MAPTBL_END
	SAVEBIN "compile/landmap.bin", MAPTBL, MAPTBL_END-MAPTBL





	DISPLAY	"TBLYYY ", /A, TBLYYY
	DISPLAY	"TBLYYY SIZE ", /A, TBLYYY_END - TBLYYY
	;DISPLAY "MAPTBL ", /A, MAPTBL
	;DISPLAY "MAPTBL_SIZE ", /A, MAPTBL_END - MAPTBL
	DISPLAY	"BUFF ", /A, BUFF
	DISPLAY	"BUFF_END ", /A, (BUFF + 32*256)
	
	
	DISPLAY "BORDER1: ", /A, BORDER1
	DISPLAY "BORDER2: ", /A, BORDER2
	
	
	DISPLAY "MDY: ", /A, MDY