//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
SIZE_Y		EQU	48
CIRC_QTY	EQU	10
OUTCIRC_BC	EQU	64-12

TBL_NOISE	EQU	#BB00
TBL_BUFF	EQU	#BC00
TBL_ATTR	EQU	#BD00

	IF MACHINE_TYPE = MT_PENTAGON
W_OUTBUFF	EQU	74*2+2+37	;187
W_NOISE		EQU	74*6+6
W_HEADOUT	EQU	680-37-16+18
	ELSE
W_OUTBUFF	EQU	74*2+2+37 - 152
W_NOISE		EQU	74*6+6 - 152
W_HEADOUT	EQU	680-37-16+18 - 150
	ENDIF
	
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT

	LD	A,#17
	CALL	PAGER

	LD	HL,#4000
	LD	DE,#4001
	LD	BC,6143
	LD	(HL),#F0
	LDIR

	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6144
	LDIR

;---------------------------- make tbl attr
INI_ATTR	
	LD	DE,#5800
	LD	BC,32
	LD	HL,TBL_ATTR
	LD	A,24
INI_ATTR_1
	LD	(HL),E
	INC	L
	LD	(HL),D
	INC	L
	SET	7,D
	LD	(HL),E
	INC	L
	LD	(HL),D
	INC	L
	RES	7,D
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	A
	JP	NZ,INI_ATTR_1
;---------------------------- make tbl buff
	LD	DE,BUFF
	LD	BC,64
	LD	HL,TBL_BUFF
	LD	A,48
INI_BUFF_1
	LD	(HL),E
	INC	L
	LD	(HL),D
	INC	L
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	A
	JP	NZ,INI_BUFF_1
;---------------------------- make tbl noise	
	LD	HL,TBL_NOISE
INI_NOISE_1
	CALL	GET_RANDOM
	LD	C,0
	CP	48
	JP	NC,INI_NOISE_2
	LD	C,#01
INI_NOISE_2
	CALL	GET_RANDOM
	CP	200
	LD	A,#00
	JP	C,INI_NOISE_3
	LD	A,#10
INI_NOISE_3
	OR	C
	LD	(HL),A
	INC	L
	JP	NZ,INI_NOISE_1
	RET
	
//======================================================== FX_MAINLOOP
EFF_RUN_

	EI
	HALT
	CALL	NOISE

DDD	LD	A,0
	XOR	#FF
	LD	(DDD+1),A
	JP	Z,DDD2
	EI
	HALT
	CALL	NOISE
DDD2
	EI
	HALT
	CALL	HEADOUT
	EI
	HALT
	CALL	HEADOUT2

	EI
	HALT
	XOR	A
	OUT	(#FE),A
	CALL	OUTBUFF
	CALL	NEXT

	RET
//======================================================== FX_PROCEDURES
NEXT	LD	A,#FF
	INC	A
	CP	6
	JP	NZ,NEXT1
	XOR	A
NEXT1	LD	(NEXT+1),A
	ADD	A,A
	LD	L,A
	LD	H,0
	LD	BC,HEADTBL
	ADD	HL,BC
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	;--
	LD	(HSPR0+1),DE
	LD	HL,768
	ADD	HL,DE
	LD	(HSPR1+1),HL
	RET
HEADTBL	
	DW NOISEHEAD0
	DW NOISEHEAD1
	DW NOISEHEAD2
	DW NOISEHEAD3
	DW NOISEHEAD4
	DW NOISEHEAD5

GET_RANDOM
	LD  A,137
SEED	EQU	$-1
	LD	B,A
	ADD	A,A
	XOR	B
	LD	B,A
	SRL	A
	XOR	B
	LD	B,A
	ADD	A,A
	ADD	A,A
	XOR	B
	LD	(SEED),A
	RET
;---------------------------
NOISE_ADD EQU 34
NOISE_ADD2 EQU 63
NOISE
	LD	BC,W_NOISE
W2	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,W2 ;24
	
	LD	A,#17
	CALL	PAGER
	
	;-------------------------
	LD	(NOISE_SOHR_SP),SP
	;--
	CALL	GET_RANDOM
	AND	#1F
	LD	H,A
	CALL	GET_RANDOM
	LD	L,A
	LD	SP,HL
	;--
	LD	D,TBL_NOISE / 256
	;------------------------- fill right char
	LD	HL,BUFF + 31
	LD	LX,48
NOISE2	;---
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	E,B	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7 /50
	LD	BC,NOISE_ADD2
	ADD	HL,BC
	DEC	LX
	JP	NZ,NOISE2
	;-------------------------
	LD	HL,BUFF
	EXX
	LD	BC,#7FFD
	LD	DE,#1F17
	LD	L,24
NOISE1	EXX			; /=>869
	;----
	DUP	15
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	E,B	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /54 * 15 = 810
	;----
	EDUP
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7 /28
	;----
	NOP
	
	LD	BC,NOISE_ADD	;10
	ADD	HL,BC	;15 /25 /=>835
	;----
	EXX		;4
	IF MACHINE_TYPE = MT_ZX128 OR MACHINE_TYPE = MT_ZX2A
	  NOP:NOP:NOP:NOP
	ENDIF
	OUT	(C),E	;12
	EXX		;4 /20 /=>855
	;----------------
	DUP	15
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	E,B	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4 /54 * 15 = 810
	;----
	EDUP
	;----
	POP	BC	;10
	LD	E,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7 /28
	;---
	NOP:NOP:NOP:NOP
	;----
	LD	BC,NOISE_ADD	;10
	ADD	HL,BC	;15 /25 /=>835
	;----
	EXX		;4
	IF MACHINE_TYPE = MT_ZX128 OR MACHINE_TYPE = MT_ZX2A
	  NOP:NOP:NOP:NOP
	ENDIF
	OUT	(C),D	;12 /16 /=>851
	;----
	DEC	L	  ;4
	JP	NZ,NOISE1 ;10 /14 /=>865
	;----
	LD	SP,0
NOISE_SOHR_SP EQU $-2
	RET

;-869 27free
;-855 41free
;------------------------------------------------
HEADOUT2
HSPR1	LD	HL,NOISEHEAD0 + 768
	LD	DE,BUFF + 1536
	JP	HEADOUT_
HEADOUT
HSPR0	LD	HL,NOISEHEAD0
	LD	DE,BUFF
	JP	HEADOUT_
HEADOUT_
	LD	A,#18
	CALL	PAGER
	EX	AF,AF
	;--
	LD	BC,W_HEADOUT
HEAD2	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,HEAD2
	;--
	LD	LX,48
HEAD1	LD	B,DECTBL / 256 ;7
	;--
	DUP	15
	LD	A,(DE)	;7
	OR	(HL)	;7
	LD	C,A	;4
	;LD	A,(BC)	;7
	LD	(DE),A	;7
	LD	(DE),A	;7
	INC	L	;4
	INC	E	;4 /40*15 = 600
	EDUP
	;--
	LD	A,(DE)	;7
	OR	(HL)	;7
	LD	C,A	;4
	;LD	A,(BC)	;7
	LD	(DE),A	;7
	LD	(DE),A	;7
	INC	HL	;4
	INC	DE	;4 /42
	;--
	EX	AF,AF	;4
	XOR	#08	;7
	LD	BC,#7FFD ;10
	OUT	(C),A	;12
	EX	AF,AF	;4 /37
	
	IF MACHINE_TYPE = MT_PENTAGON
	 ;--w125
	  LD A,8
	  DEC A
	  JP NZ,$-1
	  DEC BC
	ELSE
	 ;--w141
	  LD A,8
	  DEC A
	  JR NZ,$-1
	  DEC BC
	  RET NZ
	ENDIF
	;---
HEAD3	LD	A,0		;7
	XOR	#FF		;7
	LD	(HEAD3 + 1),A	;13
	JP	Z,HEAD4		;10 /37
	;---
	NOP:NOP:NOP:LD A,0
	JP	HEAD5
	;---
HEAD4	EX	DE,HL	;4
	LD	BC,32	;10
	ADD	HL,BC	;11
	EX	DE,HL	;4 /29
HEAD5	;--
	DEC	LX	 ;8
	JP	NZ,HEAD1 ;10 /18
	;--
	RET
;------------------------------------------------
OUTBUFF	
	LD	BC,W_OUTBUFF
W1	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,W1 ;24
	;--
	LD	A,#17
	CALL	PAGER
	;-----------------------
	LD	(OUTBUFF_SOHR_SP),SP
	;----------------------- out right char column
	LD	HL,BUFF + 31
	LD	DE,#581F
	LD	LX,24
OUTBUFF4	
	LD	B,PAL / 256
	LD	A,(HL)
	LD	C,A
	LD	A,(BC)
	LD	(DE),A
	LD	BC,64
	ADD	HL,BC
	SET	7,D
	;-
	LD	B,PAL / 256
	LD	A,(HL)
	LD	C,A
	LD	A,(BC)
	LD	(DE),A
	LD	BC,64
	ADD	HL,BC
	RES	7,D
	EX	HL,DE
	LD	BC,32
	ADD	HL,BC
	EX	HL,DE
	DEC	LX
	JP	NZ,OUTBUFF4
	;----------------------- make ATTR ADR
	LD	HL,BUFF + 32
	LD	DE,TBL_ATTR + 2
	LD	BC,63
	LD	LX,SIZE_Y
OUTBUFF2 ;---
	LD	A,(DE)
	LD	(HL),A
	INC	E
	INC	L
	LD	A,(DE)
	LD	(HL),A
	INC	E
	ADD	HL,BC
	DEC	LX
	JP	NZ,OUTBUFF2
	;----------------------- make BUFF ADR
	LD	HL,BUFF + 34
	LD	DE,TBL_BUFF + 2
	LD	BC,63
	LD	LX,SIZE_Y
OUTBUFF3 ;---
	LD	A,(DE)
	LD	(HL),A
	INC	E
	INC	L
	LD	A,(DE)
	LD	(HL),A
	INC	E
	ADD	HL,BC
	DEC	LX
	JP	NZ,OUTBUFF3
OUTBUFF_MAIN	;-----------------------
	LD	BC,#7FFD	;7FFD
	LD	DE,#1F17	;171F
	EXX
	LD	SP,BUFF
	LD	DE,#5800
	LD	B,PAL / 256
	LD	LX,24
OUTBUFF1 ;-----
	DUP	15
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4
	LD	C,H	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4 /54 * 15 = 810
	;-----
	EDUP
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7 /28 /=>838
XXX	;-
	POP	DE	;10
	POP	HL	;10
	LD	SP,HL	;6 /26 /=> 864
	;-
	EXX		;4
	OUT	(C),E	;12
	IF MACHINE_TYPE = MT_PENTAGON
	  DEC HL	;wait6
	ENDIF
	EXX		;4 /20 /=>884 ;12free
	;---------------------
	DUP	15
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4
	LD	C,H	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4 /54 * 15 = 810
	;-----
	EDUP
	;-----
	POP	HL	;10
	LD	C,L	;4
	LD	A,(BC)	;7
	LD	(DE),A	;7 /28 /=>838
	;-
	POP	DE	;10
	POP	HL	;10
	LD	SP,HL	;6 /26 /=> 864
	;-
	EXX		;4
	OUT	(C),D	;12
	EXX		;4 /20 /=>884 ;12free
	;-
	DEC	LX	    ;8
	JP	NZ,OUTBUFF1 ;10 /18
	;-----
	LD	SP,0
OUTBUFF_SOHR_SP EQU $-2
	RET


//======================================================== FX_INCLUDE_DATA
//======================================================== FX_TABLES
	ALIGN	256
PAL	INCBIN "bin/noisehead_palette.bin"
	ALIGN	256
DECTBL	
	INCBIN "bin/tbl_sub.bin"
;--------------------

NOISEHEAD0 INCLUDE "bin/noisehead0.asm"
NOISEHEAD1 INCLUDE "bin/noisehead1.asm"
NOISEHEAD2 INCLUDE "bin/noisehead2.asm"
NOISEHEAD3 INCLUDE "bin/noisehead3.asm"
NOISEHEAD4 INCLUDE "bin/noisehead4.asm"
NOISEHEAD5 INCLUDE "bin/noisehead5.asm"

	ALIGN	256
BUFF	EQU	$
;--------------------
	DISPLAY "NOISEHEAD BUFF ", /A, BUFF

