//Rocket listeners
//Dependent on TDEMO.MAIN
var initRocketListeners = function(audio){
    
    var conf = TDEMO.SYNC.getConfig();
    var syncDevice = TDEMO.SYNC.getSyncDevice();
    
    //Event handlers for sync device
    var onSyncUpdate = function(row){
        if (!isNaN(row)) {
            conf.setRow(row);
        }
        TDEMO.MAIN.mainloop();
    };

    var onPlay = function (){
        audio.currentTime = conf.getRow()/conf.getRowRate();
        audio.play();
        TDEMO.MAIN.mainloop();
    };

    var onPause = function (){
        conf.setRow(audio.currentTime * conf.getRowRate());
        window.cancelAnimationFrame(TDEMO.MAIN.mainloop);
        audio.pause();
    };
    
    syncDevice.on('update', onSyncUpdate);
    syncDevice.on('play', onPlay);
    syncDevice.on('pause', onPause);
}