var Text = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(2);
    this.setDoF({
        focus: 0.2,
        maxblur: 0.25,
        aparture: 0.025
    });


    var paragraphs = [
        "Deadline Driven Development"
    ];

    this.teksti = this.createText(paragraphs);
    this.scene.add(this.teksti);
    this.texture = TDEMO.TEXTURES.getTextures().kalat_lila;
    this.createSurroundings();
};

Text.prototype = PartBase.prototype.inheritance();

Text.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var hb = TDEMO.SYNC.getHeartBeat();
    this.texture.offset.x = hb*1.5;
    this.texture.offset.y = hb;
    this.texture.needsUpdate = true;

    var pos = TDEMO.SYNC.getObjPosition();
    this.teksti.position.x = pos.x;
    this.teksti.position.y = pos.y;
    this.teksti.position.z = pos.z;

    var rot = TDEMO.SYNC.getObjRotation();
    this.teksti.rotation.x = rot.x;
    this.teksti.rotation.y = rot.y;
    this.teksti.rotation.z = rot.z;
};

Text.prototype.createText = function(paragraphs){

    var texts = new THREE.Object3D();
  
    var material = [
        new THREE.MeshBasicMaterial( { color: 0xFF00FF } ),
        new THREE.MeshBasicMaterial( { color: 0x00FFFF } )
    ];

    var options = {
        font: TDEMO.font,
        size: 70,
        height: 25,
        curveSegments: 12,
        bevelEnabled: true,
        bevelThickness: 10,
        bevelSize: 8,
        bevelSegments: 5
    };

    var rowHeight = 90;
    var yPos = 0;
    var zPos = 0;

    for(var i = 0; i < paragraphs.length; ++i){
        var geometry = new THREE.TextGeometry(paragraphs[i], options);
        geometry.computeBoundingBox();
        geometry.computeVertexNormals();
        var centerOffset = -0.5*(geometry.boundingBox.max.x-geometry.boundingBox.min.x);
        
        var mesh = new THREE.Mesh(geometry, material);
        mesh.position.x = centerOffset;
        mesh.position.y = yPos - rowHeight*i;
        mesh.position.z = zPos*i;

        texts.add(mesh);
    }
    return texts;
};

Text.prototype.createSurroundings = function(){

    //this.scene.fog = new THREE.Fog(0x5D478B, 200, 600);
    var material = new THREE.MeshBasicMaterial({map: this.texture, side: THREE.BackSide});
    this.skySphere = new THREE.Mesh(new THREE.SphereGeometry(800, 64, 64), material);
    this.skySphere.rotation.x = -Math.PI/2;
    this.scene.add(this.skySphere);
}
