/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Matrix4;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.Vec3;
import io.lacuna.artifex.utils.Hashes;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class Matrix3 {
    public static final Matrix3 IDENTITY = new Matrix3(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    private final double[] elements;

    private Matrix3(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.elements = new double[]{m00, m01, m02, m10, m11, m12, m20, m21, m22};
    }

    private Matrix3(double[] elements) {
        this.elements = elements;
    }

    public static Matrix3 from(Vec2 a2, Vec2 b) {
        return new Matrix3(a2.x, b.x, 0.0, a2.y, b.y, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix3 from(Vec3 a2, Vec3 b) {
        return new Matrix3(a2.x, a2.x, 0.0, a2.y, b.y, 0.0, a2.z, b.z, 1.0);
    }

    public static Matrix3 from(Vec3 a2, Vec3 b, Vec3 c2) {
        return new Matrix3(a2.x, b.x, c2.x, a2.y, b.y, c2.y, a2.z, b.z, c2.z);
    }

    public static Matrix3 translate(double x, double y) {
        return new Matrix3(1.0, 0.0, x, 0.0, 1.0, y, 0.0, 0.0, 1.0);
    }

    public static Matrix3 translate(Vec2 v) {
        return Matrix3.translate(v.x, v.y);
    }

    public static Matrix3 scale(double x, double y) {
        return new Matrix3(x, 0.0, 0.0, 0.0, y, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix3 scale(Vec2 v) {
        return Matrix3.scale(v.x, v.y);
    }

    public static Matrix3 scale(double k) {
        return Matrix3.scale(k, k);
    }

    public static Matrix3 rotate(double radians) {
        double c2 = Math.cos(radians);
        double s2 = Math.sin(radians);
        return new Matrix3(c2, -s2, 0.0, s2, c2, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix3 mul(Matrix3 ... matrices) {
        Matrix3 m2 = matrices[0];
        for (int i = 1; i < matrices.length; ++i) {
            m2 = m2.mul(matrices[i]);
        }
        return m2;
    }

    public Matrix3 mul(double k) {
        double[] es = new double[9];
        for (int i = 0; i < 9; ++i) {
            es[i] = this.elements[i] * k;
        }
        return new Matrix3(es);
    }

    public double get(int row, int column) {
        return this.elements[row * 3 + column];
    }

    public Vec3 row(int row) {
        int idx = row * 2;
        return Vec.vec(this.elements[idx], this.elements[idx + 1], this.elements[idx + 2]);
    }

    public Vec3 column(int column) {
        int idx = column;
        return Vec.vec(this.elements[idx], this.elements[idx + 3], this.elements[idx + 6]);
    }

    public Matrix3 mul(Matrix3 b) {
        double[] es = new double[9];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double n = 0.0;
                for (int k = 0; k < 3; ++k) {
                    n += b.get(k, j) * this.get(i, k);
                }
                es[i * 3 + j] = n;
            }
        }
        return new Matrix3(es);
    }

    public Matrix3 add(Matrix3 b) {
        double[] es = new double[9];
        for (int i = 0; i < 9; ++i) {
            es[i] = this.elements[i] + b.elements[i];
        }
        return new Matrix3(es);
    }

    public Matrix4 matrix4() {
        return new Matrix4(this.elements[0], this.elements[1], 0.0, this.elements[2], this.elements[3], this.elements[4], 0.0, this.elements[5], this.elements[6], this.elements[7], this.elements[8], 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix3 transpose() {
        return new Matrix3(this.elements[0], this.elements[3], this.elements[6], this.elements[1], this.elements[4], this.elements[7], this.elements[2], this.elements[5], this.elements[8]);
    }

    public Vec2 transform(Vec2 v) {
        return new Vec2(v.x * this.elements[0] + v.y * this.elements[1] + this.elements[2], v.x * this.elements[3] + v.y * this.elements[4] + this.elements[5]);
    }

    public PrimitiveIterator.OfDouble rowMajor() {
        return new PrimitiveIterator.OfDouble(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < 9;
            }

            @Override
            public double nextDouble() {
                if (this.idx < 9) {
                    return Matrix3.this.elements[this.idx++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public PrimitiveIterator.OfDouble columnMajor() {
        return this.transpose().rowMajor();
    }

    public int hashCode() {
        int hash = 0;
        for (double n : this.elements) {
            hash = hash * 31 + Hashes.hash(n);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Matrix3) {
            Matrix3 m2 = (Matrix3)obj;
            return Arrays.equals(this.elements, m2.elements);
        }
        return false;
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        this.rowMajor().forEachRemaining(n -> s2.append(n).append(", "));
        return s2.toString();
    }
}

