/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex.utils;

import io.lacuna.artifex.Curve2;
import io.lacuna.artifex.Path2;
import io.lacuna.artifex.Region2;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import io.lacuna.bifurcan.LinearList;

public class PathSweep {
    private static Vec2 transpose(Vec2 v) {
        return Vec.vec(-v.y, v.x);
    }

    private static Vec2 miter(Curve2 a2, Curve2 b) {
        Vec2 l1 = (Vec2)a2.end().norm();
        Vec2 l2 = (Vec2)b.start().norm();
        Vec2 tangent = (Vec2)l1.add(l2).div(2.0);
        Vec2 miter = PathSweep.transpose(tangent);
        Vec2 normal = PathSweep.transpose(l1);
        return (Vec2)miter.div(Vec.dot(miter, normal));
    }

    public static Region2 sweep(Path2 path, double width) {
        Curve2[] curves = path.curves();
        Vec2[] miters = new Vec2[curves.length + 1];
        for (int i = 1; i < curves.length; ++i) {
            miters[i] = PathSweep.miter(curves[i - 1], curves[i]);
        }
        LinearList above = new LinearList();
        LinearList below = new LinearList();
        LinearList result = new LinearList();
        if (path.isRing()) {
            miters[0] = PathSweep.miter(curves[curves.length - 1], curves[0]);
            miters[miters.length - 1] = miters[0];
        } else {
            miters[0] = (Vec2)PathSweep.transpose(curves[0].start()).norm();
            miters[miters.length - 1] = (Vec2)PathSweep.transpose(curves[curves.length - 1].end()).norm();
        }
        return null;
    }
}

