/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.Graphs;
import io.lacuna.bifurcan.IEdge;
import io.lacuna.bifurcan.IGraph;
import io.lacuna.bifurcan.IMap;
import io.lacuna.bifurcan.Map;
import io.lacuna.bifurcan.Set;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class Graph<V, E>
implements IGraph<V, E> {
    private static final Object DEFAULT = new Object();
    private final Object editor;
    private Map<V, Set<V>> adjacent;
    private Map<VertexSet<V>, E> edges;

    public Graph() {
        this(xva$0 -> Objects.hash(xva$0), Objects::equals);
    }

    public Graph(ToIntFunction<V> hashFn, BiPredicate<V, V> equalsFn) {
        this(false, new Map(hashFn, equalsFn), new Map(t2 -> t2.hashCode(hashFn), (a2, b) -> a2.equals(equalsFn, b)));
    }

    private Graph(boolean linear, Map<V, Set<V>> adjacent, Map<VertexSet<V>, E> edges2) {
        this.editor = linear ? new Object() : null;
        this.adjacent = adjacent;
        this.edges = edges2;
    }

    @Override
    public Set<V> vertices() {
        return this.adjacent.keys();
    }

    @Override
    public Iterable<IEdge<V, E>> edges() {
        return () -> this.edges.stream().map(e -> new Graphs.Edge(e.value(), ((VertexSet)e.key()).v, ((VertexSet)e.key()).w)).iterator();
    }

    @Override
    public E edge(V from, V to) {
        Object e = this.edges.get(new VertexSet<V>(from, to), DEFAULT);
        if (e == DEFAULT) {
            throw new IllegalArgumentException("no such edge");
        }
        return (E)e;
    }

    @Override
    public Set<V> in(V vertex) {
        return this.out((Object)vertex);
    }

    @Override
    public Set<V> out(V vertex) {
        return (Set)this.adjacent.get(vertex).orElseThrow(() -> new IllegalArgumentException("no such vertex " + vertex));
    }

    @Override
    public Graph<V, E> link(V from, V to, E edge, BinaryOperator<E> merge) {
        Object editor = this.isLinear() ? this.editor : new Object();
        Map<Set<V>, Set<Set<V>>> adjacentPrime = this.adjacent.update(from, s2 -> (s2 == null ? new Set() : s2).add(to, editor), editor).update(to, s2 -> (s2 == null ? new Set() : s2).add(from, editor), editor);
        Map<VertexSet<E>, E> edgesPrime = this.edges.put(new VertexSet<V>(from, to), edge, merge, editor);
        if (this.isLinear()) {
            this.adjacent = adjacentPrime;
            this.edges = edgesPrime;
            return this;
        }
        return new Graph<Set<V>, E>(false, adjacentPrime, edgesPrime);
    }

    @Override
    public Graph<V, E> unlink(V from, V to) {
        VertexSet<V> t2 = new VertexSet<V>(from, to);
        if (!this.edges.contains(t2)) {
            return this;
        }
        Object editor = this.isLinear() ? this.editor : new Object();
        Map<VertexSet<E>, E> edgesPrime = this.edges.remove(t2, editor);
        Map<V, Set<V>> adjacentPrime = this.adjacent.update(from, s2 -> s2.remove(to, editor), editor).update(to, s2 -> s2.remove(from, editor), editor);
        if (this.isLinear()) {
            this.edges = edgesPrime;
            return this;
        }
        return new Graph<V, E>(false, adjacentPrime, edgesPrime);
    }

    @Override
    public Graph<V, E> add(V vertex) {
        if (this.adjacent.contains(vertex)) {
            return this;
        }
        Object editor = this.isLinear() ? this.editor : new Object();
        Map<Set<V>, Set<Set<V>>> adjacentPrime = this.adjacent.put(vertex, new Set(), Graphs.MERGE_LAST_WRITE_WINS, editor);
        if (this.isLinear()) {
            this.adjacent = adjacentPrime;
            return this;
        }
        return new Graph<Set<V>, E>(false, adjacentPrime, this.edges);
    }

    @Override
    public Graph<V, E> remove(V vertex) {
        if (!this.adjacent.contains(vertex)) {
            return this;
        }
        Object editor = this.isLinear() ? this.editor : new Object();
        IMap adjacentPrime = this.adjacent.linear();
        IMap edgesPrime = this.edges.linear();
        for (Object w : (Set)this.adjacent.get(vertex).get()) {
            ((Map)adjacentPrime).update(w, s2 -> s2.remove(vertex, editor));
            ((Map)edgesPrime).remove(new VertexSet(w, vertex), editor);
        }
        edgesPrime = ((Map)edgesPrime).forked();
        adjacentPrime = ((Map)((Map)adjacentPrime).remove(vertex)).forked();
        if (this.isLinear()) {
            this.adjacent = adjacentPrime;
            this.edges = edgesPrime;
            return this;
        }
        return new Graph<V, E>(false, adjacentPrime, edgesPrime);
    }

    @Override
    public <U> Graph<V, U> mapEdges(Function<IEdge<V, E>, U> f) {
        return new Graph<V, E>(this.isLinear(), this.adjacent, this.edges.mapValues((k, v) -> f.apply(new Graphs.Edge(v, k.v, k.w))));
    }

    @Override
    public boolean isLinear() {
        return this.editor != null;
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public Graph<V, E> transpose() {
        return this;
    }

    @Override
    public ToIntFunction<V> vertexHash() {
        return this.adjacent.keyHash();
    }

    @Override
    public BiPredicate<V, V> vertexEquality() {
        return this.adjacent.keyEquality();
    }

    @Override
    public Graph<V, E> merge(IGraph<V, E> graph, BinaryOperator<E> merge) {
        if (graph instanceof Graph) {
            Graph g = (Graph)graph;
            return new Graph<V, E>(this.isLinear(), this.adjacent.merge(g.adjacent, Set::union), this.edges.merge(g.edges, (BinaryOperator)merge));
        }
        return (Graph)Graphs.merge(this, graph, merge);
    }

    @Override
    public Graph<V, E> forked() {
        return this.isLinear() ? new Graph<V, E>(false, this.adjacent, this.edges) : this;
    }

    @Override
    public Graph<V, E> linear() {
        return this.isLinear() ? this : new Graph<V, E>(true, this.adjacent, this.edges);
    }

    public int hashCode() {
        return ((Set)this.adjacent.keys()).hashCode() ^ this.edges.hashCode();
    }

    @Override
    public Graph<V, E> clone() {
        return new Graph<V, E>(this.isLinear(), this.adjacent.clone(), this.edges.clone());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Graph) {
            Graph g = (Graph)obj;
            return this.edges.equals(g.edges) && ((Set)this.vertices()).equals(g.vertices());
        }
        if (obj instanceof IGraph) {
            return Graphs.equals(this, (IGraph)obj);
        }
        return false;
    }

    public String toString() {
        return this.adjacent.toString();
    }

    private static class VertexSet<V> {
        final V v;
        final V w;

        VertexSet(V v, V w) {
            this.v = v;
            this.w = w;
        }

        int hashCode(ToIntFunction<V> hashFn) {
            return hashFn.applyAsInt(this.v) ^ hashFn.applyAsInt(this.w);
        }

        boolean equals(BiPredicate<V, V> equalsFn, VertexSet<V> t2) {
            return equalsFn.test(this.v, t2.v) && equalsFn.test(this.w, t2.w) || equalsFn.test(this.v, t2.w) && equalsFn.test(this.w, t2.v);
        }
    }
}

