/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.LinearMap;
import io.lacuna.bifurcan.List;
import io.lacuna.bifurcan.Lists;
import io.lacuna.bifurcan.Sets;
import io.lacuna.bifurcan.utils.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class LinearSet<V>
implements ISet<V>,
Cloneable {
    LinearMap<V, Void> map;

    public static <V> LinearSet<V> from(IList<V> elements) {
        return LinearSet.from(elements.toList());
    }

    public static <V> LinearSet<V> from(Collection<V> elements) {
        return elements.stream().collect(Sets.linearCollector(elements.size()));
    }

    public static <V> LinearSet<V> from(Iterator<V> iterator2) {
        LinearSet<V> set = new LinearSet<V>();
        iterator2.forEachRemaining(object -> this.add(object));
        return set;
    }

    public static <V> LinearSet<V> from(Iterable<V> iterable) {
        return LinearSet.from(iterable.iterator());
    }

    public static <V> LinearSet<V> from(ISet<V> set) {
        if (set instanceof LinearSet) {
            return ((LinearSet)set).clone();
        }
        LinearSet<V> result = new LinearSet<V>((int)set.size(), set.valueHash(), set.valueEquality());
        set.forEach(object -> this.add(object));
        return result;
    }

    public static <V> LinearSet<V> of(V ... elements) {
        LinearSet<V> set = new LinearSet<V>(elements.length);
        for (V e : elements) {
            set.add((Object)e);
        }
        return set;
    }

    public LinearSet() {
        this(8);
    }

    public LinearSet(int initialCapacity) {
        this(initialCapacity, Objects::hashCode, Objects::equals);
    }

    public LinearSet(int initialCapacity, ToIntFunction<V> hashFn, BiPredicate<V, V> equalsFn) {
        this.map = new LinearMap(initialCapacity, hashFn, equalsFn);
    }

    public LinearSet(ToIntFunction<V> hashFn, BiPredicate<V, V> equalsFn) {
        this.map = new LinearMap(8, hashFn, equalsFn);
    }

    LinearSet(LinearMap<V, Void> map2) {
        this.map = map2;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public ToIntFunction<V> valueHash() {
        return this.map.keyHash();
    }

    @Override
    public BiPredicate<V, V> valueEquality() {
        return this.map.keyEquality();
    }

    @Override
    public LinearSet<V> add(V value2) {
        this.map.put((Object)value2, (Object)null);
        return this;
    }

    @Override
    public LinearSet<V> remove(V value2) {
        this.map.remove((Object)value2);
        return this;
    }

    public LinearSet<V> clear() {
        this.map.clear();
        return this;
    }

    @Override
    public boolean contains(V value2) {
        return this.map.contains(value2);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public long indexOf(V element) {
        return this.map.indexOf(element);
    }

    @Override
    public V nth(long index) {
        return this.map.nth(index).key();
    }

    @Override
    public Iterator<V> iterator() {
        Object[] entries = this.map.entries;
        return Iterators.range(this.size(), i -> entries[(int)i << 1]);
    }

    @Override
    public <U> LinearMap<V, U> zip(Function<V, U> f) {
        return this.map.mapValues((k, v) -> f.apply(k));
    }

    @Override
    public LinearSet<V> union(ISet<V> s2) {
        if (s2 instanceof LinearSet) {
            return new LinearSet<V>(this.map.union(((LinearSet)s2).map));
        }
        Object m2 = this.map.clone();
        s2.forEach(e -> this.map.put(e, (Object)null));
        return new LinearSet<V>(m2);
    }

    @Override
    public LinearSet<V> difference(ISet<V> s2) {
        if (s2 instanceof LinearSet) {
            return new LinearSet<V>(this.map.difference(((LinearSet)s2).map));
        }
        Object m2 = this.map.clone();
        s2.forEach(((LinearMap)m2)::remove);
        return new LinearSet<V>(m2);
    }

    @Override
    public LinearSet<V> intersection(ISet<V> s2) {
        if (s2 instanceof LinearSet) {
            return new LinearSet<V>(this.map.intersection(((LinearSet)s2).map));
        }
        Object m2 = this.map.clone();
        for (V e : this) {
            if (s2.contains(e)) continue;
            ((LinearMap)m2).remove(e);
        }
        return new LinearSet<V>(m2);
    }

    @Override
    public ISet<V> forked() {
        return new Sets.VirtualSet(this);
    }

    @Override
    public LinearSet<V> linear() {
        return this;
    }

    @Override
    public List<LinearSet<V>> split(int parts) {
        return this.map.split(parts).stream().map(m2 -> new LinearSet(m2)).collect(Lists.collector());
    }

    public int hashCode() {
        int hash = 0;
        for (long row : this.map.table) {
            if (!LinearMap.Row.populated(row)) continue;
            hash += LinearMap.Row.hash(row);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ISet) {
            return Sets.equals(this, (ISet)obj);
        }
        return false;
    }

    @Override
    public LinearSet<V> clone() {
        return new LinearSet<V>(this.map.clone());
    }

    public String toString() {
        return Sets.toString(this);
    }
}

