/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.channels;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.channels.AbstractChannel;
import kotlinx.coroutines.channels.AbstractChannelKt;
import kotlinx.coroutines.channels.AbstractSendChannel;
import kotlinx.coroutines.channels.BroadcastChannel;
import kotlinx.coroutines.channels.Closed;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.ReceiveOrClosed;
import kotlinx.coroutines.channels.Send;
import kotlinx.coroutines.internal.ConcurrentKt;
import kotlinx.coroutines.selects.SelectInstance;
import kotlinx.coroutines.selects.SelectKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00016B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010 \u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010&\u001a\u00020\u0015H\u0002J\u0015\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010,J!\u0010-\u001a\u00020\t2\u0006\u0010+\u001a\u00028\u00002\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0014\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00028\u000002H\u0016J-\u00103\u001a\u00020$2\u0010\b\u0002\u00104\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001d2\u0010\b\u0002\u00105\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001dH\u0082\u0010R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00178TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001b\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001d0\u001cj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lkotlinx/coroutines/channels/ArrayBroadcastChannel;", "E", "Lkotlinx/coroutines/channels/AbstractSendChannel;", "Lkotlinx/coroutines/channels/BroadcastChannel;", "capacity", "", "(I)V", "buffer", "", "", "[Ljava/lang/Object;", "bufferDebugString", "", "getBufferDebugString", "()Ljava/lang/String;", "bufferLock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/coroutines/internal/ReentrantLock;", "getCapacity", "()I", "head", "", "isBufferAlwaysFull", "", "()Z", "isBufferFull", "size", "subscribers", "", "Lkotlinx/coroutines/channels/ArrayBroadcastChannel$Subscriber;", "Lkotlinx/coroutines/internal/SubscribersList;", "tail", "cancel", "cause", "", "checkSubOffers", "", "close", "computeMinHead", "elementAt", "index", "(J)Ljava/lang/Object;", "offerInternal", "element", "(Ljava/lang/Object;)Ljava/lang/Object;", "offerSelectInternal", "select", "Lkotlinx/coroutines/selects/SelectInstance;", "(Ljava/lang/Object;Lkotlinx/coroutines/selects/SelectInstance;)Ljava/lang/Object;", "openSubscription", "Lkotlinx/coroutines/channels/ReceiveChannel;", "updateHead", "addSub", "removeSub", "Subscriber", "kotlinx-coroutines-core"})
public final class ArrayBroadcastChannel<E>
extends AbstractSendChannel<E>
implements BroadcastChannel<E> {
    private final ReentrantLock bufferLock;
    private final Object[] buffer;
    private volatile long head;
    private volatile long tail;
    private volatile int size;
    private final List<Subscriber<E>> subscribers;
    private final int capacity;

    @Override
    protected boolean isBufferAlwaysFull() {
        return false;
    }

    @Override
    protected boolean isBufferFull() {
        return this.size >= this.capacity;
    }

    @Override
    @NotNull
    public ReceiveChannel<E> openSubscription() {
        Subscriber subscriber;
        Subscriber it = subscriber = new Subscriber(this);
        ArrayBroadcastChannel.updateHead$default(this, it, null, 2, null);
        return subscriber;
    }

    @Override
    public boolean close(@Nullable Throwable cause) {
        if (!super.close(cause)) {
            return false;
        }
        this.checkSubOffers();
        return true;
    }

    @Override
    public boolean cancel(@Nullable Throwable cause) {
        boolean bl;
        boolean it = bl = this.close(cause);
        for (Subscriber<E> sub : this.subscribers) {
            sub.cancel(cause);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Object offerInternal(E element) {
        ReentrantLock $receiver$iv = this.bufferLock;
        Lock lock = $receiver$iv;
        lock.lock();
        try {
            Closed<?> closed = this.getClosedForSend();
            if (closed != null) {
                Closed<?> closed2;
                Closed<?> it;
                Closed<?> closed3 = it = (closed2 = closed);
                return closed3;
            }
            int size = this.size;
            if (size >= this.capacity) {
                Object object = AbstractChannelKt.OFFER_FAILED;
                return object;
            }
            long tail = this.tail;
            this.buffer[(int)(tail % (long)this.capacity)] = element;
            this.size = size + 1;
            this.tail = tail + 1L;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.checkSubOffers();
        return AbstractChannelKt.OFFER_SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Object offerSelectInternal(E element, @NotNull SelectInstance<?> select) {
        Intrinsics.checkParameterIsNotNull(select, "select");
        ReentrantLock $receiver$iv = this.bufferLock;
        Lock lock = $receiver$iv;
        lock.lock();
        try {
            Closed<?> closed = this.getClosedForSend();
            if (closed != null) {
                Closed<?> closed2;
                Closed<?> it;
                Closed<?> closed3 = it = (closed2 = closed);
                return closed3;
            }
            int size = this.size;
            if (size >= this.capacity) {
                Object object = AbstractChannelKt.OFFER_FAILED;
                return object;
            }
            if (!select.trySelect(null)) {
                Object object = SelectKt.getALREADY_SELECTED();
                return object;
            }
            long tail = this.tail;
            this.buffer[(int)(tail % (long)this.capacity)] = element;
            this.size = size + 1;
            this.tail = tail + 1L;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.checkSubOffers();
        return AbstractChannelKt.OFFER_SUCCESS;
    }

    private final void checkSubOffers() {
        boolean updated = false;
        boolean hasSubs = false;
        for (Subscriber<E> sub : this.subscribers) {
            hasSubs = true;
            if (!sub.checkOffer()) continue;
            updated = true;
        }
        if (updated || !hasSubs) {
            ArrayBroadcastChannel.updateHead$default(this, null, null, 3, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateHead(Subscriber<E> addSub, Subscriber<E> removeSub) {
        while (true) {
            Send send = null;
            Object token = null;
            ReentrantLock $receiver$iv = this.bufferLock;
            Lock lock = $receiver$iv;
            lock.lock();
            try {
                Send send2;
                int size;
                long tail;
                block17: {
                    if (addSub != null) {
                        addSub.subHead = this.tail;
                        boolean wasEmpty = this.subscribers.isEmpty();
                        this.subscribers.add(addSub);
                        if (!wasEmpty) {
                            return;
                        }
                    }
                    if (removeSub != null) {
                        this.subscribers.remove(removeSub);
                        if (this.head != removeSub.subHead) {
                            return;
                        }
                    }
                    long minHead = this.computeMinHead();
                    tail = this.tail;
                    long head = this.head;
                    long targetHead = RangesKt.coerceAtMost(minHead, tail);
                    if (targetHead <= head) {
                        return;
                    }
                    size = this.size;
                    block8: while (head < targetHead) {
                        Send send3;
                        this.buffer[(int)(head % (long)this.capacity)] = null;
                        boolean wasFull = size >= this.capacity;
                        this.head = ++head;
                        this.size = --size;
                        if (!wasFull) continue;
                        do {
                            if (this.takeFirstSendOrPeekClosed() == null) continue block8;
                            if (send instanceof Closed) continue block8;
                            send3 = send;
                            if (send3 != null) continue;
                            Intrinsics.throwNpe();
                        } while ((token = send3.tryResumeSend(null)) == null);
                        send2 = send;
                        if (send2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlinx.coroutines.channels.Send");
                        }
                        break block17;
                    }
                    return;
                }
                this.buffer[(int)(tail % (long)this.capacity)] = send2.getPollResult();
                this.size = size + 1;
                this.tail = tail + 1L;
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            Send send4 = send;
            if (send4 == null) {
                Intrinsics.throwNpe();
            }
            send4.completeResumeSend(token);
            this.checkSubOffers();
            removeSub = null;
            addSub = null;
        }
    }

    static /* synthetic */ void updateHead$default(ArrayBroadcastChannel arrayBroadcastChannel, Subscriber subscriber, Subscriber subscriber2, int n, Object object) {
        if ((n & 1) != 0) {
            subscriber = null;
        }
        if ((n & 2) != 0) {
            subscriber2 = null;
        }
        arrayBroadcastChannel.updateHead(subscriber, subscriber2);
    }

    private final long computeMinHead() {
        long minHead = Long.MAX_VALUE;
        for (Subscriber<E> sub : this.subscribers) {
            minHead = RangesKt.coerceAtMost(minHead, sub.subHead);
        }
        return minHead;
    }

    private final E elementAt(long index) {
        return (E)this.buffer[(int)(index % (long)this.capacity)];
    }

    @Override
    @NotNull
    protected String getBufferDebugString() {
        return "(buffer:capacity=" + this.buffer.length + ",size=" + this.size + ')';
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public ArrayBroadcastChannel(int capacity) {
        boolean bl;
        this.capacity = capacity;
        boolean bl2 = bl = this.capacity >= 1;
        if (!bl) {
            String string = "ArrayBroadcastChannel capacity must be at least 1, but " + this.capacity + " was specified";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.bufferLock = new ReentrantLock();
        this.buffer = new Object[this.capacity];
        this.subscribers = ConcurrentKt.subscriberList();
    }

    public static final /* synthetic */ void access$setTail$p(ArrayBroadcastChannel $this, long l) {
        $this.tail = l;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\bH\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0014J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkotlinx/coroutines/channels/ArrayBroadcastChannel$Subscriber;", "E", "Lkotlinx/coroutines/channels/AbstractChannel;", "Lkotlinx/coroutines/channels/ReceiveChannel;", "broadcastChannel", "Lkotlinx/coroutines/channels/ArrayBroadcastChannel;", "(Lkotlinx/coroutines/channels/ArrayBroadcastChannel;)V", "isBufferAlwaysEmpty", "", "()Z", "isBufferAlwaysFull", "isBufferEmpty", "isBufferFull", "subHead", "", "subLock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/coroutines/internal/ReentrantLock;", "cancel", "cause", "", "checkOffer", "clearBuffer", "", "needsToCheckOfferWithoutLock", "peekUnderLock", "", "pollInternal", "pollSelectInternal", "select", "Lkotlinx/coroutines/selects/SelectInstance;", "kotlinx-coroutines-core"})
    private static final class Subscriber<E>
    extends AbstractChannel<E>
    implements ReceiveChannel<E> {
        private final ReentrantLock subLock;
        @JvmField
        public volatile long subHead;
        private final ArrayBroadcastChannel<E> broadcastChannel;

        @Override
        protected boolean isBufferAlwaysEmpty() {
            return false;
        }

        @Override
        protected boolean isBufferEmpty() {
            return this.subHead >= ((ArrayBroadcastChannel)this.broadcastChannel).tail;
        }

        @Override
        protected boolean isBufferAlwaysFull() {
            String string = "Should not be used";
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Override
        protected boolean isBufferFull() {
            String string = "Should not be used";
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Override
        public boolean cancel(@Nullable Throwable cause) {
            boolean bl = this.close(cause);
            boolean closed = bl;
            if (closed) {
                ArrayBroadcastChannel.updateHead$default(this.broadcastChannel, null, this, 1, null);
            }
            this.clearBuffer();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void clearBuffer() {
            ReentrantLock $receiver$iv = this.subLock;
            Lock lock = $receiver$iv;
            lock.lock();
            try {
                this.subHead = ((ArrayBroadcastChannel)this.broadcastChannel).tail;
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean checkOffer() {
            boolean updated;
            block13: {
                Closed closed;
                updated = false;
                Closed closed2 = null;
                while (this.needsToCheckOfferWithoutLock() && this.subLock.tryLock()) {
                    Object token;
                    ReceiveOrClosed<Object> receive;
                    try {
                        ReceiveOrClosed<Object> receiveOrClosed;
                        Object result = this.peekUnderLock();
                        if (result == AbstractChannelKt.POLL_FAILED) continue;
                        if (result instanceof Closed) {
                            closed2 = (Closed)result;
                            break;
                        }
                        if (this.takeFirstReceiveOrPeekClosed() == null) {
                            break;
                        }
                        receive = receiveOrClosed;
                        if (receive instanceof Closed) break;
                        token = receive.tryResumeReceive(result, null);
                        if (token == null) continue;
                        long subHead = this.subHead;
                        this.subHead = subHead + 1L;
                        updated = true;
                    }
                    finally {
                        this.subLock.unlock();
                        continue;
                    }
                    ReceiveOrClosed<Object> receiveOrClosed = receive;
                    if (receiveOrClosed == null) {
                        Intrinsics.throwNpe();
                    }
                    receiveOrClosed.completeResumeReceive(token);
                }
                Closed closed3 = closed2;
                if (closed3 == null) break block13;
                Closed it = closed = closed3;
                this.close(it.closeCause);
            }
            return updated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        protected Object pollInternal() {
            Object object;
            boolean updated = false;
            ReentrantLock $receiver$iv = this.subLock;
            Lock lock = $receiver$iv;
            lock.lock();
            try {
                Object result = this.peekUnderLock();
                if (!(result instanceof Closed) && result != AbstractChannelKt.POLL_FAILED) {
                    long subHead = this.subHead;
                    this.subHead = subHead + 1L;
                    updated = true;
                }
                object = result;
            }
            finally {
                lock.unlock();
            }
            Object result = object;
            Object object2 = result;
            if (!(object2 instanceof Closed)) {
                object2 = null;
            }
            Closed closed = (Closed)object2;
            if (closed != null) {
                Closed closed2;
                Closed it = closed2 = closed;
                this.close(it.closeCause);
            }
            if (this.checkOffer()) {
                updated = true;
            }
            if (updated) {
                ArrayBroadcastChannel.updateHead$default(this.broadcastChannel, null, null, 3, null);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        protected Object pollSelectInternal(@NotNull SelectInstance<?> select) {
            Object object;
            Intrinsics.checkParameterIsNotNull(select, "select");
            boolean updated = false;
            ReentrantLock $receiver$iv = this.subLock;
            Lock lock = $receiver$iv;
            lock.lock();
            try {
                Object result = this.peekUnderLock();
                if (!(result instanceof Closed) && result != AbstractChannelKt.POLL_FAILED) {
                    if (!select.trySelect(null)) {
                        result = SelectKt.getALREADY_SELECTED();
                    } else {
                        long subHead = this.subHead;
                        this.subHead = subHead + 1L;
                        updated = true;
                    }
                }
                object = result;
            }
            finally {
                lock.unlock();
            }
            Object result = object;
            Object object2 = result;
            if (!(object2 instanceof Closed)) {
                object2 = null;
            }
            Closed closed = (Closed)object2;
            if (closed != null) {
                Closed closed2;
                Closed it = closed2 = closed;
                this.close(it.closeCause);
            }
            if (this.checkOffer()) {
                updated = true;
            }
            if (updated) {
                ArrayBroadcastChannel.updateHead$default(this.broadcastChannel, null, null, 3, null);
            }
            return result;
        }

        private final boolean needsToCheckOfferWithoutLock() {
            if (this.getClosedForReceive() != null) {
                return false;
            }
            return !this.isBufferEmpty() || this.broadcastChannel.getClosedForReceive() != null;
        }

        private final Object peekUnderLock() {
            long subHead = this.subHead;
            Closed<?> closedBroadcast = this.broadcastChannel.getClosedForReceive();
            long tail = ((ArrayBroadcastChannel)this.broadcastChannel).tail;
            if (subHead >= tail) {
                Object object;
                Closed<?> closed = closedBroadcast;
                if (closed == null) {
                    closed = object = this.getClosedForReceive();
                }
                if (closed == null) {
                    object = AbstractChannelKt.POLL_FAILED;
                }
                return object;
            }
            Object result = ((ArrayBroadcastChannel)this.broadcastChannel).elementAt(subHead);
            Closed<?> closedSub = this.getClosedForReceive();
            if (closedSub != null) {
                return closedSub;
            }
            return result;
        }

        public Subscriber(@NotNull ArrayBroadcastChannel<E> broadcastChannel) {
            Intrinsics.checkParameterIsNotNull(broadcastChannel, "broadcastChannel");
            this.broadcastChannel = broadcastChannel;
            this.subLock = new ReentrantLock();
        }
    }
}

