/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public final class StringUtil {
    static final String[] padding = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             ", "              ", "               ", "                ", "                 ", "                  ", "                   ", "                    "};
    private static final int MaxCachedBuilderSize = 8192;
    private static final ThreadLocal<StringBuilder> stringLocal = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(8192);
        }
    };

    public static String join(Collection strings, String sep) {
        return StringUtil.join(strings.iterator(), sep);
    }

    public static String join(Iterator strings, String sep) {
        if (!strings.hasNext()) {
            return "";
        }
        String start = strings.next().toString();
        if (!strings.hasNext()) {
            return start;
        }
        StringBuilder sb = new StringBuilder(64).append(start);
        while (strings.hasNext()) {
            sb.append(sep);
            sb.append(strings.next());
        }
        return sb.toString();
    }

    public static String join(String[] strings, String sep) {
        return StringUtil.join(Arrays.asList(strings), sep);
    }

    public static String padding(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (width < padding.length) {
            return padding[width];
        }
        char[] out = new char[width];
        for (int i = 0; i < width; ++i) {
            out[i] = 32;
        }
        return String.valueOf(out);
    }

    public static boolean isBlank(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (StringUtil.isWhitespace(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isDigit(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int c2) {
        return c2 == 32 || c2 == 9 || c2 == 10 || c2 == 12 || c2 == 13;
    }

    public static boolean isActuallyWhitespace(int c2) {
        return c2 == 32 || c2 == 9 || c2 == 10 || c2 == 12 || c2 == 13 || c2 == 160;
    }

    public static boolean isInvisibleChar(int c2) {
        return Character.getType(c2) == 16 && (c2 == 8203 || c2 == 8204 || c2 == 8205 || c2 == 173);
    }

    public static String normaliseWhitespace(String string) {
        StringBuilder sb = StringUtil.stringBuilder();
        StringUtil.appendNormalisedWhitespace(sb, string, false);
        return sb.toString();
    }

    public static void appendNormalisedWhitespace(StringBuilder accum, String string, boolean stripLeading) {
        int c2;
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        int len = string.length();
        for (int i = 0; i < len; i += Character.charCount(c2)) {
            c2 = string.codePointAt(i);
            if (StringUtil.isActuallyWhitespace(c2)) {
                if (stripLeading && !reachedNonWhite || lastWasWhite) continue;
                accum.append(' ');
                lastWasWhite = true;
                continue;
            }
            if (StringUtil.isInvisibleChar(c2)) continue;
            accum.appendCodePoint(c2);
            lastWasWhite = false;
            reachedNonWhite = true;
        }
    }

    public static boolean in(String needle, String ... haystack) {
        int len = haystack.length;
        for (int i = 0; i < len; ++i) {
            if (!haystack[i].equals(needle)) continue;
            return true;
        }
        return false;
    }

    public static boolean inSorted(String needle, String[] haystack) {
        return Arrays.binarySearch(haystack, needle) >= 0;
    }

    public static URL resolve(URL base2, String relUrl) throws MalformedURLException {
        if (relUrl.startsWith("?")) {
            relUrl = base2.getPath() + relUrl;
        }
        if (relUrl.indexOf(46) == 0 && base2.getFile().indexOf(47) != 0) {
            base2 = new URL(base2.getProtocol(), base2.getHost(), base2.getPort(), "/" + base2.getFile());
        }
        return new URL(base2, relUrl);
    }

    public static String resolve(String baseUrl, String relUrl) {
        try {
            URL base2;
            try {
                base2 = new URL(baseUrl);
            }
            catch (MalformedURLException e) {
                URL abs = new URL(relUrl);
                return abs.toExternalForm();
            }
            return StringUtil.resolve(base2, relUrl).toExternalForm();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public static StringBuilder stringBuilder() {
        StringBuilder sb = stringLocal.get();
        if (sb.length() > 8192) {
            sb = new StringBuilder(8192);
            stringLocal.set(sb);
        } else {
            sb.delete(0, sb.length());
        }
        return sb;
    }
}

