/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.binpack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.binpack.PackNode;
import org.openrndr.binpack.Splitter;
import org.openrndr.shape.IntRectangle;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/openrndr/binpack/GreedySplitter;", "Lorg/openrndr/binpack/Splitter;", "()V", "horizontalBias", "", "getHorizontalBias", "()D", "setHorizontalBias", "(D)V", "horizontalDivisions", "", "getHorizontalDivisions", "()I", "setHorizontalDivisions", "(I)V", "verticalBias", "getVerticalBias", "setVerticalBias", "verticalDivisions", "getVerticalDivisions", "setVerticalDivisions", "split", "", "Lorg/openrndr/binpack/PackNode;", "node", "rectangle", "Lorg/openrndr/shape/IntRectangle;", "openrndr-binpack"})
public final class GreedySplitter
implements Splitter {
    private double horizontalBias;
    private double verticalBias;
    private int horizontalDivisions = 1;
    private int verticalDivisions = 1;

    public final double getHorizontalBias() {
        return this.horizontalBias;
    }

    public final void setHorizontalBias(double d) {
        this.horizontalBias = d;
    }

    public final double getVerticalBias() {
        return this.verticalBias;
    }

    public final void setVerticalBias(double d) {
        this.verticalBias = d;
    }

    public final int getHorizontalDivisions() {
        return this.horizontalDivisions;
    }

    public final void setHorizontalDivisions(int n) {
        this.horizontalDivisions = n;
    }

    public final int getVerticalDivisions() {
        return this.verticalDivisions;
    }

    public final void setVerticalDivisions(int n) {
        this.verticalDivisions = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PackNode> split(@NotNull PackNode node, @NotNull IntRectangle rectangle) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        int i;
        int n;
        int i2;
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(rectangle, "rectangle");
        int hc = this.horizontalDivisions * 2 + 1;
        int vc = this.verticalDivisions * 2 + 1;
        double hb = (this.horizontalBias + 1.0) / (double)2;
        double vb2 = (this.verticalBias + 1.0) / (double)2;
        double leftMargin = hb * (double)(node.getArea().getWidth() - rectangle.getWidth()) / (double)this.horizontalDivisions;
        double topMargin = vb2 * (double)(node.getArea().getHeight() - rectangle.getHeight()) / (double)this.verticalDivisions;
        double rightMargin = (1.0 - hb) * (double)(node.getArea().getWidth() - rectangle.getWidth()) / (double)this.horizontalDivisions;
        double bottomMargin = (1.0 - vb2) * (double)(node.getArea().getHeight() - rectangle.getHeight()) / (double)this.verticalDivisions;
        IntRectangle[] rects = new IntRectangle[hc * vc];
        double x = node.getArea().getX();
        double y = node.getArea().getY();
        double[] xpos = new double[hc];
        double[] ypos = new double[vc];
        double[] widths = new double[hc];
        double[] heights = new double[vc];
        int n2 = 0;
        int n3 = hc;
        while (n2 < n3) {
            xpos[i2] = x;
            if (i2 < hc / 2) {
                x += leftMargin;
                widths[i2] = leftMargin;
            } else if (i2 == hc / 2) {
                x += (double)rectangle.getWidth();
                widths[i2] = rectangle.getWidth();
            } else {
                x += rightMargin;
                widths[i2] = rightMargin;
            }
            ++i2;
        }
        n3 = vc;
        for (i2 = 0; i2 < n3; ++i2) {
            ypos[i2] = y;
            if (i2 < vc / 2) {
                y += topMargin;
                heights[i2] = topMargin;
                continue;
            }
            if (i2 == vc / 2) {
                y += (double)rectangle.getHeight();
                heights[i2] = rectangle.getHeight();
                continue;
            }
            y += bottomMargin;
            heights[i2] = bottomMargin;
        }
        i2 = 0;
        n3 = vc;
        while (i2 < n3) {
            void j;
            int n4 = 0;
            n = hc;
            while (n4 < n) {
                rects[j * hc + i] = new IntRectangle((int)xpos[i], (int)ypos[j], (int)widths[i], (int)heights[j]);
                ++i;
            }
            ++j;
        }
        int[] order = new int[hc * vc];
        order[0] = vc / 2 * hc + hc / 2;
        int count2 = 0;
        n = order.length;
        for (i = 1; i < n; ++i) {
            order[i] = count2++;
            if (count2 != order[0]) continue;
            ++count2;
        }
        Iterable iterable = $receiver$iv = (Iterable)RangesKt.until(0, hc * vc);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n5 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            IntRectangle intRectangle = rects[order[it]];
            if (intRectangle == null) {
                Intrinsics.throwNpe();
            }
            PackNode packNode = new PackNode(intRectangle, null, 2, null);
            collection.add(packNode);
        }
        return (List)destination$iv$iv;
    }
}

