/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.dnky;

import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\u00a8\u0006\f"}, d2={"shaderGGX", "", "getShaderGGX", "()Ljava/lang/String;", "shaderLinePlaneIntersect", "getShaderLinePlaneIntersect", "shaderProjectOnPlane", "getShaderProjectOnPlane", "shaderSideOfPlane", "getShaderSideOfPlane", "shaderVSM", "getShaderVSM", "dnky"})
public final class ShaderUtilitiesKt {
    @NotNull
    private static final String shaderProjectOnPlane = StringsKt.trimIndent("\nvec3 projectOnPlane(vec3 p, vec3 pc, vec3 pn) {\n    float distance = dot(pn, p-pc);\n    return p - distance * pn;\n}\n");
    @NotNull
    private static final String shaderSideOfPlane = StringsKt.trimIndent("\nint sideOfPlane(in vec3 p, in vec3 pc, in vec3 pn){\n   if (dot(p-pc,pn) >= 0.0) return 1; else return 0;\n}\n");
    @NotNull
    private static final String shaderLinePlaneIntersect = StringsKt.trimIndent("\nvec3 linePlaneIntersect(in vec3 lp, in vec3 lv, in vec3 pc, in vec3 pn){\n   return lp+lv*(dot(pn,pc-lp)/dot(pn,lv));\n}\n");
    @NotNull
    private static final String shaderVSM = StringsKt.trimIndent("\n| float linstep(float min, float max, float v)\n|{\n|  return clamp((v - min) / (max - min), 0, 1);\n|}\n|// https://developer.nvidia.com/gpugems/GPUGems3/gpugems3_ch08.html\n|float chebyshevUpperBound(vec2 moments, float t, float minVariance) {\n|   // One-tailed inequality valid if t > Moments.x\n|   float p = (t <= moments.x) ? 1.0 : 0.0;\n|   // Compute variance.\n|   float variance = moments.y - (moments.x * moments.x);\n|   variance = max(variance, minVariance);\n|   // Compute probabilistic upper bound.\n|   float d = t - moments.x;\n|   float p_max = variance / (variance + d*d);\n|   p_max = smoothstep(0.6, 1, p_max);\n|   return max(p, p_max);\n}\n");
    @NotNull
    private static final String shaderGGX = StringsKt.trimIndent("\n#define bias 0.125\n#define HASHSCALE 443.8975\nvec2 hash22(vec2 p) {\n\tvec3 p3 = fract(vec3(p.xyx) * HASHSCALE);\n    p3 += dot(p3, p3.yzx+19.19);\n    return fract(vec2((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y));\n}\n\n\n#define PI 3.1415926535\n\nfloat pow5(float x) {\n    float x2 = x * x;\n    return x2 * x2 * x;\n}\n\nfloat D_GGX(float linearRoughness, float NoH, const vec3 h) {\n    // Walter et al. 2007, \"Microfacet Models for Refraction through Rough Surfaces\"\n    float oneMinusNoHSquared = 1.0 - NoH * NoH;\n    float a = NoH * linearRoughness;\n    float k = linearRoughness / (oneMinusNoHSquared + a * a);\n    float d = k * k * (1.0 / PI);\n    return d;\n}\n\nfloat V_SmithGGXCorrelated(float linearRoughness, float NoV, float NoL) {\n    // Heitz 2014, \"Understanding the Masking-Shadowing Function in Microfacet-Based BRDFs\"\n    float a2 = linearRoughness * linearRoughness;\n    float GGXV = NoL * sqrt((NoV - a2 * NoV) * NoV + a2);\n    float GGXL = NoV * sqrt((NoL - a2 * NoL) * NoL + a2);\n    return 0.5 / (GGXV + GGXL);\n}\n\nvec3 F_Schlick(const vec3 f0, float VoH) {\n    // Schlick 1994, \"An Inexpensive BRDF Model for Physically-Based Rendering\"\n    return f0 + (vec3(1.0) - f0) * pow5(1.0 - VoH);\n}\n\nfloat F_Schlick(float f0, float f90, float VoH) {\n    return f0 + (f90 - f0) * pow5(1.0 - VoH);\n}\n\nfloat Fd_Burley(float linearRoughness, float NoV, float NoL, float LoH) {\n    // Burley 2012, \"Physically-Based Shading at Disney\"\n    float f90 = 0.5 + 2.0 * linearRoughness * LoH * LoH;\n    float lightScatter = F_Schlick(1.0, f90, NoL);\n    float viewScatter  = F_Schlick(1.0, f90, NoV);\n    return lightScatter * viewScatter * (1.0 / PI);\n}\n\nvec2 PrefilteredDFG_Karis(float roughness, float NoV) {\n    //https://www.shadertoy.com/view/XlKSDR\n    // Karis 2014, \"Physically Based Material on Mobile\"\n    const vec4 c0 = vec4(-1.0, -0.0275, -0.572,  0.022);\n    const vec4 c1 = vec4( 1.0,  0.0425,  1.040, -0.040);\n\n    vec4 r = roughness * c0 + c1;\n    float a004 = min(r.x * r.x, exp2(-9.28 * NoV)) * r.x + r.y;\n    return vec2(-1.04, 1.04) * a004 + r.zw;\n}\n\n\n\n\nfloat saturate(float x) {\n    return clamp(x, 0.0, 1.0);\n}\n\nfloat G1V(float dotNV, float k)\n{\n\treturn 1.0f/(dotNV*(1.0f-k)+k);\n}\n\nfloat ggx(vec3 N, vec3 V, vec3 L, float roughness, float F0)\n{\n\tfloat alpha = roughness*roughness;\n\n\tvec3 H = normalize(V+L);\n\n\tfloat dotNL = saturate(dot(N,L));\n\tfloat dotNV = saturate(dot(N,V));\n\tfloat dotNH = saturate(dot(N,H));\n\tfloat dotLH = saturate(dot(L,H));\n\n\tfloat F, D, vis;\n\n\t// D\n\tfloat alphaSqr = alpha*alpha;\n\tfloat pi = 3.14159f;\n\tfloat denom = dotNH * dotNH *(alphaSqr-1.0) + 1.0f;\n\tD = alphaSqr/(pi * denom * denom);\n\n\t// F\n\tfloat dotLH5 = pow(1.0f-dotLH,5);\n\tF = F0 + (1.0-F0)*(dotLH5);\n\n\t// V\n\tfloat k = alpha/2.0f;\n\tvis = G1V(dotNL,k)*G1V(dotNV,k);\n\n\tfloat specular = dotNL * D * F * vis;\n\treturn specular;\n}\n");

    @NotNull
    public static final String getShaderProjectOnPlane() {
        return shaderProjectOnPlane;
    }

    @NotNull
    public static final String getShaderSideOfPlane() {
        return shaderSideOfPlane;
    }

    @NotNull
    public static final String getShaderLinePlaneIntersect() {
        return shaderLinePlaneIntersect;
    }

    @NotNull
    public static final String getShaderVSM() {
        return shaderVSM;
    }

    @NotNull
    public static final String getShaderGGX() {
        return shaderGGX;
    }
}

