/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.integralimage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.ApplicationKt;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Filter;
import org.openrndr.draw.FilterKt;
import org.openrndr.extra.integralimage.FastIntegralImageFilter;
import org.openrndr.filter.blend.BlendFiltersKt;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/openrndr/extra/integralimage/FastIntegralImage;", "Lorg/openrndr/draw/Filter;", "()V", "filter", "Lorg/openrndr/extra/integralimage/FastIntegralImageFilter;", "getFilter", "()Lorg/openrndr/extra/integralimage/FastIntegralImageFilter;", "intermediate", "Lorg/openrndr/draw/ColorBuffer;", "getIntermediate", "()Lorg/openrndr/draw/ColorBuffer;", "setIntermediate", "(Lorg/openrndr/draw/ColorBuffer;)V", "apply", "", "source", "", "target", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;)V", "sampleCounts", "", "", "size", "sampleCountBase", "orx-integral-image"})
public final class FastIntegralImage
extends Filter {
    @Nullable
    private ColorBuffer intermediate;
    @NotNull
    private final FastIntegralImageFilter filter = new FastIntegralImageFilter();

    @Nullable
    public final ColorBuffer getIntermediate() {
        return this.intermediate;
    }

    public final void setIntermediate(@Nullable ColorBuffer colorBuffer) {
        this.intermediate = colorBuffer;
    }

    @NotNull
    public final FastIntegralImageFilter getFilter() {
        return this.filter;
    }

    private final List<Integer> sampleCounts(int size, int sampleCountBase) {
        List sampleCounts = new ArrayList();
        for (int remainder = size; remainder > 0; remainder /= sampleCountBase) {
            Collection collection = sampleCounts;
            Integer n = remainder >= sampleCountBase ? sampleCountBase : remainder;
            collection.add(n);
        }
        return sampleCounts;
    }

    @Override
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target2) {
        int pass;
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target2, "target");
        int sampleCountBase = 16;
        List<Integer> xSampleCounts = this.sampleCounts(source[0].getWidth(), sampleCountBase);
        List<Integer> ySampleCounts = this.sampleCounts(source[0].getHeight(), sampleCountBase);
        ColorBuffer li = this.intermediate;
        if (li == null || li.getWidth() != source[0].getWidth() || li.getHeight() != source[0].getHeight()) {
            ColorBuffer colorBuffer = this.intermediate;
            if (colorBuffer != null) {
                colorBuffer.destroy();
            }
            this.intermediate = ColorBufferKt.colorBuffer$default(source[0].getWidth(), source[0].getHeight(), 1.0, ColorFormat.RGBa, ColorType.FLOAT32, null, 32, null);
        }
        ColorBuffer[][] colorBufferArrayArray = new ColorBuffer[2][];
        colorBufferArrayArray[0] = target2;
        ColorBuffer[] colorBufferArray = new ColorBuffer[1];
        ColorBuffer colorBuffer = this.intermediate;
        if (colorBuffer == null) {
            Intrinsics.throwNpe();
        }
        colorBufferArray[0] = colorBuffer;
        colorBufferArrayArray[1] = colorBufferArray;
        ColorBuffer[][] targets = colorBufferArrayArray;
        int targetIndex = 0;
        this.filter.setSampleCountBase(sampleCountBase);
        this.filter.setPassDirection(Vector2.Companion.getUNIT_X());
        int n = 0;
        int n2 = xSampleCounts.size();
        while (n < n2) {
            this.filter.setSampleCount(((Number)xSampleCounts.get(pass)).intValue());
            this.filter.setPassIndex(pass);
            this.filter.apply(pass == 0 ? source : targets[targetIndex % 2], targets[(targetIndex + 1) % 2]);
            ++targetIndex;
            ++pass;
        }
        this.filter.setPassDirection(Vector2.Companion.getUNIT_Y());
        n2 = ySampleCounts.size();
        for (pass = 0; pass < n2; ++pass) {
            this.filter.setSampleCount(((Number)ySampleCounts.get(pass)).intValue());
            this.filter.setPassIndex(pass);
            this.filter.apply(targets[targetIndex % 2], targets[(targetIndex + 1) % 2]);
            ++targetIndex;
        }
        if (targetIndex % 2 == 1) {
            BlendFiltersKt.getPassthrough().apply(targets[1], targets[0]);
        }
    }

    public FastIntegralImage() {
        super(FilterKt.filterShaderFromUrl(ApplicationKt.resourceUrl$default("/shaders/gl3/integral-image.frag", null, 2, null)), null, 2, null);
    }
}

