/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.CircleDrawerKt;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Circle;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J.\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016J \u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J,\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0018\u001a\u00020\u0016J2\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cJ$\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/openrndr/internal/CircleDrawer;", "", "()V", "instanceAttributes", "Lorg/openrndr/draw/VertexBuffer;", "instanceFormat", "Lorg/openrndr/draw/VertexFormat;", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "getVertices", "()Lorg/openrndr/draw/VertexBuffer;", "assertInstanceSize", "", "size", "", "drawCircle", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "x", "", "y", "radius", "drawCircles", "count", "positions", "", "Lorg/openrndr/math/Vector2;", "radii", "circles", "Lorg/openrndr/shape/Circle;", "openrndr-core"})
public final class CircleDrawer {
    @NotNull
    private final VertexBuffer vertices;
    private final VertexFormat instanceFormat;
    private VertexBuffer instanceAttributes;
    private final ShadeStyleManager shaderManager;

    @NotNull
    public final VertexBuffer getVertices() {
        return this.vertices;
    }

    private final void assertInstanceSize(int size) {
        if (this.instanceAttributes.getVertexCount() < size) {
            CircleDrawerKt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(this, size){
                final /* synthetic */ CircleDrawer this$0;
                final /* synthetic */ int $size;

                @NotNull
                public final String invoke() {
                    return "resizing buffer from " + CircleDrawer.access$getInstanceAttributes$p(this.this$0).getVertexCount() + " to " + this.$size;
                }
                {
                    this.this$0 = circleDrawer;
                    this.$size = n;
                    super(0);
                }
            });
            this.instanceAttributes.destroy();
            this.instanceAttributes = VertexBufferKt.vertexBuffer(this.instanceFormat, size);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void drawCircles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, @NotNull List<Double> radii) {
        BufferWriter bufferWriter2;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        Intrinsics.checkParameterIsNotNull(radii, "radii");
        this.assertInstanceSize(positions.size());
        BufferWriter $receiver = bufferWriter2 = this.instanceAttributes.getShadow().writer();
        $receiver.rewind();
        int n = 0;
        int n2 = positions.size();
        while (n < n2) {
            void i;
            $receiver.write((float)((Number)radii.get((int)i)).doubleValue());
            $receiver.write(new Vector3(positions.get((int)i).getX(), positions.get((int)i).getY(), 0.0));
            ++i;
        }
        this.instanceAttributes.getShadow().uploadElements(0, positions.size());
        this.drawCircles(drawContext, drawStyle, positions.size());
    }

    public final void drawCircles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, double radius) {
        BufferWriter bufferWriter2;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        this.assertInstanceSize(positions.size());
        BufferWriter $receiver = bufferWriter2 = this.instanceAttributes.getShadow().writer();
        $receiver.rewind();
        Iterable $receiver$iv = positions;
        for (Object element$iv : $receiver$iv) {
            Vector2 it = (Vector2)element$iv;
            $receiver.write((float)radius);
            $receiver.write(new Vector3(it.getX(), it.getY(), 0.0));
        }
        this.instanceAttributes.getShadow().uploadElements(0, positions.size());
        this.drawCircles(drawContext, drawStyle, positions.size());
    }

    public final void drawCircles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Circle> circles) {
        BufferWriter bufferWriter2;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(circles, "circles");
        this.assertInstanceSize(circles.size());
        BufferWriter $receiver = bufferWriter2 = this.instanceAttributes.getShadow().writer();
        $receiver.rewind();
        Iterable $receiver$iv = circles;
        for (Object element$iv : $receiver$iv) {
            Circle it = (Circle)element$iv;
            $receiver.write((float)it.getRadius());
            $receiver.write(new Vector3(it.getCenter().getX(), it.getCenter().getY(), 0.0));
        }
        this.instanceAttributes.getShadow().uploadElements(0, circles.size());
        this.drawCircles(drawContext, drawStyle, circles.size());
    }

    public final void drawCircle(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, double x, double y, double radius) {
        BufferWriter bufferWriter2;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        this.assertInstanceSize(1);
        BufferWriter $receiver = bufferWriter2 = this.instanceAttributes.getShadow().writer();
        $receiver.rewind();
        $receiver.write((float)radius);
        $receiver.write(new Vector3(x, y, 0.0));
        this.instanceAttributes.getShadow().uploadElements(0, 1);
        this.drawCircles(drawContext, drawStyle, 1);
    }

    private final void drawCircles(DrawContext drawContext, DrawStyle drawStyle, int count2) {
        Object object;
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.listOf(this.instanceAttributes.getVertexFormat()));
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawInstances(shader2, CollectionsKt.listOf(this.vertices), CollectionsKt.plus((Collection)CollectionsKt.listOf(this.instanceAttributes), (object = drawStyle.getShadeStyle()) != null && (object = ((ShadeStyle)object).getAttributes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()), DrawPrimitive.TRIANGLES, 0, 6, count2);
        shader2.end();
    }

    public CircleDrawer() {
        BufferWriter bufferWriter2;
        VertexFormat vertexFormat2 = new VertexFormat();
        Object object = VertexBuffer.Companion;
        CircleDrawer circleDrawer = this;
        VertexFormat $receiver = vertexFormat2;
        $receiver.position(3);
        $receiver.normal(3);
        VertexFormat.textureCoordinate$default($receiver, 2, 0, 2, null);
        VertexFormat vertexFormat3 = vertexFormat2;
        circleDrawer.vertices = ((VertexBuffer.Companion)object).createDynamic(vertexFormat3, 6);
        vertexFormat2 = new VertexFormat();
        circleDrawer = this;
        $receiver = vertexFormat2;
        VertexFormat.attribute$default($receiver, "radius", VertexElementType.FLOAT32, 0, 4, null);
        VertexFormat.attribute$default($receiver, "offset", VertexElementType.VECTOR3_FLOAT32, 0, 4, null);
        circleDrawer.instanceFormat = object = vertexFormat2;
        this.instanceAttributes = VertexBuffer.Companion.createDynamic(this.instanceFormat, 10000);
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators((Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).circleVertexShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "circleVertexShader";
            }

            public final String getSignature() {
                return "circleVertexShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        }, (Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).circleFragmentShader(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            public final String getName() {
                return "circleFragmentShader";
            }

            public final String getSignature() {
                return "circleFragmentShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        });
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        double x = 0.0;
        double y = 0.0;
        double radius = 1.0;
        Vector3 pa = new Vector3(x - radius, y - radius, 0.0);
        Vector3 pb = new Vector3(x + radius, y - radius, 0.0);
        Vector3 pc = new Vector3(x + radius, y + radius, 0.0);
        Vector3 pd = new Vector3(x - radius, y + radius, 0.0);
        Vector2 ta = new Vector2(0.0, 0.0);
        Vector2 tb = new Vector2(1.0, 0.0);
        Vector2 tc = new Vector2(1.0, 1.0);
        Vector2 td = new Vector2(0.0, 1.0);
        Vector3 n = new Vector3(0.0, 0.0, -1.0);
        BufferWriter $receiver2 = bufferWriter2 = w;
        $receiver2.write(pa);
        $receiver2.write(n);
        $receiver2.write(ta);
        $receiver2.write(pd);
        $receiver2.write(n);
        $receiver2.write(td);
        $receiver2.write(pc);
        $receiver2.write(n);
        $receiver2.write(tc);
        $receiver2.write(pc);
        $receiver2.write(n);
        $receiver2.write(tc);
        $receiver2.write(pb);
        $receiver2.write(n);
        $receiver2.write(tb);
        $receiver2.write(pa);
        $receiver2.write(n);
        $receiver2.write(ta);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
    }

    @NotNull
    public static final /* synthetic */ VertexBuffer access$getInstanceAttributes$p(CircleDrawer $this) {
        return $this.instanceAttributes;
    }

    public static final /* synthetic */ void access$setInstanceAttributes$p(CircleDrawer $this, @NotNull VertexBuffer vertexBuffer) {
        $this.instanceAttributes = vertexBuffer;
    }
}

