/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBImage;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lorg/openrndr/internal/gl3/ColorBufferDataGL3;", "", "width", "", "height", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "data", "Ljava/nio/ByteBuffer;", "(IILorg/openrndr/draw/ColorFormat;Lorg/openrndr/draw/ColorType;Ljava/nio/ByteBuffer;)V", "getData", "()Ljava/nio/ByteBuffer;", "setData", "(Ljava/nio/ByteBuffer;)V", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "getHeight", "()I", "getType", "()Lorg/openrndr/draw/ColorType;", "getWidth", "destroy", "", "Companion", "openrndr-gl3"})
public final class ColorBufferDataGL3 {
    private final int width;
    private final int height;
    @NotNull
    private final ColorFormat format;
    @NotNull
    private final ColorType type;
    @Nullable
    private ByteBuffer data;
    public static final Companion Companion = new Companion(null);

    public final void destroy() {
        ByteBuffer localData = this.data;
        if (localData != null) {
            STBImage.stbi_image_free(localData);
            this.data = null;
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final ColorFormat getFormat() {
        return this.format;
    }

    @NotNull
    public final ColorType getType() {
        return this.type;
    }

    @Nullable
    public final ByteBuffer getData() {
        return this.data;
    }

    public final void setData(@Nullable ByteBuffer byteBuffer) {
        this.data = byteBuffer;
    }

    public ColorBufferDataGL3(int width, int height, @NotNull ColorFormat format, @NotNull ColorType type, @Nullable ByteBuffer data) {
        Intrinsics.checkParameterIsNotNull((Object)format, "format");
        Intrinsics.checkParameterIsNotNull((Object)type, "type");
        this.width = width;
        this.height = height;
        this.format = format;
        this.type = type;
        this.data = data;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/openrndr/internal/gl3/ColorBufferDataGL3$Companion;", "", "()V", "fromFile", "Lorg/openrndr/internal/gl3/ColorBufferDataGL3;", "filename", "", "fromUrl", "urlString", "openrndr-gl3"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final ColorBufferDataGL3 fromUrl(@NotNull String urlString) {
            Intrinsics.checkParameterIsNotNull(urlString, "urlString");
            URL url = new URL(urlString);
            Closeable closeable = url.openStream();
            Throwable throwable = null;
            try {
                ByteBuffer buffer;
                byte[] byteArray;
                InputStream it = (InputStream)closeable;
                byte[] byArray = byteArray = TextStreamsKt.readBytes(url);
                if (byArray.length == 0) {
                    throw (Throwable)new RuntimeException("read 0 bytes from stream " + urlString);
                }
                ByteBuffer byteBuffer = buffer = BufferUtils.createByteBuffer(byteArray.length);
                if (byteBuffer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
                }
                ((Buffer)byteBuffer).rewind();
                buffer.put(byteArray);
                ((Buffer)buffer).rewind();
                int[] wa = new int[1];
                int[] ha = new int[1];
                int[] ca = new int[1];
                STBImage.stbi_set_flip_vertically_on_load(true);
                STBImage.stbi_set_unpremultiply_on_load(false);
                ByteBuffer data = STBImage.stbi_load_from_memory(buffer, wa, ha, ca, 0);
                if (data != null) {
                    int offset2 = 0;
                    if (ca[0] == 4) {
                        int n = 0;
                        int n2 = ha[0];
                        while (n < n2) {
                            void y;
                            int n3 = 0;
                            int n4 = wa[0];
                            while (n3 < n4) {
                                void x;
                                double a2 = (double)(data.get(offset2 + 3) & 0xFF) / 255.0;
                                byte r = (byte)((double)(data.get(offset2) & 0xFF) * a2);
                                byte g = (byte)((double)(data.get(offset2 + 1) & 0xFF) * a2);
                                byte b = (byte)((double)(data.get(offset2 + 2) & 0xFF) * a2);
                                data.put(offset2, r);
                                data.put(offset2 + 1, g);
                                data.put(offset2 + 2, b);
                                offset2 += 4;
                                ++x;
                            }
                            ++y;
                        }
                    }
                }
                if (data != null) {
                    ColorFormat colorFormat;
                    int n = wa[0];
                    int n5 = ha[0];
                    switch (ca[0]) {
                        case 1: {
                            colorFormat = ColorFormat.R;
                            break;
                        }
                        case 2: {
                            colorFormat = ColorFormat.RG;
                            break;
                        }
                        case 3: {
                            colorFormat = ColorFormat.RGB;
                            break;
                        }
                        case 4: {
                            colorFormat = ColorFormat.RGBa;
                            break;
                        }
                        default: {
                            throw (Throwable)new Exception("invalid component count " + ca[0]);
                        }
                    }
                    ColorBufferDataGL3 colorBufferDataGL3 = new ColorBufferDataGL3(n, n5, colorFormat, ColorType.UINT8, data);
                    return colorBufferDataGL3;
                }
                try {
                    throw (Throwable)new RuntimeException("failed to load image " + urlString);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ColorBufferDataGL3 fromFile(@NotNull String filename) {
            ByteBuffer buffer;
            byte[] byteArray;
            Intrinsics.checkParameterIsNotNull(filename, "filename");
            byte[] byArray = byteArray = FilesKt.readBytes(new File(filename));
            if (byArray.length == 0) {
                throw (Throwable)new RuntimeException("read 0 bytes from stream " + filename);
            }
            ByteBuffer byteBuffer = buffer = BufferUtils.createByteBuffer(byteArray.length);
            if (byteBuffer == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
            }
            ((Buffer)byteBuffer).rewind();
            buffer.put(byteArray);
            ((Buffer)buffer).rewind();
            int[] wa = new int[1];
            int[] ha = new int[1];
            int[] ca = new int[1];
            STBImage.stbi_set_flip_vertically_on_load(true);
            STBImage.stbi_set_unpremultiply_on_load(false);
            ByteBuffer data = STBImage.stbi_load_from_memory(buffer, wa, ha, ca, 0);
            if (data != null) {
                int offset2 = 0;
                if (ca[0] == 4) {
                    int n = 0;
                    int n2 = ha[0];
                    while (n < n2) {
                        void y;
                        int n3 = 0;
                        int n4 = wa[0];
                        while (n3 < n4) {
                            void x;
                            double a2 = (double)(data.get(offset2 + 3) & 0xFF) / 255.0;
                            byte r = (byte)((double)(data.get(offset2) & 0xFF) * a2);
                            byte g = (byte)((double)(data.get(offset2 + 1) & 0xFF) * a2);
                            byte b = (byte)((double)(data.get(offset2 + 2) & 0xFF) * a2);
                            data.put(offset2, r);
                            data.put(offset2 + 1, g);
                            data.put(offset2 + 2, b);
                            offset2 += 4;
                            ++x;
                        }
                        ++y;
                    }
                }
            }
            if (data != null) {
                ColorFormat colorFormat;
                int n = wa[0];
                int n5 = ha[0];
                switch (ca[0]) {
                    case 1: {
                        colorFormat = ColorFormat.R;
                        break;
                    }
                    case 2: {
                        colorFormat = ColorFormat.RG;
                        break;
                    }
                    case 3: {
                        colorFormat = ColorFormat.RGB;
                        break;
                    }
                    case 4: {
                        colorFormat = ColorFormat.RGBa;
                        break;
                    }
                    default: {
                        throw (Throwable)new Exception("invalid component count " + ca[0]);
                    }
                }
                return new ColorBufferDataGL3(n, n5, colorFormat, ColorType.UINT8, data);
            }
            throw (Throwable)new RuntimeException("failed to load image " + filename);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

