/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.ContourProjection;
import org.openrndr.shape.LineSegment;
import org.openrndr.shape.LineSegmentKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Segment;
import org.openrndr.shape.SegmentJoin;
import org.openrndr.shape.SegmentProjection;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour$WhenMappings;
import org.openrndr.shape.ShapeToolsKt;
import org.openrndr.shape.Winding;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 L2\u00020\u0001:\u0001LB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00032\b\b\u0002\u0010#\u001a\u00020\u0017J(\u0010$\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00030%2\b\b\u0002\u0010#\u001a\u00020\u0017J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0006H\u00c6\u0003J#\u0010(\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010)\u001a\u00020\u00062\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0\u00032\u0006\u0010,\u001a\u00020-J\t\u0010.\u001a\u00020-H\u00d6\u0001J$\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000401J\u0018\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u0017H\u0002J\u000e\u00105\u001a\u00020\"2\u0006\u00106\u001a\u00020\u0017J\u0018\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00172\b\b\u0002\u00109\u001a\u00020:J\u001f\u0010;\u001a\u0004\u0018\u00010\u00172\u0006\u0010<\u001a\u00020\"2\b\b\u0002\u0010=\u001a\u00020\u0017\u00a2\u0006\u0002\u0010>J\u0011\u0010?\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010@\u001a\u00020\"2\u0006\u00106\u001a\u00020\u0017J\u000e\u0010A\u001a\u00020B2\u0006\u0010<\u001a\u00020\"J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u0010\u0010D\u001a\u00020\u00002\b\b\u0002\u0010#\u001a\u00020\u0017J\u0016\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u00172\u0006\u0010G\u001a\u00020\u0017J\t\u0010H\u001a\u00020IH\u00d6\u0001J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010J\u001a\u00020KR\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006M"}, d2={"Lorg/openrndr/shape/ShapeContour;", "", "segments", "", "Lorg/openrndr/shape/Segment;", "closed", "", "(Ljava/util/List;Z)V", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "clockwise", "getClockwise", "()Lorg/openrndr/shape/ShapeContour;", "getClosed", "()Z", "counterClockwise", "getCounterClockwise", "exploded", "getExploded", "()Ljava/util/List;", "length", "", "getLength", "()D", "reversed", "getReversed", "getSegments", "winding", "Lorg/openrndr/shape/Winding;", "getWinding", "()Lorg/openrndr/shape/Winding;", "adaptivePositions", "Lorg/openrndr/math/Vector2;", "distanceTolerance", "adaptivePositionsAndDirection", "Lkotlin/Pair;", "component1", "component2", "copy", "equals", "other", "equidistantPositions", "pointCount", "", "hashCode", "map", "mapper", "Lkotlin/Function1;", "mod", "a", "b", "normal", "ut", "offset", "distance", "joinType", "Lorg/openrndr/shape/SegmentJoin;", "on", "point", "error", "(Lorg/openrndr/math/Vector2;D)Ljava/lang/Double;", "plus", "position", "project", "Lorg/openrndr/shape/ContourProjection;", "sampleEquidistant", "sampleLinear", "sub", "u0", "u1", "toString", "", "transform", "Lorg/openrndr/math/Matrix44;", "Companion", "openrndr-shape"})
public final class ShapeContour {
    @NotNull
    private final List<Segment> segments;
    private final boolean closed;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final double getLength() {
        void var2_2;
        Iterable $receiver$iv = this.segments;
        double sum$iv = 0.0;
        for (Object element$iv : $receiver$iv) {
            void it;
            Segment segment = (Segment)element$iv;
            double d = sum$iv;
            double d2 = it.getLength();
            sum$iv = d + d2;
        }
        return (double)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Rectangle getBounds() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)ShapeContour.sampleLinear$default((ShapeContour)this, (double)0.0, (int)1, null).segments;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Segment it = (Segment)element$iv$iv;
            Iterable list$iv$iv = CollectionsKt.listOf(it.getStart(), it.getEnd());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return RectangleKt.vector2Bounds((List)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Winding getWinding() {
        double sum = 0.0;
        Iterable $receiver$iv = this.segments;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void v;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Segment segment = (Segment)item$iv;
            int i = n2;
            Vector2 after = this.segments.get(FunctionsKt.mod(i + 1, this.segments.size())).getStart();
            sum += (after.getX() - v.getStart().getX()) * (after.getY() + v.getStart().getY());
        }
        return sum < 0.0 ? Winding.COUNTER_CLOCKWISE : Winding.CLOCKWISE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ShapeContour> getExploded() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.segments;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            Collection collection = destination$iv$iv;
            ShapeContour shapeContour = new ShapeContour(CollectionsKt.listOf(it), false);
            collection.add(shapeContour);
        }
        return (List)var3_3;
    }

    @NotNull
    public final ShapeContour getClockwise() {
        return this.getWinding() == Winding.CLOCKWISE ? this : this.getReversed();
    }

    @NotNull
    public final ShapeContour getCounterClockwise() {
        return this.getWinding() == Winding.COUNTER_CLOCKWISE ? this : this.getReversed();
    }

    @NotNull
    public final ShapeContour plus(@NotNull ShapeContour other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        double epsilon = 0.001;
        List segments = new ArrayList();
        segments.addAll((Collection)this.segments);
        if (this.segments.get(this.segments.size() - 1).getEnd().minus(other.segments.get(0).getStart()).getLength() > epsilon) {
            segments.add(new Segment(this.segments.get(this.segments.size() - 1).getEnd(), other.segments.get(0).getStart()));
        }
        segments.addAll((Collection)other.segments);
        return new ShapeContour(segments, false);
    }

    @NotNull
    public final ShapeContour offset(double distance, @NotNull SegmentJoin joinType) {
        Pair it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)joinType, "joinType");
        if (this.segments.size() == 1) {
            return new ShapeContour(this.segments.get(0).offset(distance), this.closed);
        }
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.plus((Collection)this.segments, (Iterable)(this.closed ? CollectionsKt.listOf(CollectionsKt.first(this.segments)) : CollectionsKt.emptyList()));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Segment segment = (Segment)item$iv$iv;
            Collection collection = destination$iv$iv;
            List<Segment> list = ((Segment)((Object)it)).offset(distance);
            collection.add(list);
        }
        $receiver$iv$iv = $receiver$iv = (Iterable)CollectionsKt.zipWithNext((List)destination$iv$iv);
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            List list;
            it = (Pair)element$iv$iv;
            Vector2 end2 = ((Segment)CollectionsKt.last((List)it.getFirst())).getEnd();
            Vector2 start = ((Segment)CollectionsKt.first((List)it.getSecond())).getStart();
            switch (ShapeContour$WhenMappings.$EnumSwitchMapping$0[joinType.ordinal()]) {
                case 1: {
                    double d = end2.minus(start).getLength();
                    ShapeContour join2 = ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>(end2, d, start){
                        final /* synthetic */ Vector2 $end;
                        final /* synthetic */ double $d;
                        final /* synthetic */ Vector2 $start;

                        public final void invoke(@NotNull ContourBuilder $receiver) {
                            Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                            $receiver.moveTo(this.$end);
                            $receiver.arcTo(this.$d, this.$d, 0.0, false, true, this.$start.getX(), this.$start.getY());
                        }
                        {
                            this.$end = vector2;
                            this.$d = d;
                            this.$start = vector22;
                            super(1);
                        }
                    });
                    list = CollectionsKt.plus((Collection)it.getFirst(), (Iterable)join2.segments);
                    break;
                }
                case 2: {
                    ShapeContour join3 = ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>(end2, start){
                        final /* synthetic */ Vector2 $end;
                        final /* synthetic */ Vector2 $start;

                        public final void invoke(@NotNull ContourBuilder $receiver) {
                            Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                            $receiver.moveTo(this.$end);
                            $receiver.lineTo(this.$start);
                        }
                        {
                            this.$end = vector2;
                            this.$start = vector22;
                            super(1);
                        }
                    });
                    list = CollectionsKt.plus((Collection)it.getFirst(), (Iterable)join3.segments);
                    break;
                }
                case 3: {
                    Vector2 endDir = ((Segment)CollectionsKt.last((List)it.getFirst())).direction(1.0);
                    Vector2 startDir = ((Segment)CollectionsKt.first((List)it.getSecond())).direction(0.0);
                    LineSegment endLine = new LineSegment(end2, end2.plus(endDir));
                    LineSegment startLine = new LineSegment(start, start.plus(startDir));
                    Vector2 i = LineSegmentKt.intersection(endLine, startLine, 1.0E7);
                    ShapeContour join4 = ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>(end2, i, start){
                        final /* synthetic */ Vector2 $end;
                        final /* synthetic */ Vector2 $i;
                        final /* synthetic */ Vector2 $start;

                        public final void invoke(@NotNull ContourBuilder $receiver) {
                            Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                            $receiver.moveTo(this.$end);
                            $receiver.lineTo(this.$i);
                            $receiver.lineTo(this.$start);
                        }
                        {
                            this.$end = vector2;
                            this.$i = vector22;
                            this.$start = vector23;
                            super(1);
                        }
                    });
                    list = CollectionsKt.plus((Collection)it.getFirst(), (Iterable)join4.segments);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List joins2 = (List)destination$iv$iv;
        return new ShapeContour(joins2, this.closed);
    }

    @NotNull
    public static /* synthetic */ ShapeContour offset$default(ShapeContour shapeContour, double d, SegmentJoin segmentJoin, int n, Object object) {
        if ((n & 2) != 0) {
            segmentJoin = SegmentJoin.ROUND;
        }
        return shapeContour.offset(d, segmentJoin);
    }

    @NotNull
    public final Vector2 position(double ut) {
        double t2 = RangesKt.coerceIn(ut, 0.0, 1.0);
        int segment = (int)(t2 * (double)this.segments.size());
        double segmentOffset = t2 * (double)this.segments.size() - (double)segment;
        return this.segments.get(Math.min(this.segments.size() - 1, segment)).position(segmentOffset);
    }

    @NotNull
    public final Vector2 normal(double ut) {
        double t2 = RangesKt.coerceIn(ut, 0.0, 1.0);
        int segment = (int)(t2 * (double)this.segments.size());
        double segmentOffset = t2 * (double)this.segments.size() - (double)segment;
        return this.segments.get(Math.min(this.segments.size() - 1, segment)).normal(segmentOffset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> adaptivePositions(double distanceTolerance) {
        List adaptivePoints = new ArrayList();
        Vector2 last2 = null;
        for (Segment segment : this.segments) {
            List<Vector2> samples = segment.sampleAdaptive(distanceTolerance);
            Collection collection = samples;
            if (!(!collection.isEmpty())) continue;
            Vector2 r = samples.get(0);
            if (last2 == null || last2.minus(r).getLength() > 0.01) {
                adaptivePoints.add(r);
            }
            int n = 1;
            int n2 = samples.size();
            while (n < n2) {
                void i;
                adaptivePoints.add(samples.get((int)i));
                last2 = samples.get((int)i);
                ++i;
            }
        }
        return adaptivePoints;
    }

    @NotNull
    public static /* synthetic */ List adaptivePositions$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shapeContour.adaptivePositions(d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<List<Vector2>, List<Vector2>> adaptivePositionsAndDirection(double distanceTolerance) {
        List adaptivePoints = new ArrayList();
        List adaptiveNormals = new ArrayList();
        Vector2 last2 = null;
        for (Segment segment : this.segments) {
            Pair<List<Vector2>, List<Vector2>> samples = segment.sampleAdaptiveNormals(distanceTolerance);
            Collection collection = samples.getFirst();
            if (!(!collection.isEmpty())) continue;
            Vector2 r = samples.getFirst().get(0);
            if (last2 == null || last2.minus(r).getLength() > 0.01) {
                adaptivePoints.add(r);
                adaptiveNormals.add(samples.getSecond().get(0).getNormalized());
            }
            int n = 1;
            int n2 = samples.getFirst().size();
            while (n < n2) {
                void i;
                adaptivePoints.add(samples.getFirst().get((int)i));
                adaptiveNormals.add(samples.getSecond().get((int)i).getNormalized());
                last2 = samples.getFirst().get((int)i);
                ++i;
            }
        }
        return new Pair<List<Vector2>, List<Vector2>>(adaptivePoints, adaptiveNormals);
    }

    @NotNull
    public static /* synthetic */ Pair adaptivePositionsAndDirection$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shapeContour.adaptivePositionsAndDirection(d);
    }

    @NotNull
    public final List<Vector2> equidistantPositions(int pointCount) {
        return ShapeToolsKt.sampleEquidistant(ShapeContour.adaptivePositions$default(this, 0.0, 1, null), pointCount);
    }

    @NotNull
    public final ShapeContour sampleLinear(double distanceTolerance) {
        return Companion.fromPoints(this.adaptivePositions(distanceTolerance), this.closed);
    }

    @NotNull
    public static /* synthetic */ ShapeContour sampleLinear$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shapeContour.sampleLinear(d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour sampleEquidistant(int pointCount) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<Vector2> points = this.equidistantPositions(pointCount);
        Iterable iterable = $receiver$iv = (Iterable)RangesKt.until(0, points.size() - 1);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            Segment segment = new Segment(points.get((int)it), points.get((int)(it + true)));
            collection.add(segment);
        }
        List segments = (List)destination$iv$iv;
        return new ShapeContour(segments, this.closed);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour transform(@NotNull Matrix44 transform2) {
        Collection<Segment> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(transform2, "transform");
        Iterable iterable = $receiver$iv = (Iterable)this.segments;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            collection = destination$iv$iv;
            Segment segment2 = it.transform(transform2);
            collection.add(segment2);
        }
        collection = (List)destination$iv$iv;
        boolean bl = this.closed;
        List list = collection;
        return new ShapeContour(list, bl);
    }

    private final double mod(double a2, double b) {
        return (a2 % b + b) % b;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour sub(double u0, double u1) {
        double length;
        int segment0;
        double t0 = u0;
        double t1 = u1;
        if (this.closed && (t1 < t0 || t1 > 1.0 || t0 > 1.0 || t0 < 0.0 || t1 < 0.0)) {
            double diff = t1 - t0;
            t0 = this.mod(t0, 1.0);
            if (Math.abs(diff) < 0.9999999999999998) {
                return diff > 0.0 ? ((t1 = t0 + diff) > 1.0 ? this.sub(t0, 1.0).plus(this.sub(0.0, t1 - 1.0)) : this.sub(t0, t1)) : ((t1 = t0 + diff) < 0.0 ? this.sub(t1 + 1.0, 1.0).plus(this.sub(0.0, t0)) : this.sub(t1, t0));
            }
            double d = t1 = diff < 0.0 ? t0 - 1.0 : t0 + 1.0;
            if (t1 > 1.0) {
                return this.sub(t0, 1.0).plus(this.sub(0.0, t1 - 1.0));
            }
            if (t1 < 1.0) {
                return this.sub(t0, 1.0).plus(this.sub(0.0, t1 + 1.0));
            }
        }
        t0 = RangesKt.coerceIn(t0, 0.0, 1.0);
        t1 = RangesKt.coerceIn(t1, 0.0, 1.0);
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z0 = t1;
            z1 = t0;
        }
        double segmentOffset0 = (segment0 = (int)(z0 * (length = (double)this.segments.size()))) < this.segments.size() ? z0 * length % 1.0 : 1.0;
        int segment1 = (int)(z1 * length);
        double segmentOffset1 = segment1 < this.segments.size() ? z1 * length % 1.0 : 1.0;
        segment1 = Math.min(this.segments.size() - 1, segment1);
        segment0 = Math.min(this.segments.size() - 1, segment0);
        List newSegments = new ArrayList();
        double epsilon = 1.0E-6;
        int n = segment0;
        int n2 = segment1;
        if (n <= n2) {
            while (true) {
                void s2;
                if (s2 == segment0 && s2 == segment1) {
                    newSegments.add(this.segments.get((int)s2).sub(segmentOffset0, segmentOffset1));
                } else if (s2 == segment0) {
                    if (segmentOffset0 < 1.0 - epsilon) {
                        newSegments.add(this.segments.get((int)s2).sub(segmentOffset0, 1.0));
                    }
                } else if (s2 == segment1) {
                    if (segmentOffset1 > epsilon) {
                        newSegments.add(this.segments.get((int)s2).sub(0.0, segmentOffset1));
                    }
                } else {
                    newSegments.add(this.segments.get((int)s2));
                }
                if (s2 == n2) break;
                ++s2;
            }
        }
        return new ShapeContour(newSegments, false);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double on(@NotNull Vector2 point, double error) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        int n = 0;
        int n2 = this.segments.size();
        while (n < n2) {
            void i;
            Double st = this.segments.get((int)i).on(point, error);
            if (st != null) {
                return ((double)i + st) / (double)this.segments.size();
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static /* synthetic */ Double on$default(ShapeContour shapeContour, Vector2 vector2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return shapeContour.on(vector2, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContourProjection project(@NotNull Vector2 point) {
        Object v0;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(point, "point");
        Iterable iterable = $receiver$iv = (Iterable)this.segments;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            void index;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Segment segment = (Segment)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            Pair<Integer, SegmentProjection> pair = new Pair<Integer, SegmentProjection>((int)index, it.project(point));
            collection2.add(pair);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            Pair it = (Pair)minElem$iv;
            double minValue$iv = ((SegmentProjection)it.getSecond()).getDistance();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                Pair it2 = (Pair)e$iv;
                double v$iv = ((SegmentProjection)it2.getSecond()).getDistance();
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            }
            v0 = minElem$iv;
        }
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        Pair nearest = v0;
        return new ContourProjection((SegmentProjection)nearest.getSecond(), (((Number)nearest.getFirst()).doubleValue() + ((SegmentProjection)nearest.getSecond()).getProjection()) / (double)this.segments.size(), ((SegmentProjection)nearest.getSecond()).getDistance(), ((SegmentProjection)nearest.getSecond()).getPoint());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour getReversed() {
        void var3_3;
        Collection<Segment> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.segments;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            collection = destination$iv$iv;
            Segment segment2 = it.getReverse();
            collection.add(segment2);
        }
        collection = (List)var3_3;
        boolean bl = this.closed;
        List<Segment> list = CollectionsKt.reversed((Iterable)collection);
        return new ShapeContour(list, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour map(boolean closed, @NotNull Function1<? super Segment, Segment> mapper) {
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(mapper, "mapper");
        Iterable iterable = $receiver$iv = (Iterable)this.segments;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            destination$iv$iv2.add(mapper.invoke((Segment)item$iv$iv));
        }
        List segments = (List)destination$iv$iv2;
        List fixedSegments = new ArrayList();
        if (segments.size() > 1) {
            int $receiver$iv$iv2 = 0;
            int destination$iv$iv2 = segments.size() - 1;
            while ($receiver$iv$iv2 < destination$iv$iv2) {
                void i;
                Segment left = (Segment)segments.get((int)i);
                Segment right = (Segment)segments.get((int)(i + true));
                Segment fixLeft = new Segment(left.getStart(), left.getControl(), right.getStart());
                fixedSegments.add(fixLeft);
                ++i;
            }
            if (closed) {
                Segment left = (Segment)CollectionsKt.last(segments);
                Segment right = (Segment)CollectionsKt.first(segments);
                fixedSegments.add(new Segment(left.getStart(), left.getControl(), right.getStart()));
            } else {
                fixedSegments.add(CollectionsKt.last(segments));
            }
        }
        return new ShapeContour(segments.size() > 1 ? fixedSegments : segments, closed);
    }

    @NotNull
    public static /* synthetic */ ShapeContour map$default(ShapeContour shapeContour, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = shapeContour.closed;
        }
        return shapeContour.map(bl, function1);
    }

    @NotNull
    public final List<Segment> getSegments() {
        return this.segments;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public ShapeContour(@NotNull List<Segment> segments, boolean closed) {
        Intrinsics.checkParameterIsNotNull(segments, "segments");
        this.segments = segments;
        this.closed = closed;
    }

    @NotNull
    public final List<Segment> component1() {
        return this.segments;
    }

    public final boolean component2() {
        return this.closed;
    }

    @NotNull
    public final ShapeContour copy(@NotNull List<Segment> segments, boolean closed) {
        Intrinsics.checkParameterIsNotNull(segments, "segments");
        return new ShapeContour(segments, closed);
    }

    @NotNull
    public static /* synthetic */ ShapeContour copy$default(ShapeContour shapeContour, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            list = shapeContour.segments;
        }
        if ((n & 2) != 0) {
            bl = shapeContour.closed;
        }
        return shapeContour.copy(list, bl);
    }

    @NotNull
    public String toString() {
        return "ShapeContour(segments=" + this.segments + ", closed=" + this.closed + ")";
    }

    public int hashCode() {
        List<Segment> list = this.segments;
        int n = (list != null ? ((Object)list).hashCode() : 0) * 31;
        int n2 = this.closed ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ShapeContour)) break block3;
                ShapeContour shapeContour = (ShapeContour)object;
                if (!Intrinsics.areEqual(this.segments, shapeContour.segments) || !(this.closed == shapeContour.closed)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/shape/ShapeContour$Companion;", "", "()V", "fromPoints", "Lorg/openrndr/shape/ShapeContour;", "points", "", "Lorg/openrndr/math/Vector2;", "closed", "", "openrndr-shape"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ShapeContour fromPoints(@NotNull List<Vector2> points, boolean closed) {
            Collection<Segment> collection;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(points, "points");
            Iterable iterable = $receiver$iv = (Iterable)RangesKt.until(0, points.size() - 1);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                Segment segment = new Segment(points.get((int)it), points.get((int)(it + true)));
                collection.add(segment);
            }
            collection = (List)destination$iv$iv;
            boolean bl = closed;
            List list = collection;
            return new ShapeContour(list, bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

