/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.camera;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.MappingKt;
import studio.rndr.camera.CameraKey;
import studio.rndr.camera.CameraKeyframer$WhenMappings;
import studio.rndr.camera.CameraKeyframerKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lstudio/rndr/camera/CameraKeyframer;", "", "()V", "keys", "", "Lstudio/rndr/camera/CameraKey;", "getKeys", "()Ljava/util/List;", "frame", "time", "", "Companion", "demo-silo"})
public final class CameraKeyframer {
    @NotNull
    private final List<CameraKey> keys;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<CameraKey> getKeys() {
        return this.keys;
    }

    @NotNull
    public final CameraKey frame(double time) {
        int n;
        block20: {
            if (this.keys.size() == 0) {
                return new CameraKey();
            }
            if (this.keys.size() == 1) {
                return this.keys.get(0);
            }
            if (time <= this.keys.get(0).getTime()) {
                n = 1;
            } else {
                List<CameraKey> $receiver$iv = this.keys;
                int index$iv = 0;
                for (CameraKey item$iv : $receiver$iv) {
                    CameraKey it = item$iv;
                    if (it.getTime() > time) {
                        n = index$iv;
                        break block20;
                    }
                    ++index$iv;
                }
                n = -1;
            }
        }
        int rightIndex = n;
        int leftIndex = rightIndex - 1;
        if (leftIndex >= 0 && rightIndex >= 0) {
            CameraKey cameraKey;
            double d;
            CameraKey left = this.keys.get(leftIndex);
            CameraKey right = this.keys.get(rightIndex);
            double dt = right.getTime() - left.getTime();
            double d0 = Math.max(0.0, time - left.getTime());
            double px = d0 / dt;
            switch (CameraKeyframer$WhenMappings.$EnumSwitchMapping$0[right.getTweenMode().ordinal()]) {
                case 1: {
                    d = px;
                    break;
                }
                case 2: {
                    d = 1.0;
                    break;
                }
                case 3: {
                    d = 0.0;
                    break;
                }
                case 4: {
                    d = MappingKt.smoothstep(0.0, 1.0, px);
                    break;
                }
                case 5: {
                    if (px < 0.5) {
                        d = MappingKt.smoothstep(0.0, 1.0, px);
                        break;
                    }
                    d = px;
                    break;
                }
                case 6: {
                    if (px > 0.5) {
                        d = MappingKt.smoothstep(0.0, 1.0, px);
                        break;
                    }
                    d = px;
                    break;
                }
                case 7: {
                    d = CameraKeyframerKt.expoIn(px);
                    break;
                }
                case 8: {
                    d = CameraKeyframerKt.expoOut(px);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double x = d;
            CameraKey $receiver = cameraKey = new CameraKey();
            $receiver.setPosition(left.getPosition().plus(right.getPosition().minus(left.getPosition()).times(x)));
            $receiver.setSpherical(left.getSpherical().plus(right.getSpherical().minus(left.getSpherical()).times(x)));
            $receiver.setFov(left.getFov() + (right.getFov() - left.getFov()) * x);
            $receiver.setAperture(left.getAperture() + (right.getAperture() - left.getAperture()) * x);
            $receiver.setFocalPlane(left.getFocalPlane() + (right.getFocalPlane() - left.getFocalPlane()) * x);
            $receiver.setExposure(left.getExposure() + (right.getExposure() - left.getExposure()) * x);
            $receiver.setTime(time);
            $receiver.setTweenMode(right.getTweenMode());
            return cameraKey;
        }
        if (rightIndex < 0) {
            return this.keys.get(this.keys.size() - 1);
        }
        return new CameraKey();
    }

    public CameraKeyframer() {
        List list;
        CameraKeyframer cameraKeyframer = this;
        cameraKeyframer.keys = list = (List)new ArrayList();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lstudio/rndr/camera/CameraKeyframer$Companion;", "", "()V", "fromFile", "Lstudio/rndr/camera/CameraKeyframer;", "name", "", "demo-silo"})
    public static final class Companion {
        @NotNull
        public final CameraKeyframer fromFile(@NotNull String name) {
            CameraKeyframer cameraKeyframer;
            Intrinsics.checkParameterIsNotNull(name, "name");
            CameraKeyframer $receiver = cameraKeyframer = new CameraKeyframer();
            $receiver.getKeys().addAll((Collection<CameraKey>)CameraKeyframerKt.loadKeys(new File(name)));
            return cameraKeyframer;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

