/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.camera;

import com.google.gson.Gson;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.dnky.PhotographicRenderer;
import org.openrndr.extras.camera.OrbitalCamera;
import studio.rndr.camera.CameraKey;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u001a\u0010\f\u001a\u00020\n*\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"expoIn", "", "x", "expoOut", "loadKeys", "", "Lstudio/rndr/camera/CameraKey;", "file", "Ljava/io/File;", "saveKeys", "", "keys", "applyTo", "photographicRenderer", "Lorg/openrndr/dnky/PhotographicRenderer;", "orbitalCamera", "Lorg/openrndr/extras/camera/OrbitalCamera;", "demo-silo"})
public final class CameraKeyframerKt {
    public static final double expoIn(double x) {
        return Math.pow(2.0, 10.0 * (x - 1.0));
    }

    public static final double expoOut(double x) {
        return -Math.pow(2.0, -10.0 * x) + 1.0;
    }

    @NotNull
    public static final List<CameraKey> loadKeys(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        String json = FilesKt.readText$default(file, null, 1, null);
        CameraKey[] cameraKeyArray = new Gson().fromJson(json, CameraKey[].class);
        Intrinsics.checkExpressionValueIsNotNull(cameraKeyArray, "Gson().fromJson(json, Ar\u2026y<CameraKey>::class.java)");
        List<Object> keys2 = ArraysKt.toList((Object[])cameraKeyArray);
        return keys2;
    }

    public static final void saveKeys(@NotNull File file, @NotNull List<CameraKey> keys2) {
        String json;
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(keys2, "keys");
        String string = json = new Gson().toJson(keys2);
        Intrinsics.checkExpressionValueIsNotNull(string, "json");
        FilesKt.writeText$default(file, string, null, 2, null);
    }

    public static final void applyTo(@NotNull CameraKey $receiver, @NotNull PhotographicRenderer photographicRenderer, @NotNull OrbitalCamera orbitalCamera) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(photographicRenderer, "photographicRenderer");
        Intrinsics.checkParameterIsNotNull(orbitalCamera, "orbitalCamera");
        orbitalCamera.setView($receiver.getPosition(), $receiver.getSpherical(), $receiver.getFov());
        photographicRenderer.setAperture($receiver.getAperture());
        photographicRenderer.setExposure($receiver.getExposure());
        photographicRenderer.setFocalPlane($receiver.getFocalPlane());
    }
}

