#version 450
layout(set = 0, binding = 0) uniform _Time { float Time; };
layout(set = 0, binding = 1) uniform _Offset { vec2 Offset; };
layout(set = 0, binding = 2) uniform _Zoom { float Zoom; };
layout(location = 0) in vec2 fsin_Position;
layout(location = 0) out vec4 fsout_Color;
float beat = 0.9375;
float beats = (Time / beat);
vec2 pR(vec2 p, float a)
{
p = ((p * cos(a)) + (vec2(p.y, (-p.x)) * sin(a)));
return p;

}

float rand1d(float n)
{
return fract((sin(n) * 43758.55));

}

float noise(vec2 uv, float intensity)
{
return min(1.0, ((1.0 / (rand1d(((uv.x * 20.0) + 1.0)) + rand1d((uv.y * 40.0)))) * intensity));

}

float spikeFunc(float x)
{
return max(min(min(fract(x / -2.) * 2. -1., sin((x + 1.) / 0.31831 ) + 1.), sin((x - 1.278) / 0.31831) + 0.645), 0.);

}

float superclamp(float val, float start, float end)
{
float dur = (end - start);
float halfdur = (dur / 2.0);
float prog = (clamp(val, start, end) - start);
return ((halfdur - abs((prog - halfdur))) / halfdur);

}

float sphere(vec3 p, float radius)
{
return length(p) - radius;

}

vec3 ror2;
vec4 scene(vec3 p)
{
float l = (round((pR((p.zy * 1.5), (floor((((smoothstep((p.x / 1.0), 0.0, 0.1) - (p.z / 1.0)) / (1.3 / (p.z / 1.0))) * 7.0)) / 7.0)).x * 7.0)) / 7.0);
float sphere = sphere(p, 1.0);
float r = (floor((pR(vec2(pR(vec2(length(vec2((round((pR(vec2((p.y * 1.0), pR((p.yz * 2.0), pR(vec2((p.x * 1.0), cos(sin(((beats * 1.57) * 0.25)))), (p.z / 1.0)).x).y), sin(((beats * 1.57) * 0.25))).y * 7.0)) / 7.0), sin(((beats * 1.57) * 0.25)))), (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y * 7.0)) / 7.0);
float g = pR(vec2(((round((sin(length(vec2(((pR(vec2((tan(((beats * 3.14) * 0.5)) / 2.0), 3.1416), (beats * 0.25)).x - (length(p) * 10.0)) + (tan(((beats * 3.14) * 0.5)) / 2.0)), 3.1416))) * 7.0)) / 7.0) - sin(((beats * 1.57) * 0.25))), (p.y / 1.0)), (beats * 0.25)).x;
float b = (floor(((cos(((tan((((tan(((beats * 3.14) * 0.5)) / 2.0) + (p.z / 1.0)) - sin(((beats * 1.57) * 0.25)))) / 2.0) / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0)))) - sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0);
vec3 c = clamp(vec3(r, g, b), 0.1, 1.0);
return vec4((c / l), min(0.001, (l + sphere)));

}

vec3 march(vec2 uv)
{
float beaty = ((sin(((beats * 3.14) * 0.1)) - 0.5) * 1.0);
vec3 cameraOrigin = (vec3(((0.0 + Offset.x) + beaty), (0.0 + Offset.y), 4.0) * (1.0 + (Zoom * Zoom)));
vec3 cameraTarget = vec3(0.0, 0.0, 0.0);
vec3 upDirection = vec3(0.0, 1.0, 0.0);
vec3 cameraDir = normalize((cameraTarget - cameraOrigin));
vec3 cameraRight = normalize(cross(upDirection, cameraOrigin));
vec3 cameraUp = cross(cameraDir, cameraRight);
vec3 rayDir = normalize((((cameraRight * uv.x) + (cameraUp * uv.y)) + cameraDir));
float MAX_DIST = 1000.0;
float EPSILON = 0.001;
float totalDist = 0.0;
vec3 p = cameraOrigin;
float dist = EPSILON;
vec3 resultColor = vec3(0.0);
for(int index = 0;(index < 10000);index = (index + 1))
{
if (dist < EPSILON || totalDist > MAX_DIST) break;
vec4 result = scene(p);
dist = result.w;
resultColor = result.xyz;
totalDist = (totalDist + dist);
p = (p + (vec3(dist) * rayDir));

}

vec3 c = vec3(0.0);
if(totalDist < MAX_DIST) {;
vec2 eps = vec2(0.0, 0.4);
vec3 normal = normalize(vec3((scene((p + eps.yxx)).w - scene((p - eps.yxx)).w), (scene((p + eps.xyx)).w - scene((p - eps.xyx)).w), (scene((p + eps.xxy)).w - scene((p - eps.xxy)).w)));
float diffuse = max(0.0, dot((-rayDir), normal));
float specular = pow(diffuse, 10.0);
c = (c + (smoothstep(0.0, 1.2, (diffuse + 0.05)) * 0.85));
c = (c + (smoothstep(0.0, 1.0, specular) * 0.1));
c = (sqrt((c - vec3(0.1))) * 1.05);
c = (c * resultColor);
} else {;
};
return c;

}

void main()
{
vec2 uv = fsin_Position;
uv = vec2((uv.x * 1.777778), uv.y);
vec3 c = vec3(0.0);
c = march(uv);
fsout_Color = vec4(c, 1.0);

}

