/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IEntry;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.IMap;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.LinearMap;
import io.lacuna.bifurcan.Lists;
import io.lacuna.bifurcan.Map;
import io.lacuna.bifurcan.Sets;
import io.lacuna.bifurcan.utils.Iterators;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;

public class Maps {
    private static final Object DEFAULT_VALUE = new Object();
    public static BinaryOperator MERGE_LAST_WRITE_WINS = (a2, b) -> b;
    public static final IMap EMPTY = new IMap(){

        public Object get(Object key, Object defaultValue) {
            return defaultValue;
        }

        public boolean contains(Object key) {
            return false;
        }

        public IList<IEntry> entries() {
            return Lists.EMPTY;
        }

        public long indexOf(Object key) {
            return -1L;
        }

        public IEntry nth(long index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public long size() {
            return 0L;
        }

        public IMap put(Object key, Object value2, BinaryOperator merge) {
            return new Map().put(key, value2, merge);
        }

        public IMap remove(Object key) {
            return this;
        }

        @Override
        public IMap forked() {
            return this;
        }

        @Override
        public IMap linear() {
            return new Map().linear();
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IMap) {
                return ((IMap)obj).size() == 0L;
            }
            return false;
        }

        public IMap clone() {
            return this;
        }

        public String toString() {
            return Maps.toString(this);
        }
    };

    public static <K, V> String toString(IMap<K, V> m) {
        return Maps.toString(m, Objects::toString, Objects::toString);
    }

    public static <K, V> String toString(IMap<K, V> m, Function<K, String> keyPrinter, Function<V, String> valPrinter) {
        StringBuilder sb = new StringBuilder("{");
        Iterator<IEntry<K, V>> it = m.entries().iterator();
        while (it.hasNext()) {
            IEntry<K, V> entry = it.next();
            sb.append(keyPrinter.apply(entry.key()));
            sb.append(" ");
            sb.append(valPrinter.apply(entry.value()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static <K, V> long hash(IMap<K, V> m) {
        return Maps.hash(m, e -> Objects.hash(e.key()) * 31 ^ Objects.hash(e.value()), (a2, b) -> a2 + b);
    }

    public static <K, V> long hash(IMap<K, V> m, ToLongFunction<IEntry<K, V>> hash, LongBinaryOperator combiner) {
        return m.entries().stream().mapToLong(hash).reduce(combiner).orElse(0L);
    }

    public static <K, V> boolean equals(IMap<K, V> a2, IMap<K, V> b) {
        return Maps.equals(a2, b, Objects::equals);
    }

    public static <K, V> boolean equals(IMap<K, V> a2, IMap<K, V> b, BiPredicate<V, V> valEquals) {
        if (a2.size() != b.size()) {
            return false;
        }
        if (a2 == b) {
            return true;
        }
        return a2.entries().stream().allMatch(e -> {
            IMap m = b;
            Object val = m.get(e.key(), DEFAULT_VALUE);
            return val != DEFAULT_VALUE && valEquals.test(val, e.value());
        });
    }

    public static <K, V> IMap<K, V> from(ISet<K> keys2, Function<K, V> lookup) {
        return Maps.from(keys2, lookup, () -> Iterators.map(keys2.iterator(), k -> new Entry(k, lookup.apply(k))));
    }

    public static <K, V> IMap<K, V> from(final ISet<K> keys2, final Function<K, V> lookup, final Supplier<Iterator<IEntry<K, V>>> iterator2) {
        return new IMap<K, V>(){

            @Override
            public V get(K key, V defaultValue) {
                if (keys2.contains(key)) {
                    return lookup.apply(key);
                }
                return defaultValue;
            }

            @Override
            public Optional<V> get(K key) {
                if (keys2.contains(key)) {
                    return Optional.ofNullable(lookup.apply(key));
                }
                return Optional.empty();
            }

            @Override
            public boolean contains(K key) {
                return keys2.contains(key);
            }

            @Override
            public Iterator<IEntry<K, V>> iterator() {
                return (Iterator)iterator2.get();
            }

            @Override
            public long indexOf(K key) {
                return keys2.indexOf(key);
            }

            @Override
            public IEntry<K, V> nth(long index) {
                Object key = keys2.nth(index);
                return new Entry(key, lookup.apply(key));
            }

            @Override
            public ISet<K> keys() {
                return keys2;
            }

            @Override
            public long size() {
                return keys2.size();
            }

            public int hashCode() {
                return (int)Maps.hash(this);
            }

            public boolean equals(Object obj) {
                if (obj instanceof IMap) {
                    return Maps.equals(this, (IMap)obj);
                }
                return false;
            }

            @Override
            public IMap<K, V> clone() {
                return this;
            }

            public String toString() {
                return Maps.toString(this);
            }
        };
    }

    public static <K, V> java.util.Map<K, V> toMap(final IMap<K, V> map2) {
        return new java.util.Map<K, V>(){

            @Override
            public int size() {
                return (int)map2.size();
            }

            @Override
            public boolean isEmpty() {
                return map2.size() == 0L;
            }

            @Override
            public boolean containsKey(Object key) {
                return map2.get(key).isPresent();
            }

            @Override
            public boolean containsValue(Object value2) {
                return map2.entries().stream().anyMatch(e -> Objects.equals(value2, e.value()));
            }

            @Override
            public V get(Object key) {
                return map2.get(key).orElse(null);
            }

            @Override
            public V put(K key, V value2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(java.util.Map<? extends K, ? extends V> m) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<K> keySet() {
                return Sets.toSet(Lists.lazyMap(map2.entries(), IEntry::key), k -> map2.get(k).isPresent());
            }

            @Override
            public Collection<V> values() {
                return Lists.toList(Lists.lazyMap(map2.entries(), IEntry::value));
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return Sets.toSet(Lists.lazyMap(map2.entries(), Maps::toEntry), e -> map2.get(e.getKey()).map(v -> Objects.equals(v, e.getValue())).orElse(false));
            }

            public String toString() {
                return Maps.toString(map2);
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof java.util.Map) {
                    java.util.Map m = (java.util.Map)obj;
                    if (this.size() != m.size()) {
                        return false;
                    }
                    if (this == m) {
                        return true;
                    }
                    return m.entrySet().stream().allMatch(e -> {
                        Object val = ((Map)map2).get(e.getKey(), DEFAULT_VALUE);
                        return val != DEFAULT_VALUE && Objects.equals(val, e.getValue());
                    });
                }
                return false;
            }

            @Override
            public int hashCode() {
                return (int)Maps.hash(map2, e -> Objects.hashCode(e.key()) ^ Objects.hashCode(e.value()), (a2, b) -> a2 + b);
            }
        };
    }

    public static <K, V> Map.Entry<K, V> toEntry(final IEntry<K, V> entry) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return entry.key();
            }

            @Override
            public V getValue() {
                return entry.value();
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    static <K, V> IMap<K, V> difference(IMap<K, V> map2, ISet<K> keys2) {
        for (K key : keys2) {
            map2 = map2.remove(key);
        }
        return map2;
    }

    static <K, V> IMap<K, V> intersection(IMap<K, V> accumulator, IMap<K, V> map2, ISet<K> keys2) {
        if (map2.size() < keys2.size()) {
            for (IEntry<K, V> entry : map2.entries()) {
                if (!keys2.contains(entry.key())) continue;
                accumulator.put(entry.key(), entry.value());
            }
        } else {
            for (K key : keys2) {
                Object value2 = map2.get(key, DEFAULT_VALUE);
                if (value2 == DEFAULT_VALUE) continue;
                accumulator = accumulator.put(key, value2);
            }
        }
        return accumulator;
    }

    static <K, V> IMap<K, V> merge(IMap<K, V> a2, IMap<K, V> b, BinaryOperator<V> mergeFn) {
        for (IEntry<K, V> e : b.entries()) {
            a2 = a2.put(e.key(), e.value(), mergeFn);
        }
        return a2;
    }

    public static <T, K, V> Collector<T, LinearMap<K, V>, LinearMap<K, V>> linearCollector(Function<T, K> keyFn, Function<T, V> valFn, int capacity) {
        return Maps.linearCollector(keyFn, valFn, MERGE_LAST_WRITE_WINS, capacity);
    }

    public static <T, K, V> Collector<T, LinearMap<K, V>, LinearMap<K, V>> linearCollector(Function<T, K> keyFn, Function<T, V> valFn) {
        return Maps.linearCollector(keyFn, valFn, MERGE_LAST_WRITE_WINS, 8);
    }

    public static <T, K, V> Collector<T, LinearMap<K, V>, LinearMap<K, V>> linearCollector(final Function<T, K> keyFn, final Function<T, V> valFn, final BinaryOperator<V> mergeFn, final int capacity) {
        return new Collector<T, LinearMap<K, V>, LinearMap<K, V>>(){

            @Override
            public Supplier<LinearMap<K, V>> supplier() {
                return () -> new LinearMap(capacity);
            }

            @Override
            public BiConsumer<LinearMap<K, V>, T> accumulator() {
                return (m, e) -> m.put(keyFn.apply(e), valFn.apply(e));
            }

            @Override
            public BinaryOperator<LinearMap<K, V>> combiner() {
                return (a2, b) -> a2.merge(b, mergeFn);
            }

            @Override
            public Function<LinearMap<K, V>, LinearMap<K, V>> finisher() {
                return x -> x;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
            }
        };
    }

    public static <T, K, V> Collector<T, Map<K, V>, Map<K, V>> collector(Function<T, K> keyFn, Function<T, V> valFn) {
        return Maps.collector(keyFn, valFn, MERGE_LAST_WRITE_WINS);
    }

    public static <T, K, V> Collector<T, Map<K, V>, Map<K, V>> collector(final Function<T, K> keyFn, final Function<T, V> valFn, final BinaryOperator<V> mergeFn) {
        return new Collector<T, Map<K, V>, Map<K, V>>(){

            @Override
            public Supplier<Map<K, V>> supplier() {
                return () -> new Map().linear();
            }

            @Override
            public BiConsumer<Map<K, V>, T> accumulator() {
                return (m, e) -> m.put(keyFn.apply(e), valFn.apply(e));
            }

            @Override
            public BinaryOperator<Map<K, V>> combiner() {
                return (a2, b) -> a2.merge((IMap)b, mergeFn);
            }

            @Override
            public Function<Map<K, V>, Map<K, V>> finisher() {
                return Map::forked;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.noneOf(Collector.Characteristics.class);
            }
        };
    }

    static class VirtualMap<K, V>
    implements IMap<K, V> {
        private IMap<K, V> canonical = null;
        private IMap<K, V> base;
        private IMap<K, V> added;
        private ISet<K> removed;
        private ISet<K> shadowed;
        private final boolean linear;

        public VirtualMap(IMap<K, V> base) {
            this(base, EMPTY, Sets.EMPTY, Sets.EMPTY, false);
        }

        private VirtualMap(IMap<K, V> base, IMap<K, V> added, ISet<K> removed, ISet<K> shadowed, boolean linear) {
            this.base = base;
            this.added = added;
            this.removed = removed;
            this.shadowed = shadowed;
            this.linear = linear;
        }

        private void canonicalize() {
            if (this.canonical != null) {
                return;
            }
            this.canonical = ((Map)Map.from(this.base).union((IMap)this.added)).difference((ISet)this.removed);
            if (this.linear) {
                this.canonical = this.canonical.linear();
            }
            this.base = null;
            this.added = null;
            this.shadowed = null;
            this.removed = null;
        }

        private boolean altered() {
            return this.shadowed.size() > 0L || this.removed.size() > 0L;
        }

        @Override
        public synchronized V get(K key, V defaultValue) {
            if (this.canonical != null) {
                return this.canonical.get(key, defaultValue);
            }
            if (this.removed.contains(key)) {
                return defaultValue;
            }
            V val = this.added.get(key, defaultValue);
            return val == defaultValue ? this.base.get(key, defaultValue) : val;
        }

        @Override
        public synchronized IMap<K, V> put(K key, V value2, BinaryOperator<V> merge) {
            if (this.canonical != null) {
                return this.canonical.put(key, value2, merge);
            }
            if (this.added.contains(key) || !this.base.contains(key)) {
                IMap<K, V> addedPrime = this.added.put(key, value2, merge);
                return this.linear ? this : new VirtualMap<K, V>(this.base, addedPrime, this.removed, this.shadowed, false);
            }
            IMap<K, V> addedPrime = this.added.put(key, merge.apply(this.added.get(key).orElse(null), value2));
            ISet<K> shadowedPrime = this.shadowed.add(key);
            ISet<K> removedPrime = this.removed.remove(key);
            return this.linear ? this : new VirtualMap<K, V>(this.base, addedPrime, removedPrime, shadowedPrime, false);
        }

        @Override
        public synchronized IMap<K, V> remove(K key) {
            if (this.canonical != null) {
                return this.canonical.remove(key);
            }
            if (!this.contains(key)) {
                return this;
            }
            IMap<K, V> addedPrime = this.added.remove(key);
            if (this.shadowed.contains(key)) {
                ISet<K> shadowedPrime = this.shadowed.remove(key);
                ISet<K> removedPrime = this.removed.add(key);
                return this.linear ? this : new VirtualMap<K, V>(this.base, addedPrime, removedPrime, shadowedPrime, false);
            }
            return this.linear ? this : new VirtualMap<K, V>(this.base, addedPrime, this.removed, this.shadowed, false);
        }

        @Override
        public synchronized IMap<K, V> forked() {
            if (this.canonical != null) {
                return this.canonical.forked();
            }
            return this.linear ? new VirtualMap<K, V>(this.base, this.added.forked(), this.removed.forked(), this.shadowed.forked(), false) : this;
        }

        @Override
        public synchronized IMap<K, V> linear() {
            if (this.canonical != null) {
                return this.canonical.linear();
            }
            return this.linear ? this : new VirtualMap<K, V>(this.base, this.added.linear(), this.removed.linear(), this.shadowed.linear(), true);
        }

        @Override
        public synchronized boolean contains(K key) {
            if (this.canonical != null) {
                return this.canonical.contains(key);
            }
            return this.added.contains(key) || !this.removed.contains(key) && this.base.contains(key);
        }

        @Override
        public synchronized Iterator<IEntry<K, V>> iterator() {
            if (this.canonical != null) {
                return this.canonical.iterator();
            }
            if (!this.altered()) {
                return Iterators.concat(this.added.iterator(), this.base.iterator());
            }
            return Iterators.concat(this.added.iterator(), Iterators.filter(this.base.iterator(), e -> !this.shadowed.contains(e.key()) && !this.removed.contains(e.key())));
        }

        @Override
        public long indexOf(K key) {
            if (!this.altered()) {
                long idx = this.added.indexOf(key);
                if (idx == -1L) {
                    idx = this.base.indexOf(key);
                    return idx == -1L ? idx : this.added.size() + idx;
                }
                return idx;
            }
            this.canonicalize();
            return this.canonical.indexOf(key);
        }

        @Override
        public IEntry<K, V> nth(long index) {
            if (!this.altered()) {
                if (index < this.added.size()) {
                    return this.added.nth(index);
                }
                return this.base.nth(index - this.added.size());
            }
            this.canonicalize();
            return this.canonical.nth(index);
        }

        @Override
        public synchronized long size() {
            return this.canonical != null ? this.canonical.size() : this.base.size() + (this.added.size() - this.shadowed.size()) - this.removed.size();
        }

        public int hashCode() {
            return (int)Maps.hash(this);
        }

        public boolean equals(Object obj) {
            if (obj instanceof IMap) {
                return Maps.equals(this, (IMap)obj);
            }
            return false;
        }

        @Override
        public VirtualMap<K, V> clone() {
            return new VirtualMap<K, V>(this.base, this.added.clone(), this.removed.clone(), this.shadowed.clone(), this.isLinear());
        }

        public String toString() {
            return Maps.toString(this);
        }
    }

    public static class Entry<K, V>
    implements IEntry<K, V> {
        public final K key;
        public final V value;

        public Entry(K key, V value2) {
            this.key = key;
            this.value = value2;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        public String toString() {
            return this.key + " = " + this.value;
        }

        public int hashCode() {
            return Objects.hash(this.key) * 31 + Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof IEntry) {
                IEntry e = (IEntry)obj;
                return Objects.equals(this.key, e.key()) && Objects.equals(this.value, e.value());
            }
            return false;
        }
    }
}

