/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.utils;

import io.lacuna.bifurcan.LinearList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Iterators {
    private static final Object NONE = new Object();
    public static final Iterator EMPTY = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    };

    public static <V> boolean equals(Iterator<V> a2, Iterator<V> b, BiPredicate<V, V> equals) {
        while (a2.hasNext()) {
            if (equals.test(a2.next(), b.next())) continue;
            return false;
        }
        return true;
    }

    public static <V> Iterator<V> singleton(final V val) {
        return new Iterator<V>(){
            boolean consumed = false;

            @Override
            public boolean hasNext() {
                return !this.consumed;
            }

            @Override
            public V next() {
                if (!this.consumed) {
                    this.consumed = true;
                    return val;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <V> Iterator<V> filter(final Iterator<V> it, final Predicate<V> f) {
        return new Iterator<V>(){
            private Object next = Iterators.access$000();
            private boolean done = false;

            private void prime() {
                if (this.next == NONE && !this.done) {
                    while (it.hasNext()) {
                        this.next = it.next();
                        if (!f.test(this.next)) continue;
                        return;
                    }
                    this.done = true;
                }
            }

            @Override
            public boolean hasNext() {
                this.prime();
                return !this.done;
            }

            @Override
            public V next() {
                this.prime();
                if (this.next == NONE) {
                    throw new NoSuchElementException();
                }
                Object val = this.next;
                this.next = NONE;
                return val;
            }
        };
    }

    public static <U, V> Iterator<V> map(final Iterator<U> it, final Function<U, V> f) {
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public V next() {
                return f.apply(it.next());
            }
        };
    }

    public static <U, V> Iterator<V> flatMap(final Iterator<U> it, final Function<U, Iterator<V>> f) {
        return new Iterator<V>(){
            Iterator<V> curr = EMPTY;

            private void prime() {
                while (!this.curr.hasNext() && it.hasNext()) {
                    this.curr = (Iterator)f.apply(it.next());
                }
            }

            @Override
            public boolean hasNext() {
                this.prime();
                return this.curr.hasNext();
            }

            @Override
            public V next() {
                this.prime();
                return this.curr.next();
            }
        };
    }

    public static <V> Iterator<V> range(final long min, final long max, final LongFunction<V> f) {
        return new Iterator<V>(){
            long i;
            {
                this.i = min;
            }

            @Override
            public boolean hasNext() {
                return this.i < max;
            }

            @Override
            public V next() {
                if (this.hasNext()) {
                    return f.apply(this.i++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <V> Iterator<V> range(long max, LongFunction<V> f) {
        return Iterators.range(0L, max, f);
    }

    public static <V> Iterator<V> concat(Iterator<V> ... iterators) {
        if (iterators.length == 1) {
            return iterators[0];
        }
        IteratorStack<V> stack = new IteratorStack<V>();
        for (Iterator<V> it : iterators) {
            stack.addLast(it);
        }
        return stack;
    }

    public static <V> Stream<V> toStream(Iterator<V> it) {
        return Iterators.toStream(it, 0L);
    }

    public static <V> Stream<V> toStream(Iterator<V> it, long estimatedSize) {
        return StreamSupport.stream(Spliterators.spliterator(it, estimatedSize, 16), false);
    }

    public static class IteratorStack<V>
    implements Iterator<V> {
        LinearList<Iterator<V>> iterators = new LinearList();

        public IteratorStack() {
        }

        public IteratorStack(Iterator<V> ... its) {
            for (Iterator<V> it : its) {
                this.iterators.addFirst((Object)it);
            }
        }

        private void primeIterator() {
            while (this.iterators.size() > 0L && !((Iterator)this.iterators.first()).hasNext()) {
                this.iterators.removeFirst();
            }
        }

        @Override
        public boolean hasNext() {
            this.primeIterator();
            return this.iterators.size() > 0L && ((Iterator)this.iterators.first()).hasNext();
        }

        @Override
        public V next() {
            this.primeIterator();
            if (this.iterators.size() == 0L) {
                throw new NoSuchElementException();
            }
            return (V)((Iterator)this.iterators.first()).next();
        }

        public void addFirst(Iterator<V> it) {
            this.iterators.addFirst((Object)it);
        }

        public void addLast(Iterator<V> it) {
            this.iterators.addLast((Object)it);
        }
    }
}

