/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ArrayTexture;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Filter;
import org.openrndr.draw.FilterKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.draw.Shader;
import org.openrndr.draw.ShaderWatcher;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Matrix55;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0019J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u001bR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/draw/Filter;", "", "shader", "Lorg/openrndr/draw/Shader;", "watcher", "Lorg/openrndr/draw/ShaderWatcher;", "(Lorg/openrndr/draw/Shader;Lorg/openrndr/draw/ShaderWatcher;)V", "padding", "", "getPadding", "()I", "setPadding", "(I)V", "parameters", "", "", "getParameters", "()Ljava/util/Map;", "apply", "", "source", "", "Lorg/openrndr/draw/ColorBuffer;", "target", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;)V", "([Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/draw/ColorBuffer;)V", "(Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;)V", "Lorg/openrndr/draw/RenderTarget;", "Companion", "openrndr-core"})
public class Filter {
    @NotNull
    private final Map<String, Object> parameters;
    private int padding;
    private final Shader shader;
    private final ShaderWatcher watcher;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, Object> getParameters() {
        return this.parameters;
    }

    public final int getPadding() {
        return this.padding;
    }

    public final void setPadding(int n) {
        this.padding = n;
    }

    public final void apply(@NotNull RenderTarget source, @NotNull RenderTarget target2) {
        Collection $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target2, "target");
        Collection collection = source.getColorBuffers();
        Filter filter2 = this;
        boolean $i$f$toTypedArray = false;
        void v0 = $this$toTypedArray$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = v0;
        ColorBuffer[] colorBufferArray = thisCollection$iv.toArray(new ColorBuffer[0]);
        if (colorBufferArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ColorBuffer[] colorBufferArray2 = colorBufferArray;
        $this$toTypedArray$iv = target2.getColorBuffers();
        $i$f$toTypedArray = false;
        Collection collection2 = $this$toTypedArray$iv;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        thisCollection$iv = collection2;
        ColorBuffer[] colorBufferArray3 = thisCollection$iv.toArray(new ColorBuffer[0]);
        if (colorBufferArray3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ColorBuffer[] colorBufferArray4 = colorBufferArray3;
        filter2.apply(colorBufferArray2, colorBufferArray4);
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target2) {
        int n;
        Shader shader2;
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target2, "target");
        ColorBuffer[] colorBufferArray = target2;
        boolean bl = false;
        if (colorBufferArray.length == 0) {
            return;
        }
        if (this.watcher != null) {
            shader2 = this.watcher.getShader();
            if (shader2 == null) {
                Intrinsics.throwNpe();
            }
        } else {
            shader2 = this.shader;
            if (shader2 == null) {
                Intrinsics.throwNpe();
            }
        }
        Shader shader3 = shader2;
        RenderTarget renderTarget2 = RenderTargetKt.renderTarget$default(target2[0].getWidth(), target2[0].getHeight(), target2[0].getContentScale(), null, apply.renderTarget.1.INSTANCE, 8, null);
        ColorBuffer[] $this$forEach$iv = target2;
        boolean $i$f$forEach2 = false;
        ColorBuffer[] colorBufferArray2 = $this$forEach$iv;
        int n2 = colorBufferArray2.length;
        for (n = 0; n < n2; ++n) {
            ColorBuffer element$iv;
            ColorBuffer it = element$iv = colorBufferArray2[n];
            boolean bl2 = false;
            renderTarget2.attach(it);
        }
        renderTarget2.bind();
        if (FilterKt.access$getFilterQuad$p() == null) {
            Object $i$f$forEach2 = new VertexFormat();
            VertexBuffer.Companion companion = VertexBuffer.Companion;
            boolean bl3 = false;
            n2 = 0;
            Object $this$apply = $i$f$forEach2;
            boolean bl4 = false;
            ((VertexFormat)$this$apply).position(2);
            VertexFormat.textureCoordinate$default((VertexFormat)$this$apply, 2, 0, 2, null);
            VertexFormat vertexFormat2 = $i$f$forEach2;
            VertexBuffer fq = companion.createDynamic(vertexFormat2, 6);
            $i$f$forEach2 = fq.getShadow().writer();
            bl3 = false;
            n2 = 0;
            $this$apply = $i$f$forEach2;
            boolean bl5 = false;
            $this$apply.write(new Vector2(0.0, 1.0));
            $this$apply.write(new Vector2(0.0, 0.0));
            $this$apply.write(new Vector2(0.0, 0.0));
            $this$apply.write(new Vector2(0.0, 1.0));
            $this$apply.write(new Vector2(1.0, 0.0));
            $this$apply.write(new Vector2(1.0, 1.0));
            $this$apply.write(new Vector2(0.0, 1.0));
            $this$apply.write(new Vector2(0.0, 0.0));
            $this$apply.write(new Vector2(1.0, 1.0));
            $this$apply.write(new Vector2(1.0, 0.0));
            $this$apply.write(new Vector2(1.0, 0.0));
            $this$apply.write(new Vector2(1.0, 1.0));
            VertexBufferShadow.DefaultImpls.upload$default(fq.getShadow(), 0, 0, 3, null);
            fq.getShadow().destroy();
            FilterKt.access$setFilterQuad$p(fq);
        }
        shader3.begin();
        ColorBuffer[] $this$forEachIndexed$iv = source;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (ColorBuffer item$iv : $this$forEachIndexed$iv) {
            void colorBuffer;
            int n3 = index$iv++;
            ColorBuffer bl2 = item$iv;
            int index = n3;
            boolean bl6 = false;
            colorBuffer.bind(index);
            shader3.uniform("tex" + index, index);
        }
        Driver.Companion.getInstance().setState(FilterKt.access$getFilterDrawStyle$p());
        shader3.uniform("projectionMatrix", TransformsKt.ortho(0.0, target2[0].getWidth(), target2[0].getHeight(), 0.0, -1.0, 1.0));
        shader3.uniform("targetSize", new Vector2(target2[0].getWidth(), target2[0].getHeight()));
        shader3.uniform("padding", new Vector2(this.padding, this.padding));
        int textureIndex = source.length;
        Map<String, Object> $this$forEach$iv2 = this.parameters;
        boolean $i$f$forEach3 = false;
        Map<String, Object> map2 = $this$forEach$iv2;
        n = 0;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$uniform$value = element$iv = iterator2.next();
            boolean bl7 = false;
            Map.Entry entry = $dstr$uniform$value;
            int n4 = 0;
            String uniform2 = (String)entry.getKey();
            entry = $dstr$uniform$value;
            n4 = 0;
            Object value2 = entry.getValue();
            if ((entry = value2) instanceof Boolean) {
                shader3.uniform(uniform2, (Boolean)value2);
                continue;
            }
            if (entry instanceof Float) {
                shader3.uniform(uniform2, ((Number)value2).floatValue());
                continue;
            }
            if (entry instanceof Double) {
                shader3.uniform(uniform2, (float)((Number)value2).doubleValue());
                continue;
            }
            if (entry instanceof Matrix44) {
                shader3.uniform(uniform2, (Matrix44)value2);
                continue;
            }
            if (entry instanceof Vector2) {
                shader3.uniform(uniform2, (Vector2)value2);
                continue;
            }
            if (entry instanceof Vector3) {
                shader3.uniform(uniform2, (Vector3)value2);
                continue;
            }
            if (entry instanceof Vector4) {
                shader3.uniform(uniform2, (Vector4)value2);
                continue;
            }
            if (entry instanceof ColorRGBa) {
                shader3.uniform(uniform2, (ColorRGBa)value2);
                continue;
            }
            if (entry instanceof Integer) {
                shader3.uniform(uniform2, ((Number)value2).intValue());
                continue;
            }
            if (entry instanceof Matrix55) {
                shader3.uniform(uniform2, ((Matrix55)value2).getFloatArray());
                continue;
            }
            if (entry instanceof float[]) {
                shader3.uniform(uniform2, (float[])value2);
                continue;
            }
            if (entry instanceof Object[]) {
                if (((Object[])value2).length <= 0) continue;
                Object object = ((Object[])value2)[0];
                if (object instanceof Vector2) {
                    Object v = value2;
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector2>");
                    }
                    shader3.uniform(uniform2, (Vector2[])v);
                    continue;
                }
                if (object instanceof Vector3) {
                    Object v = value2;
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector3>");
                    }
                    shader3.uniform(uniform2, (Vector3[])v);
                    continue;
                }
                if (object instanceof Vector4) {
                    Object v = value2;
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector4>");
                    }
                    shader3.uniform(uniform2, (Vector4[])v);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder().append("unsupported array value: ");
                Object object2 = ((Object[])value2)[0];
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                throw (Throwable)new IllegalArgumentException(stringBuilder.append(object2.getClass()).toString());
            }
            if (entry instanceof ColorBuffer) {
                shader3.uniform(String.valueOf(uniform2), textureIndex);
                ((ColorBuffer)value2).bind(textureIndex);
                n4 = textureIndex;
                textureIndex = n4 + 1;
                continue;
            }
            if (entry instanceof Cubemap) {
                shader3.uniform(String.valueOf(uniform2), textureIndex);
                ((Cubemap)value2).bind(textureIndex);
                n4 = textureIndex;
                textureIndex = n4 + 1;
                continue;
            }
            if (!(entry instanceof ArrayTexture)) continue;
            shader3.uniform(String.valueOf(uniform2), textureIndex);
            ((ArrayTexture)value2).bind(textureIndex);
            n4 = textureIndex;
            textureIndex = n4 + 1;
        }
        Driver driver = Driver.Companion.getInstance();
        VertexBuffer vertexBuffer = FilterKt.access$getFilterQuad$p();
        if (vertexBuffer == null) {
            Intrinsics.throwNpe();
        }
        driver.drawVertexBuffer(shader3, CollectionsKt.listOf(vertexBuffer), DrawPrimitive.TRIANGLES, 0, 6);
        shader3.end();
        renderTarget2.unbind();
        renderTarget2.detachColorBuffers();
        renderTarget2.destroy();
    }

    public final void apply(@NotNull ColorBuffer source, @NotNull ColorBuffer target2) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target2, "target");
        this.apply(new ColorBuffer[]{source}, new ColorBuffer[]{target2});
    }

    public final void apply(@NotNull ColorBuffer source, @NotNull ColorBuffer[] target2) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target2, "target");
        this.apply(new ColorBuffer[]{source}, target2);
    }

    public final void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer target2) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target2, "target");
        this.apply(source, new ColorBuffer[]{target2});
    }

    public Filter(@Nullable Shader shader2, @Nullable ShaderWatcher watcher) {
        Map map2;
        this.shader = shader2;
        this.watcher = watcher;
        Filter filter2 = this;
        boolean bl = false;
        filter2.parameters = map2 = (Map)new LinkedHashMap();
    }

    public /* synthetic */ Filter(Shader shader2, ShaderWatcher shaderWatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            shader2 = null;
        }
        if ((n & 2) != 0) {
            shaderWatcher = null;
        }
        this(shader2, shaderWatcher);
    }

    public Filter() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/draw/Filter$Companion;", "", "()V", "filterVertexCode", "", "getFilterVertexCode", "()Ljava/lang/String;", "openrndr-core"})
    public static final class Companion {
        @NotNull
        public final String getFilterVertexCode() {
            return Driver.Companion.getInstance().internalShaderResource("filter.vert");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

