/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Spherical;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3Kt;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 B2\u00020\u0001:\u0001BB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J'\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010.\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u00d6\u0003J\u0011\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u000205H\u0082\u0002J\t\u00106\u001a\u000205H\u00d6\u0001J\u0011\u00107\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0011\u00108\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0011\u00109\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010<\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010<\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010=\u001a\u00020>J\t\u0010?\u001a\u00020@H\u00d6\u0001J\t\u0010A\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\tR\u0011\u0010!\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\tR\u0011\u0010$\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0017\u00a8\u0006C"}, d2={"Lorg/openrndr/math/Vector3;", "Ljava/io/Serializable;", "x", "", "y", "z", "(DDD)V", "length", "getLength", "()D", "normalized", "getNormalized", "()Lorg/openrndr/math/Vector3;", "spherical", "Lorg/openrndr/math/Spherical;", "getSpherical", "()Lorg/openrndr/math/Spherical;", "squaredLength", "getSquaredLength", "getX", "xy", "Lorg/openrndr/math/Vector2;", "getXy", "()Lorg/openrndr/math/Vector2;", "xyz0", "Lorg/openrndr/math/Vector4;", "getXyz0", "()Lorg/openrndr/math/Vector4;", "xyz1", "getXyz1", "xz", "getXz", "getY", "yx", "getYx", "getZ", "zx", "getZx", "component1", "component2", "component3", "copy", "cross", "v", "div", "s", "dot", "equals", "", "other", "", "get", "i", "", "hashCode", "minus", "plus", "projectedOn", "reflect", "surfaceNormal", "times", "toDoubleArray", "", "toString", "", "unaryMinus", "Companion", "openrndr-math"})
public final class Vector3
implements Serializable {
    private final double x;
    private final double y;
    private final double z;
    @NotNull
    private static final Vector3 ZERO;
    @NotNull
    private static final Vector3 ONE;
    @NotNull
    private static final Vector3 UNIT_X;
    @NotNull
    private static final Vector3 UNIT_Y;
    @NotNull
    private static final Vector3 UNIT_Z;
    public static final Companion Companion;

    @NotNull
    public final Vector4 getXyz0() {
        return new Vector4(this.x, this.y, this.z, 0.0);
    }

    @NotNull
    public final Vector4 getXyz1() {
        return new Vector4(this.x, this.y, this.z, 1.0);
    }

    @NotNull
    public final Vector2 getXy() {
        return new Vector2(this.x, this.y);
    }

    @NotNull
    public final Vector2 getYx() {
        return new Vector2(this.y, this.x);
    }

    @NotNull
    public final Vector2 getZx() {
        return new Vector2(this.z, this.x);
    }

    @NotNull
    public final Vector2 getXz() {
        return new Vector2(this.x, this.z);
    }

    @NotNull
    public final Vector3 getNormalized() {
        double l;
        block3: {
            block2: {
                double d = l = 1.0 / this.getLength();
                boolean bl = false;
                if (Double.isNaN(d)) break block2;
                d = l;
                bl = false;
                if (!Double.isInfinite(d)) break block3;
            }
            return ZERO;
        }
        return this.times(l);
    }

    @NotNull
    public final Vector3 reflect(@NotNull Vector3 surfaceNormal) {
        Intrinsics.checkParameterIsNotNull(surfaceNormal, "surfaceNormal");
        return this.minus(surfaceNormal.times(this.dot(surfaceNormal)).times(2.0));
    }

    private final double get(int i) {
        double d;
        switch (i) {
            case 0: {
                d = this.x;
                break;
            }
            case 1: {
                d = this.y;
                break;
            }
            case 2: {
                d = this.z;
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported index");
            }
        }
        return d;
    }

    @NotNull
    public final Vector3 unaryMinus() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    @NotNull
    public final Vector3 plus(@NotNull Vector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vector3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    @NotNull
    public final Vector3 minus(@NotNull Vector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vector3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    @NotNull
    public final Vector3 times(@NotNull Vector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vector3(this.x * v.x, this.y * v.y, this.z * v.z);
    }

    @NotNull
    public final Vector3 times(double s2) {
        return new Vector3(this.x * s2, this.y * s2, this.z * s2);
    }

    @NotNull
    public final Vector3 div(double s2) {
        return new Vector3(this.x / s2, this.y / s2, this.z / s2);
    }

    @NotNull
    public final Vector3 div(@NotNull Vector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vector3(this.x / v.x, this.y / v.y, this.z / v.z);
    }

    public final double dot(@NotNull Vector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    @NotNull
    public final Vector3 cross(@NotNull Vector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vector3(this.y * v.z - this.z * v.y, -(this.x * v.z - this.z * v.x), this.x * v.y - this.y * v.x);
    }

    @NotNull
    public final Vector3 projectedOn(@NotNull Vector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return Vector3Kt.times(this.dot(v) / v.dot(v), v);
    }

    public final double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final double getSquaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @NotNull
    public final double[] toDoubleArray() {
        return new double[]{this.x, this.y, this.z};
    }

    @NotNull
    public final Spherical getSpherical() {
        return Spherical.Companion.fromVector(this);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    static {
        Companion = new Companion(null);
        ZERO = new Vector3(0.0, 0.0, 0.0);
        ONE = new Vector3(1.0, 1.0, 1.0);
        UNIT_X = new Vector3(1.0, 0.0, 0.0);
        UNIT_Y = new Vector3(0.0, 1.0, 0.0);
        UNIT_Z = new Vector3(0.0, 0.0, 1.0);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final Vector3 copy(double x, double y, double z) {
        return new Vector3(x, y, z);
    }

    public static /* synthetic */ Vector3 copy$default(Vector3 vector3, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector3.x;
        }
        if ((n & 2) != 0) {
            d2 = vector3.y;
        }
        if ((n & 4) != 0) {
            d3 = vector3.z;
        }
        return vector3.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "Vector3(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public int hashCode() {
        return (Double.hashCode(this.x) * 31 + Double.hashCode(this.y)) * 31 + Double.hashCode(this.z);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vector3)) break block3;
                Vector3 vector3 = (Vector3)object;
                if (Double.compare(this.x, vector3.x) != 0 || Double.compare(this.y, vector3.y) != 0 || Double.compare(this.z, vector3.z) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/openrndr/math/Vector3$Companion;", "", "()V", "ONE", "Lorg/openrndr/math/Vector3;", "getONE", "()Lorg/openrndr/math/Vector3;", "UNIT_X", "getUNIT_X", "UNIT_Y", "getUNIT_Y", "UNIT_Z", "getUNIT_Z", "ZERO", "getZERO", "fromSpherical", "s", "Lorg/openrndr/math/Spherical;", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final Vector3 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector3 getONE() {
            return ONE;
        }

        @NotNull
        public final Vector3 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final Vector3 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final Vector3 getUNIT_Z() {
            return UNIT_Z;
        }

        @NotNull
        public final Vector3 fromSpherical(@NotNull Spherical s2) {
            Intrinsics.checkParameterIsNotNull(s2, "s");
            double sinPhiRadius = Math.sin(s2.getPhi()) * s2.getRadius();
            return new Vector3(sinPhiRadius * Math.sin(s2.getTheta()), Math.cos(s2.getPhi()) * s2.getRadius(), sinPhiRadius * Math.cos(s2.getTheta()));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

