/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.math.transforms.TransformsKt;
import org.openrndr.shape.Circle;
import org.openrndr.shape.Color;
import org.openrndr.shape.Composition;
import org.openrndr.shape.CompositionNode;
import org.openrndr.shape.GroupNode;
import org.openrndr.shape.LineSegment;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeNode;
import org.openrndr.shape.StrokeWeight;
import org.openrndr.shape.TextNode;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001eJ\u000e\u0010#\u001a\u00020$2\u0006\u0010#\u001a\u00020(J\u001c\u0010)\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020&0+2\u0006\u0010'\u001a\u00020\u001eJ\"\u0010)\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020&0+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001e0+J\u0014\u0010)\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0+J\u000e\u0010-\u001a\u00020$2\u0006\u0010-\u001a\u00020.J\u0014\u0010/\u001a\u00020$2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0+J\u001f\u00100\u001a\u00020$2\u0017\u00101\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020$02\u00a2\u0006\u0002\b3J\u0014\u00104\u001a\u00020$2\f\u00105\u001a\b\u0012\u0004\u0012\u00020&0+J\u0016\u00106\u001a\u00020$2\u0006\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020&J\u000e\u00106\u001a\u00020$2\u0006\u00106\u001a\u000209J\u0014\u0010:\u001a\u00020$2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002090+J\u0014\u0010;\u001a\u00020$2\f\u00105\u001a\b\u0012\u0004\u0012\u00020&0+J\u0006\u0010<\u001a\u00020$J\u0006\u0010=\u001a\u00020$J&\u0010>\u001a\u00020$2\u0006\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u001eJ\u000e\u0010>\u001a\u00020$2\u0006\u0010>\u001a\u00020CJ$\u0010D\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020&0+2\u0006\u0010A\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u001eJ\"\u0010D\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020&0+2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020&0+J\u0014\u0010D\u001a\u00020$2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020C0+J\u000e\u0010F\u001a\u00020$2\u0006\u0010G\u001a\u00020\u001eJ\u000e\u0010H\u001a\u00020$2\u0006\u0010I\u001a\u00020\u001eJ\u0016\u0010H\u001a\u00020$2\u0006\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u001eJ\u000e\u0010J\u001a\u00020$2\u0006\u0010J\u001a\u00020KJ\u0014\u0010L\u001a\u00020$2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020K0+J\u0016\u0010M\u001a\u00020$2\u0006\u0010M\u001a\u00020N2\u0006\u0010%\u001a\u00020&J\u0016\u0010O\u001a\u00020$2\u0006\u0010M\u001a\u00020N2\u0006\u0010P\u001a\u00020.J\"\u0010Q\u001a\u00020$2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020N0+2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020&0+J\u0016\u0010R\u001a\u00020$2\u0006\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u001eJ\u000e\u0010R\u001a\u00020$2\u0006\u0010S\u001a\u00020&R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\f\"\u0004\b\u001c\u0010\u000eR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006T"}, d2={"Lorg/openrndr/shape/CompositionDrawer;", "", "()V", "composition", "Lorg/openrndr/shape/Composition;", "getComposition", "()Lorg/openrndr/shape/Composition;", "cursor", "Lorg/openrndr/shape/GroupNode;", "fill", "Lorg/openrndr/color/ColorRGBa;", "getFill", "()Lorg/openrndr/color/ColorRGBa;", "setFill", "(Lorg/openrndr/color/ColorRGBa;)V", "model", "Lorg/openrndr/math/Matrix44;", "getModel", "()Lorg/openrndr/math/Matrix44;", "setModel", "(Lorg/openrndr/math/Matrix44;)V", "modelStack", "Ljava/util/Stack;", "root", "getRoot", "()Lorg/openrndr/shape/GroupNode;", "stroke", "getStroke", "setStroke", "strokeWeight", "", "getStrokeWeight", "()D", "setStrokeWeight", "(D)V", "circle", "", "position", "Lorg/openrndr/math/Vector2;", "radius", "Lorg/openrndr/shape/Circle;", "circles", "positions", "", "radii", "contour", "Lorg/openrndr/shape/ShapeContour;", "contours", "group", "builder", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "lineLoop", "points", "lineSegment", "start", "end", "Lorg/openrndr/shape/LineSegment;", "lineSegments", "lineStrip", "popModel", "pushModel", "rectangle", "x", "y", "width", "height", "Lorg/openrndr/shape/Rectangle;", "rectangles", "dimensions", "rotate", "rotationInDegrees", "scale", "s", "shape", "Lorg/openrndr/shape/Shape;", "shapes", "text", "", "textOnContour", "path", "texts", "translate", "t", "openrndr-shape"})
public final class CompositionDrawer {
    @NotNull
    private final GroupNode root = new GroupNode(null, 1, null);
    @NotNull
    private final Composition composition = new Composition(this.root);
    private GroupNode cursor = this.root;
    private final Stack<Matrix44> modelStack = new Stack();
    @NotNull
    private Matrix44 model = Matrix44.Companion.getIDENTITY();
    @Nullable
    private ColorRGBa fill;
    @Nullable
    private ColorRGBa stroke = ColorRGBa.Companion.getBLACK();
    private double strokeWeight = 1.0;

    @NotNull
    public final GroupNode getRoot() {
        return this.root;
    }

    @NotNull
    public final Composition getComposition() {
        return this.composition;
    }

    @NotNull
    public final Matrix44 getModel() {
        return this.model;
    }

    public final void setModel(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.model = matrix44;
    }

    @Nullable
    public final ColorRGBa getFill() {
        return this.fill;
    }

    public final void setFill(@Nullable ColorRGBa colorRGBa) {
        this.fill = colorRGBa;
    }

    @Nullable
    public final ColorRGBa getStroke() {
        return this.stroke;
    }

    public final void setStroke(@Nullable ColorRGBa colorRGBa) {
        this.stroke = colorRGBa;
    }

    public final double getStrokeWeight() {
        return this.strokeWeight;
    }

    public final void setStrokeWeight(double d) {
        this.strokeWeight = d;
    }

    public final void pushModel() {
        this.modelStack.push(this.model);
    }

    public final void popModel() {
        Matrix44 matrix44 = this.modelStack.pop();
        Intrinsics.checkExpressionValueIsNotNull(matrix44, "modelStack.pop()");
        this.model = matrix44;
    }

    public final void group(@NotNull Function1<? super CompositionDrawer, Unit> builder) {
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        GroupNode g = new GroupNode(null, 1, null);
        GroupNode oldCursor = this.cursor;
        this.cursor.getChildren().add(g);
        this.cursor = g;
        builder.invoke(this);
        this.cursor = oldCursor;
    }

    public final void translate(double x, double y) {
        this.translate(new Vector2(x, y));
    }

    public final void rotate(double rotationInDegrees) {
        this.model = this.model.times(TransformsKt.rotateZ(Matrix44.Companion, rotationInDegrees));
    }

    public final void scale(double s2) {
        this.model = this.model.times(TransformsKt.scale(Matrix44.Companion, s2, s2, s2));
    }

    public final void scale(double x, double y) {
        this.model = this.model.times(TransformsKt.scale(Matrix44.Companion, x, y, 1.0));
    }

    public final void translate(@NotNull Vector2 t) {
        Intrinsics.checkParameterIsNotNull(t, "t");
        this.model = this.model.times(TransformsKt.translate(Matrix44.Companion, Vector2.vector3$default(t, 0.0, 0.0, 0.0, 7, null)));
    }

    public final void contour(@NotNull ShapeContour contour2) {
        Intrinsics.checkParameterIsNotNull(contour2, "contour");
        Shape shape = new Shape(CollectionsKt.listOf(contour2));
        this.shape(shape);
    }

    public final void contours(@NotNull List<ShapeContour> contours) {
        Intrinsics.checkParameterIsNotNull(contours, "contours");
        Iterable $this$forEach$iv = contours;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShapeContour it = (ShapeContour)element$iv;
            boolean bl = false;
            this.contour(it);
        }
    }

    public final void shape(@NotNull Shape shape) {
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        ShapeNode shapeNode = new ShapeNode(shape);
        shapeNode.setTransform(this.model);
        shapeNode.setFill(new Color(this.fill));
        shapeNode.setStroke(new Color(this.stroke));
        shapeNode.setStrokeWeight(new StrokeWeight(this.strokeWeight));
        this.cursor.getChildren().add(shapeNode);
    }

    public final void shapes(@NotNull List<Shape> shapes) {
        Intrinsics.checkParameterIsNotNull(shapes, "shapes");
        Iterable $this$forEach$iv = shapes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Shape it = (Shape)element$iv;
            boolean bl = false;
            this.shape(it);
        }
    }

    public final void rectangle(@NotNull Rectangle rectangle) {
        Intrinsics.checkParameterIsNotNull(rectangle, "rectangle");
        this.contour(rectangle.getContour());
    }

    public final void rectangle(double x, double y, double width, double height) {
        this.rectangle(new Rectangle(x, y, width, height));
    }

    public final void rectangles(@NotNull List<Rectangle> rectangles) {
        Intrinsics.checkParameterIsNotNull(rectangles, "rectangles");
        Iterable $this$forEach$iv = rectangles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rectangle it = (Rectangle)element$iv;
            boolean bl = false;
            this.rectangle(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void rectangles(@NotNull List<Vector2> positions, double width, double height) {
        Collection<Rectangle> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        Iterable iterable = positions;
        CompositionDrawer compositionDrawer = this;
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector2 vector2 = (Vector2)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Rectangle rectangle = new Rectangle((Vector2)it, width, height);
            collection.add(rectangle);
        }
        collection = (List)destination$iv$iv;
        compositionDrawer.rectangles((List<Rectangle>)collection);
    }

    /*
     * WARNING - void declaration
     */
    public final void rectangles(@NotNull List<Vector2> positions, @NotNull List<Vector2> dimensions) {
        Collection<Rectangle> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        Intrinsics.checkParameterIsNotNull(dimensions, "dimensions");
        Iterable iterable = CollectionsKt.zip((Iterable)positions, (Iterable)dimensions);
        CompositionDrawer compositionDrawer = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Rectangle rectangle = new Rectangle((Vector2)it.getFirst(), ((Vector2)it.getSecond()).getX(), ((Vector2)it.getSecond()).getY());
            collection.add(rectangle);
        }
        collection = (List)destination$iv$iv;
        compositionDrawer.rectangles((List<Rectangle>)collection);
    }

    public final void circle(@NotNull Vector2 position, double radius) {
        Intrinsics.checkParameterIsNotNull(position, "position");
        this.circle(new Circle(position, radius));
    }

    public final void circle(@NotNull Circle circle) {
        Intrinsics.checkParameterIsNotNull(circle, "circle");
        this.contour(circle.getContour());
    }

    public final void circles(@NotNull List<Circle> circles) {
        Intrinsics.checkParameterIsNotNull(circles, "circles");
        Iterable $this$forEach$iv = circles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Circle it = (Circle)element$iv;
            boolean bl = false;
            this.circle(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void circles(@NotNull List<Vector2> positions, double radius) {
        Collection<Circle> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        Iterable iterable = positions;
        CompositionDrawer compositionDrawer = this;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector2 vector2 = (Vector2)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Circle circle = new Circle((Vector2)it, radius);
            collection.add(circle);
        }
        collection = (List)destination$iv$iv;
        compositionDrawer.circles((List<Circle>)collection);
    }

    /*
     * WARNING - void declaration
     */
    public final void circles(@NotNull List<Vector2> positions, @NotNull List<Double> radii) {
        Collection<Circle> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        Intrinsics.checkParameterIsNotNull(radii, "radii");
        Iterable iterable = CollectionsKt.zip((Iterable)positions, (Iterable)radii);
        CompositionDrawer compositionDrawer = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Circle circle = new Circle((Vector2)it.getFirst(), ((Number)it.getSecond()).doubleValue());
            collection.add(circle);
        }
        collection = (List)destination$iv$iv;
        compositionDrawer.circles((List<Circle>)collection);
    }

    public final void lineSegment(@NotNull Vector2 start, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        this.lineSegment(new LineSegment(start, end2));
    }

    public final void lineSegment(@NotNull LineSegment lineSegment) {
        Intrinsics.checkParameterIsNotNull(lineSegment, "lineSegment");
        this.contour(lineSegment.getContour());
    }

    public final void lineSegments(@NotNull List<LineSegment> lineSegments) {
        Intrinsics.checkParameterIsNotNull(lineSegments, "lineSegments");
        Iterable $this$forEach$iv = lineSegments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LineSegment it = (LineSegment)element$iv;
            boolean bl = false;
            this.lineSegment(it);
        }
    }

    public final void lineStrip(@NotNull List<Vector2> points) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        this.contour(ShapeContour.Companion.fromPoints(points, false));
    }

    public final void lineLoop(@NotNull List<Vector2> points) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        this.contour(ShapeContour.Companion.fromPoints(points, true));
    }

    public final void text(@NotNull String text2, @NotNull Vector2 position) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        Intrinsics.checkParameterIsNotNull(position, "position");
        GroupNode g = new GroupNode(null, 1, null);
        g.setTransform(TransformBuilderKt.transform((Function1<? super TransformBuilder, Unit>)new Function1<TransformBuilder, Unit>(position){
            final /* synthetic */ Vector2 $position;

            public final void invoke(@NotNull TransformBuilder $this$transform) {
                Intrinsics.checkParameterIsNotNull($this$transform, "$receiver");
                $this$transform.translate(this.$position.getXy0());
            }
            {
                this.$position = vector2;
                super(1);
            }
        }));
        TextNode textNode = new TextNode(text2, null);
        List<CompositionNode> list = g.getChildren();
        boolean bl = false;
        boolean bl2 = false;
        TextNode $this$apply = textNode;
        boolean bl3 = false;
        $this$apply.setFill(new Color(this.fill));
        TextNode textNode2 = textNode;
        list.add(textNode2);
        this.cursor.getChildren().add(g);
    }

    public final void textOnContour(@NotNull String text2, @NotNull ShapeContour path) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        Intrinsics.checkParameterIsNotNull(path, "path");
        this.cursor.getChildren().add(new TextNode(text2, path));
    }

    public final void texts(@NotNull List<String> text2, @NotNull List<Vector2> positions) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)text2, (Iterable)positions);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.text((String)it.getFirst(), (Vector2)it.getSecond());
        }
    }
}

