/*
Log is based on dear imgui's ExampleAppLog under the following license

The MIT License (MIT)

Copyright (c) 2014-2015 Omar Cornut and ImGui contributors

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#ifndef SKUNKWORK_LOG_HPP
#define SKUNKWORK_LOG_HPP

#include <imgui.h>

#define ADD_LOG Log::instance().addLog

class Log
{
public:
    friend class GUILog;

    static Log& instance();

    Log(const Log&) = delete;
    Log& operator=(const Log&) = delete;

    void addLog(const char* fmt, ...) IM_FMTARGS(2);

private:
    Log();
    ~Log() { }

    void clear();
    void draw();

    ImGuiTextBuffer _buf;
    ImGuiTextFilter _filter;
    ImVector<int> _lineOffsets;
    bool _scrollToBottom;
};

// Interface for GUI to enforce both the singleton as well as only GUI being able
// to call clear() or draw() on it
class GUILog
{
private:
    friend class GUI;
    static void clear();
    static void draw();
};

#endif // SKUNKWORK_LOG_HPP
