/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.opengl.PShader;

public class eskowin
extends PApplet {
    Moonlander moonlander;
    PGraphics effect;
    PGraphics postprocess;
    PGraphics vhsprocess;
    PShader sphereGrid;
    PShader xor;
    PShader voxel;
    PShader post;
    PShader vhs;
    PImage blueNoise;
    PImage logo;
    PImage credits;
    PImage message;
    PImage greets;
    PImage title;

    public void setup() {
        this.noStroke();
        this.effect = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.postprocess = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.vhsprocess = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.postprocess.noSmooth();
        this.vhsprocess.noSmooth();
        this.blueNoise = this.loadImage("data/bluenoise.png");
        this.logo = this.loadImage("data/logo.png");
        this.credits = this.loadImage("data/credits.png");
        this.message = this.loadImage("data/message.png");
        this.greets = this.loadImage("data/greets.png");
        this.title = this.loadImage("data/title.png");
        this.sphereGrid = this.loadShader("data/effect.glsl");
        this.sphereGrid.set("resolution", PApplet.parseFloat((int)this.width), PApplet.parseFloat((int)this.height), 0.0f, 0.0f);
        this.sphereGrid.set("blueSampler", this.blueNoise);
        this.xor = this.loadShader("data/xor.glsl");
        this.xor.set("resolution", PApplet.parseFloat((int)this.width), PApplet.parseFloat((int)this.height), 0.0f, 0.0f);
        this.voxel = this.loadShader("data/voxel.glsl");
        this.voxel.set("resolution", PApplet.parseFloat((int)this.width), PApplet.parseFloat((int)this.height), 0.0f, 0.0f);
        this.post = this.loadShader("data/post.glsl");
        this.post.set("resolution", PApplet.parseFloat((int)this.width), PApplet.parseFloat((int)this.height), 0.0f, 0.0f);
        this.vhs = this.loadShader("data/vhs.glsl");
        this.vhs.set("resolution", PApplet.parseFloat((int)this.width), PApplet.parseFloat((int)this.height), 0.0f, 0.0f);
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"data/e17m-19_3b.mp3", (int)128, (int)4);
        this.moonlander.start("localhost", 1338, "data/epoch.rocket");
    }

    public void draw() {
        this.moonlander.update();
        int effectID = (int)this.moonlander.getValue("effect");
        double timeOffset = this.moonlander.getValue("time offset");
        double circleCount = this.moonlander.getValue("circle count");
        double smoothness = this.moonlander.getValue("xor smooth");
        double chroma = this.moonlander.getValue("chrome amt");
        double hueShift = this.moonlander.getValue("hue shift");
        double saturation = this.moonlander.getValue("saturation");
        double distortion = this.moonlander.getValue("vhs distortion");
        double xorNega = this.moonlander.getValue("xor nega");
        double xorZoom = this.moonlander.getValue("xor zoom");
        double moebius = this.moonlander.getValue("moebius amt");
        double moebiusFact = this.moonlander.getValue("moebius fact");
        double moebiusMul = this.moonlander.getValue("moebius mul");
        double panColors = this.moonlander.getValue("pansexual");
        double panThreshold = this.moonlander.getValue("pan threshold");
        double voxelCam = this.moonlander.getValue("voxel cam");
        double voxelLens = this.moonlander.getValue("voxel lens");
        double showLogo = this.moonlander.getValue("show logo");
        double showCredits = this.moonlander.getValue("show credits");
        double showMessage = this.moonlander.getValue("show message");
        double showGreets = this.moonlander.getValue("show greets");
        double showTitle = this.moonlander.getValue("show title");
        double textXor = this.moonlander.getValue("xor text");
        double rocketTime = this.moonlander.getCurrentTime() + timeOffset;
        this.effect.beginDraw();
        this.effect.background(0);
        switch (effectID) {
            case 0: {
                this.sphereGrid.set("time", (float)rocketTime);
                this.sphereGrid.set("moebius", (float)moebius);
                this.sphereGrid.set("moebiusFact", (float)moebiusFact);
                this.sphereGrid.set("moebiusMul", (float)moebiusMul);
                this.sphereGrid.set("panColors", (float)panColors);
                this.sphereGrid.set("panThreshold", (float)panThreshold);
                this.effect.shader(this.sphereGrid);
                break;
            }
            case 1: {
                this.xor.set("time", (float)rocketTime);
                this.xor.set("circleCount", (int)circleCount);
                this.xor.set("smoothness", (float)smoothness);
                this.xor.set("negative", (float)xorNega);
                this.xor.set("zoom", (float)xorZoom);
                this.xor.set("logo", this.logo);
                this.xor.set("title", this.title);
                this.xor.set("greets", this.greets);
                this.xor.set("showlogo", (float)showLogo);
                this.xor.set("showcredits", (float)showCredits);
                this.xor.set("showtitle", (float)showTitle);
                this.xor.set("textxor", (float)textXor);
                this.effect.shader(this.xor);
                break;
            }
            case 2: {
                this.voxel.set("time", (float)rocketTime);
                this.voxel.set("voxelCam", (float)voxelCam);
                this.voxel.set("voxelLens", (float)voxelLens);
                this.effect.shader(this.voxel);
                break;
            }
        }
        this.effect.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
        this.effect.endDraw();
        this.postprocess.beginDraw();
        this.postprocess.background(0);
        this.postprocess.shader(this.post);
        this.post.set("time", (float)rocketTime);
        this.post.set("tex", (PImage)this.effect);
        this.post.set("chromaStrength", (float)chroma);
        this.post.set("hueShift", (float)hueShift);
        this.post.set("saturation", (float)saturation);
        this.post.set("logo", this.logo);
        this.post.set("credits", this.credits);
        this.post.set("message", this.message);
        this.post.set("greets", this.greets);
        this.post.set("title", this.title);
        this.post.set("showlogo", (float)showLogo);
        this.post.set("showcredits", (float)showCredits);
        this.post.set("showmessage", (float)showMessage);
        this.post.set("showgreets", (float)showGreets);
        this.post.set("showtitle", (float)showTitle);
        this.post.set("textxor", (float)textXor);
        this.postprocess.image((PImage)this.effect, 0.0f, 0.0f);
        this.postprocess.endDraw();
        this.vhsprocess.beginDraw();
        this.vhsprocess.background(0);
        this.vhsprocess.shader(this.vhs);
        this.vhs.set("tex", (PImage)this.postprocess);
        this.vhs.set("time", (float)rocketTime);
        this.vhs.set("distortion", (float)distortion);
        this.vhsprocess.image((PImage)this.postprocess, 0.0f, 0.0f);
        this.vhsprocess.endDraw();
        this.image((PImage)this.vhsprocess, 0.0f, 0.0f);
    }

    public void settings() {
        this.size(1280, 720, "processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"eskowin"};
        if (passedArgs != null) {
            PApplet.main((String[])eskowin.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

