//#define PROCESSING_COLOR_SHADER

uniform float time;
uniform vec4 resolution;
uniform int circleCount;
uniform float negative;
uniform float zoom;
uniform float smoothness;

uniform sampler2D logo;
uniform sampler2D credits;
uniform sampler2D title;
uniform float showlogo;
uniform float showcredits;
uniform float showtitle;
uniform float textxor;

vec4 hash(float p){
    vec4 p4 = fract(vec4(p)*vec4(1031,.1030,.0973,.1099));
    p4 += dot(p4,p4.wzxy+19.19);
    return fract((p4.xxyz+p4.yzzw)*p4.zywx);
}

float circle(vec2 uv, float r){
    float f = smoothness;//mix(0.1, 2.0, max(1.0, length(uv)));
    float e = max(fwidth(uv).x, fwidth(uv).y)/f;
    return 1.0-smoothstep(-e, e, length(uv)-r);
}

float xor(float a, float b){
    return min(a+b, 2.0-a-b);
}

void main(){
    vec2 uv = -1.0+2.0*gl_FragCoord.xy/resolution.xy;
    uv.x *= resolution.x/resolution.y;
    uv /= zoom;
	
    float a = 0.0;
    float t = time+10.0;
    
    const float pi = 3.14159;
    //const int S = 200;
    for(int i = 0; i < circleCount; ++i){
        vec4 h  = hash(float(i));
        
        vec2 m  = vec2(sin(t*h.z+h.x*pi), cos(t*h.w+h.y*pi))/3.0;
        vec2 o  = (m-1.0+2.0*h.xy)/1.5;
        float s = mix(0.45, 0.12, length(o));
        a = xor(a, circle(uv+o, s));
    }
    
    vec2 ut = gl_FragCoord.xy/resolution.xy;
    a = xor(a, texture2D(logo, vec2(ut.x, 1.0-ut.y) ).r*showlogo*textxor);
    a = xor(a, texture2D(credits, vec2(ut.x, 1.0-ut.y) ).r*showcredits*textxor);
    a = xor(a, texture2D(title, vec2(ut.x, 1.0-ut.y) ).r*showtitle*textxor);
    a = mix(a, 1.0-a, negative);

    gl_FragColor.rgb = vec3(pow(1.0-a, 1.0));
    gl_FragColor.rgb = 0.1+0.8*gl_FragColor.rgb;
    gl_FragColor.a = 1.0;
}