/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Logger;
import moonlander.library.Connector;
import moonlander.library.Controller;
import moonlander.library.Track;
import moonlander.library.TrackContainer;
import moonlander.library.TrackKey;

class SocketConnector
extends Connector {
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;
    private final String CLIENT_GREET = "hello, synctracker!";
    private final String SERVER_GREET = "hello, demo!";

    public SocketConnector(Logger logger, TrackContainer trackContainer, Controller controller, String string, int n) throws Exception {
        super(logger, trackContainer, controller);
        logger.fine(String.format("Trying to connect to Rocket at %s:%d", string, n));
        int n2 = 10;
        for (int i = 0; i < n2; ++i) {
            try {
                this.initSocket(string, n);
                this.greetServer();
                break;
            }
            catch (Exception exception) {
                if (i >= n2 - 1 || this.socket == null) {
                    logger.warning("SocketConnector failed to connect to Rocket the last time.");
                    this.close();
                    throw exception;
                }
                logger.warning("SocketConnector failed to connect to Rocket. Trying again.");
                this.socket.close();
                continue;
            }
        }
        logger.info(String.format("Successfully connected to Rocket running at %s:%d.", string, n));
    }

    private void initSocket(String string, int n) throws Exception {
        try {
            this.socket = new Socket(string, n);
        }
        catch (Exception exception) {
            this.logger.warning(String.format("Connection to %s:%d failed.", string, n));
            throw exception;
        }
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.logger.finer("Connection to Rocket established.");
    }

    private void greetServer() throws Exception {
        this.logger.finer("Sending greetings to Rocket.");
        this.out.writeBytes("hello, synctracker!");
        this.out.flush();
        this.logger.finer("Greetings sent. Now reading greetings from Rocket...");
        byte[] byArray = new byte["hello, demo!".length()];
        try {
            this.in.readFully(byArray, 0, "hello, demo!".length());
        }
        catch (Exception exception) {
            this.logger.severe("Couldn't read greetings from server. " + exception);
            throw new Exception("Reading greetings failed", exception);
        }
        this.logger.finer("Greetings read successfully.");
        if (!"hello, demo!".equals(new String(byArray))) {
            this.logger.severe("Server didn't send correct greetings.");
            throw new Exception("Greetings mismatch");
        }
    }

    @Override
    public void update() {
        try {
            this.readCommand();
        }
        catch (Exception exception) {
            this.logger.severe("Error in readCommand");
        }
    }

    @Override
    public void trackAdded(String string) {
        this.logger.finest("Adding track. Sending Commands.GET_TRACK to Rocket.");
        try {
            this.out.writeByte(2);
            this.out.writeInt(string.length());
            this.out.writeBytes(string);
            this.out.flush();
        }
        catch (Exception exception) {
            this.logger.severe("Communication with Rocket failed!");
        }
        this.logger.finer("New track fetched from Rocket.");
    }

    @Override
    public void controllerStatusChanged(boolean bl) {
    }

    @Override
    public void controllerRowChanged(int n) {
        this.logger.finest("Communicating row=" + n + " change to rocket");
        try {
            this.out.writeByte(3);
            this.out.writeInt(n);
            this.out.flush();
        }
        catch (Exception exception) {
            this.logger.severe("Communication with Rocket failed!");
        }
    }

    public void handleCommandSetKey() throws IOException {
        this.logger.finest("Handling SET_KEY");
        int n = this.in.readInt();
        int n2 = this.in.readInt();
        float f = this.in.readFloat();
        byte by = this.in.readByte();
        Track track = this.tracks.getById(n);
        if (track != null) {
            track.addOrUpdateKey(new TrackKey(n2, f, by));
        }
    }

    public void handleCommandDeleteKey() throws IOException {
        this.logger.finest("Handling DELETE_KEY");
        int n = this.in.readInt();
        int n2 = this.in.readInt();
        Track track = this.tracks.getById(n);
        if (track != null) {
            track.deleteKey(n2);
        }
    }

    public void handleCommandSetRow() throws IOException {
        this.logger.finest("Handling SET_ROW");
        int n = this.in.readInt();
        this.controller.setCurrentRow(n, true);
    }

    public void handleCommandPause() throws IOException {
        this.logger.finest("Handling PAUSE");
        byte by = this.in.readByte();
        if (by > 0) {
            this.controller.pause();
        } else {
            this.controller.play();
        }
    }

    public void handleCommandSaveTracks() throws IOException {
        this.logger.finest("Handling SAVE_TRACKS");
    }

    private void readCommand() throws Exception {
        block7: while (this.in.available() != 0) {
            this.logger.finest("Available bytes from Rocket: " + this.in.available());
            byte by = this.in.readByte();
            switch (by) {
                case 0: {
                    this.handleCommandSetKey();
                    continue block7;
                }
                case 1: {
                    this.handleCommandDeleteKey();
                    continue block7;
                }
                case 3: {
                    this.handleCommandSetRow();
                    continue block7;
                }
                case 4: {
                    this.handleCommandPause();
                    continue block7;
                }
                case 5: {
                    this.handleCommandSaveTracks();
                    continue block7;
                }
            }
            this.logger.warning(String.format("Unknown command id=%d", by));
        }
    }

    private static class Commands {
        static final int SET_KEY = 0;
        static final int DELETE_KEY = 1;
        static final int GET_TRACK = 2;
        static final int SET_ROW = 3;
        static final int PAUSE = 4;
        static final int SAVE_TRACKS = 5;

        private Commands() {
        }
    }
}

