add_library("minim")
minim = Minim(this)

class DeformSphere:
    def __init__(self, rows, columns, r, amp):
        self.rows = rows
        self.columns = columns
        self.iter = PI / columns
        self.points = []
        self.r = r
        self.velocity = 0.005
        self.maxi = r + amp
        self.mini = r - amp
        self.timers = []
        self.t_length = 10
        self.frames = 0
        
        for x in range(0, rows):
            angle = (PI / rows)*x
            yr = sin(angle) * self.r
            y = sin(angle + PI/2)*r
            self.points.append([])
            for p in range(0, 2 * self.columns):
                self.points[-1].append([PVector(cos(self.iter*p)*yr, y, sin(self.iter*p)*yr).mult(random(0.9, 1.1)), random(1) > 0.5])
        
    def draw(self):
        
        background(248,84,100)
        if self.frames < 240:
            camera(width/2.0+ 1280 - self.frames/240.0*1280, height/2.0+720 - self.frames/240.0*720, (height/2.0) / tan(PI*30.0 / 180.0), width/2.0, height/2.0, 0, 0, 1, 0)
            translate(width/2, height/2)
            rotateX(8.74)
            rotateY(0.7)
        elif self.frames <360:
            camera(width/2.0, height/2.0, (height/2.0) / tan(PI*30.0 / 180.0), width/2.0, height/2.0, 0, 0, 1, 0)
            translate(width/2, height/2)
            rotateX(8.74)
            rotateY(0.7)
        else:
            camera(width/2.0, height/2.0, (height/2.0) / tan(PI*30.0 / 180.0), width/2.0, height/2.0, 0, 0, 1, 0)
            translate(width/2, height/2)
            rotateX(PI)
            
            self.frames/240*1280
            self.frames/240*720
        
        if self.frames%15 == 0:
            for i in range(1,10):
                self.points[int(random(self.rows))][int(random(self.columns))][0] = self.points[int(random(self.rows))][int(random(self.columns))][0].mult(3 + self.velocity)
        
        background(248,84,60)
        lightSpecular(328,100,100)
        ambientLight(248,84,60)
        directionalLight(120,120,120, 0,0,0)
        shininess(5.0)
        stroke(328,100,100)
        beginShape(TRIANGLE_STRIP)
        for x in range(0, self.rows - 1):
            for p in range(0, 2*self.columns):
                    
                v1 = self.points[x][p]
                v2 = self.points[x+1][p]
                
                vertex(v1[0].x, v1[0].y, v1[0].z )
                vertex(v2[0].x, v2[0].y, v2[0].z)
                self.vCheck(v1)
                self.vCheck(v2)
        endShape()
        self.frames += 1

    
    def vCheck(self, v):
        leng = sqrt(v[0].x**2 + v[0].y**2 + v[0].z**2)
        if  leng < self.mini:
            v[1] = True
        elif leng > self.maxi:
            v[1] = False
        if v[1]:
            v[0].mult(1 + self.velocity)
        else:
            v[0].mult(1 - self.velocity)
            
class DeformSphere2:
    def __init__(self, rows, columns, r, amp):
        self.rows = rows
        self.columns = columns
        self.iter = PI / columns
        self.points = []
        self.r = r
        self.velocity = 0.005
        self.maxi = r + amp
        self.mini = r - amp
        self.timers = []
        self.t_length = 10
        self.frames = 0
        
        for x in range(0, rows):
            angle = (PI / rows)*x
            yr = sin(angle) * self.r
            y = sin(angle + PI/2)*r
            self.points.append([])
            for p in range(0, 2 * self.columns):
                self.points[-1].append([PVector(cos(self.iter*p)*yr, y, sin(self.iter*p)*yr).mult(random(0.9, 1.1)), random(1) > 0.5])
        
    def draw(self):
        
        background(248,84,100)
        if self.frames < 240:
            camera(width/2.0+ 1280 - self.frames/240.0*1280, height/2.0+720 - self.frames/240.0*720, (height/2.0) / tan(PI*30.0 / 180.0), width/2.0, height/2.0, 0, 0, 1, 0)
            translate(width/2, height/2)
            rotateX(8.74)
            rotateY(0.7)
        elif self.frames <360:
            camera(width/2.0, height/2.0, (height/2.0) / tan(PI*30.0 / 180.0), width/2.0, height/2.0, 0, 0, 1, 0)
            translate(width/2, height/2)
            rotateX(8.74)
            rotateY(0.7)
        else:
            camera(width/2.0, height/2.0, (height/2.0) / tan(PI*30.0 / 180.0), width/2.0, height/2.0, 0, 0, 1, 0)
            translate(width/2, height/2)
            rotateX(PI)
            
            self.frames/240*1280
            self.frames/240*720
        
        if self.frames%15 == 0:
            for i in range(1,10):
                self.points[int(random(self.rows))][int(random(self.columns))][0] = self.points[int(random(self.rows))][int(random(self.columns))][0].mult(3 + self.velocity)
        
        background(248,84,60)
        lightSpecular(328,100,100)
        ambientLight(248,84,60)
        directionalLight(120,120,120, 0,0,0)
        shininess(5.0)
        
        beginShape(TRIANGLE_STRIP)
        for x in range(0, self.rows - 1):
            for p in range(0, 2*self.columns):
            
                v1 = self.points[x][p]
                v2 = self.points[x+1][p]
                v1c = map(sqrt(v1[0].x**2 + v1[0].y**2 + v1[0].z**2), self.mini, self.maxi + 100, 233, 406)
                v2c = map(sqrt(v2[0].x**2 + v2[0].y**2 + v2[0].z**2), self.mini, self.maxi + 100, 233, 406)
                
                stroke(v1c,100,100)
                vertex(v1[0].x, v1[0].y, v1[0].z )
                stroke(v2c,100,100)
                vertex(v2[0].x, v2[0].y, v2[0].z)
                self.vCheck(v1)
                self.vCheck(v2)
        endShape()
        self.frames += 1

    
    def vCheck(self, v):
        leng = sqrt(v[0].x**2 + v[0].y**2 + v[0].z**2)
        if  leng < self.mini:
            v[1] = True
        elif leng > self.maxi:
            v[1] = False
        if v[1]:
            v[0].mult(1 + self.velocity)
        else:
            v[0].mult(1 - self.velocity)
            


class Counter:
    def __init__(self, start=0):
        self.count = start
    def increase(self, amount=1):
        self.count += 1
    def decrease(self, amount=1):
        self.count -= 1
    def value(self):
        return self.count

class Shape(object):
    def __init__(self, x, y, color):
        self.x = x
        self.y = y
        self.z = -100
        self.stroke_color = color
        self.yrotation = 0
        self.rotation = 0
        self.stroke_weight = 1
        
    def draw(self):
        stroke(self.stroke_color)
        strokeWeight(self.stroke_weight)
        #fill(self.stroke_color)
        pushMatrix()
        rotateY(self.yrotation)
        rotateZ(self.rotation)
        translate(self.x, self.y, self.z)
        self.draw_shape()
        popMatrix()
    
    def draw_shape(self):
        raise AssertionError()  
    
    def age(self):
        self.yrotation += 0.02
        self.z += 16

class Polygon(Shape):
    def __init__(self, x, y, color, n, size=200):
        self.corners = n
        self.size = size
        super(Polygon, self).__init__(x,y,color)
    
    def draw_shape(self):
        noFill();
        beginShape();
        for i in range(1, self.corners+1):
            vertex(sin(TAU/self.corners*i)*self.size, cos(TAU/self.corners*i)*self.size)
        endShape(CLOSE);

class Gear(Shape):
    def __init__(self, x, y, color, n, size=200):
        self.corners = n
        self.size = size
        super(Gear, self).__init__(x,y,color)
    
    def draw_shape(self):
        noFill();
        beginShape();
        for i in range(1, self.corners+1):
            if i%4 < 2:
                gearsize = self.size/2
            else:
                gearsize = self.size
            vertex(sin(TAU/self.corners*i)*gearsize, cos(TAU/self.corners*i)*gearsize)
        endShape(CLOSE);

class Star(Shape):
    def __init__(self, x, y, color, n, frame, bg, size=200):
        self.corners = n
        self.counter = frame
        self.counter2 = scene2_bg_counter.value()
        self.current_bg = bg
        self.size = size
        super(Star, self).__init__(x,y,color)
    
    def draw_shape(self):
        #camera(width/2.0, height/2.0, (height/2.0) / tan(PI*30.0 / 180.0), width/2.0, height/2.0, 0, 0, 1, 0)
        # pushMatrix()
        #camera(width, height, height, width/2.0, height/2.0, 0, 1, 1, 1)
        # popMatrix()
        #times = [0, 86, 164, 245, 322, 410, 485, 570]
        #backgrounds = [color(248, 84, 60), color(328,100,100)]
        global scene2_bg_counter
        #if self.counter in times:
        #    increasing = True
        
        if scene2_bg_counter.value() >= 100:
            background(color(328, 100, scene2_bg_counter.value() % 100))
        else:
            background(color(328, 100, 100 - scene2_bg_counter.value() % 100))
        scene2_bg_counter.increase(4)
        if scene2_bg_counter.value() > 199:
            scene2_bg_counter = Counter(0)
        #background(backgrounds[self.current_bg % len(backgrounds)])
        #camera(width/2.0, height/2.0, (height/2.0) / tan(PI*30.0 / 180.0), width/2.0, height/2.0, 0, 0, 1, 0)
        noFill();
        beginShape();
        for i in range(1, self.corners+1):
            if i%4 == 0:
                gearsize = self.size/2
            if i%4 == 1:
                gearsize = self.size
            if i%4 == 2:
                gearsize = self.size/4
            if i%4 == 3:
                gearsize = self.size
            vertex(sin(TAU/self.corners*i)*gearsize, cos(TAU/self.corners*i)*gearsize)
        endShape(CLOSE);


class Square(Polygon):
    def __init__(self, *args, **kwargs):
        self.size = kwargs.get('size', 200)
        args = list(args) + [4]
        super(Square, self).__init__(*args, size=self.size)
        self.rotation = PI/4

class Sphere(Shape):
    def __init__(self, *args, **kwargs):
        self.size = kwargs.get('size', 200)
        self.ures = kwargs.get('ures', 8)
        self.vres = kwargs.get('vres', 8)
        super(Sphere, self).__init__(*args)
        self.rotation = PI/4
        
    def draw_shape(self):
        sphereDetail(self.ures, self.vres)
        sphere(self.size)
                        
class Circle(Shape):
    def draw_shape(self):
        circle(0,0,200)        

class Tunnel:
    def __init__(self):
        self.shapes = []
        self.max_length = 300
        
    def add_square(self, square):
        self.add_shape(square)
        
    def add_shape(self, shape):
        self.shapes.append(shape)
        if len(self.shapes) > self.max_length:
            self.shapes.pop(0)
    def draw(self):
        for shape in self.shapes:
            shape.age()
            shape.draw()
            
class LostInCompilation:
    def __init__(self):
        self.counter = 0

    def draw(self):
        strings = ["TEAM", "LOST", "IN", "COMPILATION", "", "CREW MEMBERS...", u"\"Pointti on se, että...\" -jäbä", "sape", "Iluz", "", "PRESENTS...", "", "Restful Waves"]
        for string in strings:
            item_index = strings.index(string)
            item_distance = -item_index * 1000 - 1300 + self.counter * 17
            #print(string + " distance: " + str(item_distance))
            pushMatrix()
            textMode(SHAPE)
            all_showed = False
            # if item_distance < 300:
            #     fill(lerpColor(color(46,100,97,100), color(46, 100, 97, 0), item_distance / -2500.0))
            # else:
            #     fill(lerpColor(color(46,100,97, 0), color(46, 100, 97, 100), item_distance / 200.0))
            fill(lerpColor(color(46,100,97,100), color(46, 100, 97, 0), item_distance / -2500.0))
            if strings[-1] == string:
                size_multiplier = 4.6
                y_offset = 300
                all_showed = True
            else:
                size_multiplier = 1
                y_offset = 0
            textFont(righteous, 50 * size_multiplier)
            translate(50, y_offset + item_index * 30, item_distance)
            if item_index % 2 == 0:
                dir = 1
            else:
                dir = -0.7
            rotate(dir * map(item_distance, 1000, 10, 0.8, 0.1) - PI/5)
            rotateY(map(item_distance, 1000, 10, 0.8, 0.1))
            text(string, 0, 0)
            popMatrix()
            if all_showed:
                strings = []

    def tick(self):
        self.counter += 1

class Greetingz:
    def __init__(self):
        self.counter = 0

    def draw(self):
        strings = ["GREETINGS TO", 
                   "Bad Felix", 
                   "Graffathon 2019 organizers", 
                   "Fellow Graffathon hackers", 
                   "mom & dad", 
                   "MUSIC", 
                   "VHSailing Rally (original mix)", 
                   "Riverwave", u"川の波", "Creative Commons", 
                   "CC BY-SA 3.0",
                   "",
                   u"サンポ",
                   u"ヨイリ",
                   u"イラリ"]
        for string in strings:
            item_index = strings.index(string)
            item_distance = -item_index * 1000 - 300 + self.counter * 30
            #print(string + " distance: " + str(item_distance))
            pushMatrix()
            textMode(SHAPE)
            all_showed = False
            # if item_distance < 300:
            #     fill(lerpColor(color(46,100,97,100), color(46, 100, 97, 0), item_distance / -2500.0))
            # else:
            #     fill(lerpColor(color(46,100,97, 0), color(46, 100, 97, 100), item_distance / 200.0))
            fill(lerpColor(color(46,100,97,100), color(46, 100, 97, 0), item_distance / -2500.0))
            # if strings[-1] == string:
            #     size_multiplier = 4.6
            #     y_offset = 300
            #     all_showed = True
            # else:
            size_multiplier = 1
            y_offset = 0
            x_offset = len(string) * 2
            if string in [u"サンポ", u"ヨイリ", u"イラリ", u"川の波"]:
                textFont(noto, 50 * size_multiplier)
            else:
                textFont(righteous, 50 * size_multiplier)
            translate(-300 + x_offset, y_offset + item_index * 30, item_distance)
            if item_index % 2 == 0:
                dir = 1
            else:
                dir = -0.7
            rotate(dir * map(item_distance, 1000, 10, 0.8, 0.1) - PI/5)
            rotateY(map(item_distance, 1000, 10, 0.8, 0.1))
            text(string, 0, 0)
            popMatrix()
            if all_showed:
                strings = []

    def tick(self):
        self.counter += 1
        
class Fluid:
    def __init__(self):
        self.swidth = 1920
        self.sheight = self.swidth * 9 / 16
        self.r = self.sheight * 0.25
        self.counter = 0
        self.points = []
        self.reverse = True
        self.h = 250
        self.last = self.h
        self.s = 20
        self.begin = None
        
        self.rows = 160
        self.columns = 160
        self.amp = 15
        self.original_amp = self.amp
        self.velocity = 0.7
        self.original_velocity = self.velocity
        self.z = []
        self.velocity_times = [0,1320,2640,3990,5340,6655,7970,9300,10630,11980,13330,14577,16025,17372,18720,20035,21350,100000000]
        
        for y in range(0,self.rows):
                self.z.append([])
                for x in range(0,self.columns):
                    self.z[-1].append([map(noise(x,y), 0, 1, -self.amp, self.amp), (random(1) > 0.5)])
    def draw(self):
        if self.begin is None:
            self.begin = millis()
        if millis() - self.begin > self.velocity_times[0] + 660:
            self.velocity_times.pop(0)
            #print(self.velocity_times)
            self.velocity = self.original_velocity * 10
            #self.amp = self.original_amp * 5
        else:
            self.velocity *= 0.9
            #self.amp *= 0.8
            self.velocity = max(self.velocity, self.original_velocity)
            #self.amp = max(self.amp, self.original_amp)
        self.counter += 1
        for y in range(0,self.rows):
            for x in range(0,self.columns):
                if self.z[y][x][0] > self.amp or self.z[y][x][0] < -self.amp:
                    self.z[y][x][1] = not self.z[y][x][1]
                if self.z[y][x][1]:
                    self.z[y][x][0] += self.velocity 
                else: 
                    self.z[y][x][0] -= self.velocity
        
        # sin((2*x + counter/3)/(PI/2))*20 + cos((2*y + counter/3)/(PI/2))*20
        # map(noise(random(10),random(10)), 0, 1, -10, 10) + 
        camera(width/2.0, -420 + self.counter * 3, (height/2.0) / tan(PI*30.0 / 180.0) + self.counter, width/2.0 + self.counter * 2, height/2.0 + 400 - self.counter * 1.5, 0, 0, 1, 0)        
        translate(-900,100,100)
        #camera(width/2.0, -420 + self.counter * 2, (height/2.0) / tan(PI*30.0 / 180.0) + self.counter, width/2.0 + self.counter * 2, height/2.0 + 400 - self.counter * 1.5, 0, 0, 1, 0)
        rotateX(PI/3)
        background(248,84,60)
        lightSpecular(328,100,100)
        ambientLight(248,84,60)
        directionalLight(120,120,120, 0,0,0)
        shininess(5.0)
        stroke(248,84,60)
        fill(248,84,60)
        background(248,84,60)
        
        for y in range(0,self.rows - 1):
            beginShape(TRIANGLE_STRIP)
            for x in range(0,self.columns):
                vertex(x*self.s,y*self.s, self.z[y][x][0])
                vertex(x*self.s,(y+1)*self.s, self.z[y+1][x][0])
            endShape()
                


def setup():
    global righteous, cameraI, start_time, current_time, noto
    size(1920, 1080, P3D)
    frameRate(60)
    noCursor()
    fullScreen()
    colorMode(HSB, 360, 100, 100, 100)
    background(0)
    tunnel = Tunnel()
    spherek = DeformSphere(30,30,100, 20) 
    spherek2 = DeformSphere(30,30,100, 20)
    scene2_counter = Counter(0)
    scene2_bg_counter = Counter(0)
    start_time = millis()
    current_time = 0
    righteous = createFont("Righteous-Regular.ttf", 150)
    noto = createFont("NotoSansJP-Bold.otf", 150)
    music = minim.loadFile("music.mp3")
    music.play()


current_time = 0
cameraI = 0
frameNumber = 0
ddblue = color(248, 84, 60)
# In RGB (42, 24, 153)
dblue = color(248, 84, 100)
# In RGB (69, 41, 255)
lblue = color(223,71,100)
orange = color(38,90,98)
yellow = color(46,100,97)
pink = color(328,100,100)

def scene0(frames):
    #colorMode(RGB)
    background(lerpColor(color(0, 0, 100), color(248, 84, 100), frameNumber / float(frames - 10)))
    # global start_sphere
    # if current_time > 600:
    #     start_sphere.draw()
    # if current_time > 1300:
    #     start_sphere.r = 30
    # if current_time > 2000:
    #     start_sphere.r = 50
    # if current_time > 2400:
    #     start_sphere.r = 90
    # if current_time > 2800:
    #     start_sphere.r = 120
    # if current_time > 3000:
    #     start_sphere.r = 220
    # camera()
    #colorMode(HSB)

def scene1():
    background(248,84,60)
    stroke(269, 55, 66)
    strokeWeight(4)
    noFill()
    x = sin(frameNumber/90.0*PI)*1000/4
    y = cos(frameNumber/180.0*PI)*1000/(2*random(1,1.1))
    # if 0 and frameNumber%720 > 360:
    #     sqr = Circle(x,y, color(frameNumber*2%360,100,100))
    # else:
    #     sqr = Polygon(x,y, color(frameNumber*2%360,100,100), 3+frameNumber/100)
    phase = (frameNumber % 720) / 360.0
    if phase > 1:
        phase = 2 - phase
    colorMode(RGB)
    if 0 and frameNumber%720 > 360:
        sqr = Circle(x, y, lerpColor(color(255, 0, 135), color(249, 167, 24), phase))
    else:
        sqr = Polygon(x,y, lerpColor(color(255, 0, 135), color(249, 167, 24), phase), 3+frameNumber/100)
    tunnel.add_square(sqr)
    tunnel.draw()
    colorMode(HSB)
    if lost in compilation:
        lost.draw()
        lost.tick()
        
def scene2():
    #camera()
    #spherek.draw()
    sqr = Star(0,0,color(123,100,100), 4*25, scene2_counter.value(), scene2_bg_counter.value(), size=200+sin(frameNumber/180.0*PI)*300)
    scene2_counter.increase()
    sqr.rotation = frameNumber/180.0*PI
    sqr.yrotation = 2*cos(frameNumber/180.0*PI)*PI
    sqr.ures = int((1+2*cos(frameNumber/180.0*PI))*3)
    sqr.vres = int((1+2*cos(frameNumber/180.0*PI))*3)
    #sqr.stroke_weight = -75*abs(cos(frameNumber/180.0*PI))
    sqr.stroke_weight = abs(3+sin(frameNumber/180.0*PI))
    sqr.draw()
    global greetings
    if greetings is None:
        greetings = Greetingz()
    greetings.draw()
    greetings.tick()
    
def scene3():
    fluid.draw()

def scene5():
    #spherek2.draw()
    #spherek.draw()
    camera()
    scene0(2000)
    greetings.draw()
    greetings.tick()

def draw():
    global cameraI, dblue, lblue, orange, yellow, pink, current_time, start_time, righteous, start_time, current_time, noto
    global frameNumber
    current_time = millis() - start_time
    #print("Current time: " + str(current_time))
    frameNumber += 1
    translate(width/2.0, height/2.0)
    scale(height/1000.0)
    # if 0 and keyPressed:
    #     camera(0, 0, 0, 0, 0, 0, 0, 1, 0)
    #     camera(cameraI / 2, cameraI / 3, 0, 0, 0, 0, 0, 1, 0)
    #     cameraI += 10
    
    #
    # TIMINGS
    #
    framecount1 = 216
    if current_time < 4000:
        scene0(framecount1)
    elif current_time < 25400:
        # Tunnel
        scene1()
    elif current_time < 46970:
        # Fluid
        scene3()
    elif current_time < 57405:
        # Sphere (Joel)
        spherek.draw()
    elif current_time < 78740:
        # Sphere (Iluz) + greez
        scene2()
    elif current_time < 89520:
        # Spherek2
        spherek2.draw()
    elif current_time < 111000:
        scene3()
    else:
        exit()

greetings = None
tunnel = Tunnel()
tunnel2 = Tunnel()
scene2_counter = Counter(0)
scene2_bg_counter = Counter(0)
spherek = DeformSphere(30,30,100, 20) 
spherek2 = DeformSphere(30,30,100, 20)
start_sphere = DeformSphere(30,30,10, 20)
                        
lost = LostInCompilation()
compilation = [lost]
fluid = Fluid()
