import moonlander.library.*;
import ddf.minim.*;

Moonlander moonlander;

//DNA
DNA dna1 = new DNA(100, 100, 10); 

//cube Grid
Cube[] cubes = new Cube[16];
int[] grid;
int cubeSizeInGrid = height/3; // Change size of cubes in grid

//Mato
int w ;
int xspa;
float t = 0;
float amp = height/100;
float per = 500;
float dx;
float [] yvalues;

//Wheel AND tunnel AND PYORRE
float xWheel, yWheel, zWheel;


void setup() {
  fullScreen(P3D);
  moonlander = Moonlander.initWithSoundtrack(this, "remix_su.mp3", 124, 4);
  moonlander.start();
  colorMode(HSB,360,100,100,100);
  noCursor();
  
  
  //Mato
  xspa = width/40;
  w= width + xspa;
  dx = (TWO_PI / per) *xspa;
  yvalues = new float[w/xspa];
  
  //Wheel
  xWheel = width/2;
  yWheel = height/2;
  zWheel = 0;

  //CubeGrid
    
  for (int i = 0; i < cubes.length; i++) {
    cubes[i] = new Cube();
  }
  int gridSize = height/2;
  grid = getGrid(gridSize, width/16, height/16);

}

float rotationDiff = radians(35); // Initial rotation differential
float rotationZ = height/2; // Initial camera depth

void draw() {
  // Moonlander
  moonlander.update();
  float rotationAngle = radians((float)moonlander.getValue("rotationAngle")); // Convert to radians
  float cubeFillHue = (float)moonlander.getValue("cubeFillColor");
  float cubeFillSat = (float)moonlander.getValue("cubeFillSat");
  float cubeFillBri = (float)moonlander.getValue("cubeFillBri");
  float cubeFillA = (float)moonlander.getValue("cubeFillA");
  float cameraZ = (float)moonlander.getValue("cameraZ");
  float cubeScale = (float)moonlander.getValue("cubeScale");
  float textScale = (float)moonlander.getValue("textScale");
  // Background color
  background(0);  
  int scene = moonlander.getIntValue("scene");
  
  double bg_red = moonlander.getValue("background_red");
  int bg_green = moonlander.getIntValue("background_green");
  int bg_blue = moonlander.getIntValue("background_blue");
  
    float gridZoom = (float)moonlander.getValue("gridZoom");
  float gridBri = (float)moonlander.getValue("gridBri");
  float gridRotate = radians((float)moonlander.getValue("gridRotate"));
  float gridDispX = (float)moonlander.getValue("gridDispX");

 
  if (scene == 0) {
    drawCubeGrid(cameraZ, grid, cubeSizeInGrid, gridZoom, gridBri, gridRotate, gridDispX);
    drawCube(rotationAngle, cameraZ, cubeFillHue, cubeFillSat, cubeFillBri, cubeFillA, cubeScale);
  } else if (scene == 1) {
    mato();  
  } else if (scene == 2) {
    wheel();  
  } else if (scene == 3) {
   tunnel(); 
  } else if (scene == 4) {
    pyorre();
  } else if (scene == 5) {
    textMode(SCREEN);
    textSize(26);
    text("Made by team Mato", 2*width/5, height/4);
    textSize(26);
    text("Music credits:", 2*width/5, height/4+40);
    textSize(26);
    text("Daniel Simion - Human Heartbeat Sound", 2*width/5, height/4+80);
    textSize(26);
    text("Hefty - Crack Is Whack", 2*width/5, height/4+120);
    dna1.draw();
  } else if (scene == 6) {
     exit(); 
  }
  // Draw text
  //drawText(textScale, cameraZ);
}

void drawCube(float rotationAngle, float cameraZ,
float cubeFillHue, float cubeFillSat, float cubeFillBri, float cubeFillA, float cubeScale) {
  // Draw cube in the center, with changing HSB and horizontal rotation
  translate(width/2, height/2, cameraZ); // Camera placement
  fill(cubeFillHue,cubeFillSat,cubeFillBri,cubeFillA); // Cube HSB
  rotateY(rotationAngle + rotationDiff); // Cube rotation
  scale(cubeScale); // Cube scale multiplier
  box(height/2); // Draw cube
}

void drawText(float textScale, float cameraZ) {
  textSize(textScale);
  text("This is your companion cube.", width/2, height/2, height/2);
}


void pyorre() {  
  
  double bg_red = moonlander.getValue("background_red");
  int bg_green = moonlander.getIntValue("background_green");
  int bg_blue = moonlander.getIntValue("background_blue");
 
 background((int)bg_red, bg_blue, bg_green);
  stroke(90);
  // https://processing.org/reference/perspective_.html
  float fov = PI/3.0;
  float cameraZ = (height/2.0) / tan(fov / 2.0);  
  perspective(fov, float(width)/float(height), cameraZ/8.0, cameraZ*2.0);  
  
  //Time = Moon lander
  float time = millis()/600.0;
  translate(xWheel, yWheel, zWheel); //  Specifies an amount to displace objects within the display window
  rectMode(CENTER); //Giving center coordinates instead of corner ones
  
  int boxesCount = 12;
  int cubeSize = 40;
  
  for(int i = 0; i < boxesCount; i++) {
    pushMatrix(); //pushing previous translate matrix to stack, REQUIRES popMatrix()
    translate(1.0+10.0*sin(time), 0.0, 150.0*sin(time)); //this moves camera
    translate(90.0, 0.0, 0.0);
    for(int j = 0; j< 12; j++) {
      fill(0+j, 0+j, 0+j);
      pushMatrix();
      rotateZ(j*10.0*(0.1*sin(time/3.0)) + i*0.5 + time*1.0);
      translate(0.0, j*cubeSize, 0.0); //next cube joins previous
      sphere(cubeSize*(j)); 
      popMatrix();
    }
    popMatrix(); //popping translate matrix from stack
  }
 }
  
  
  
 

 void tunnel() {
   noStroke();
  float time = millis()/1000.0;
  int boxesCount = 20;
  double bg_red = moonlander.getValue("background_red");
  int bg_green = moonlander.getIntValue("background_green");
  int bg_blue = moonlander.getIntValue("background_blue");
 
 background((int)bg_red, bg_blue, bg_green);  // https://processing.org/reference/perspective_.html
  float fov = PI/3.0;
  float cameraZ = (height/2.0) / tan(fov / 2.0);  
  perspective(fov, float(width)/float(height), cameraZ/8.0, cameraZ*2.0);
  
  //Time = Moon lander
  //float time = millis()/1000.0; // 100 = faster! Or moonlander.getIntValue("beat")
  translate(xWheel, yWheel, zWheel); //  Specifies an amount to displace objects within the display window
  rectMode(CENTER); //Giving center coordinates instead of corner ones
  
  int cubeSize = 40;
  
  for(int i = 0; i < boxesCount; i++) {
    pushMatrix(); //pushing previous translate matrix to stack, REQUIRES popMatrix()
    translate(1.0+10.0*sin(time), 0.0, 200.0*sin(time));
    rotateZ(PI*2.0*(float)i/(float)boxesCount);
    translate(90.0, 0.0, 0.0);
    for(int j = 0; j< boxesCount; j++) {
      pushMatrix();
      fill(180-j*10, 50, 50);
      translate(0.0, 0.0, j*cubeSize); //next cube joins previous
      box(cubeSize); 
      popMatrix();
    }
    popMatrix(); //popping translate matrix from stack
  }
 }

void wheel() {
  stroke(90);
  double bg_red = moonlander.getValue("background_red");
  int bg_green = moonlander.getIntValue("background_green");
  int bg_blue = moonlander.getIntValue("background_blue");
 
 background((int)bg_red, bg_blue, bg_green);
 float fov = PI/3.0;
  float cameraZ = (height/2.0) / tan(fov / 2.0);  
  perspective(fov, float(width)/float(height), cameraZ/10.0, cameraZ*10.0);
  float time = millis()/100;
  translate(xWheel, yWheel, zWheel);
  rectMode(CENTER); 
  int boxesCount = 30;
  int cubeSize = 40;  
  for(int i = 0; i < boxesCount; i++) {
    pushMatrix();
    translate(1.0+10.0*sin(time), 1.0+20.0*sin(time), 0);
    translate(90.0, 0.0, 0.0);
    for(int j = 0; j< 4; j++) {
      pushMatrix();
      rotateZ(j*10.0*(0.1*sin(time/3.0)) + i*0.5 + time*1.0);
      translate(0.0, j*cubeSize, 0);
        
      box(cubeSize, cubeSize, cubeSize); 
      popMatrix();
    }
    popMatrix();
  }
}

void mato() {
  double bg_red = moonlander.getValue("background_red");
  int bg_green = moonlander.getIntValue("background_green");
  int bg_blue = moonlander.getIntValue("background_blue");
  background((int)bg_red, bg_blue, bg_green);
  calcWave();
  renderWave();
  
  
}

void calcWave() {
  // Increment theta (try different values for 'angular velocity' here'
  int amp_m = moonlander.getIntValue("Amplitude");
  t += 0.1;

  // For every x value, calculate a y value with sine function
  float x = t;
  for (int i = 0; i < yvalues.length; i++) {
    yvalues[i] = (sin(x))*(amp*amp_m);
    x+=dx;
  }
}

void renderWave() {
  noStroke();
  fill(255);
  int z= moonlander.getIntValue("z");
  // A simple way to draw the wave with an ellipse at each location
  for (int x = 0; x < yvalues.length-height/70; x++) {
    
    ellipse(x*xspa, height/2+yvalues[x], xspa, xspa);
    square(x*xspa, height/2+yvalues[x]+height/7,height/18);
    square(x*xspa, height/2+yvalues[x]-height/6,height/18);
    circle(width/2+width/3, height/2+yvalues[30], height/2);
    rotateZ(z);
  }
  
}


class DNA {
 int x, y, z, xsize, ysize;
 float rotation;


DNA(int x1, int y1, int z1) {
   x = x1;
   y= y1;
   z= z1;
   xsize = 40;
   ysize = 30;
   rotation = PI/30;
 }

 public void update() {
     rotation = rotation + (PI/100);
 }

 public void draw() {
   update();
   noStroke();
   lights();
   fill(100, 10, 100);
   translate(x, y, z);
   rotateY(rotation);
   for (int i=1; i<30; i++) {
     translate(-xsize/2, 0, 0);
     box(5, 8, 8);
     translate(xsize/2, 0, 0);
     box(xsize, 3, 10);
     translate(xsize/2, 0, 0);
     box(5, 8, 8);
     translate(-xsize/2, 0, 0);
     translate(0, 10, 0);
     rotateY(PI/11);
   }  
 }
}

class Cube {
  // Box size
  int cubeSize;
  // HSB and Alpha
  float fillHue;
  float fillSat;
  float fillBri;
  float fillA;
  float cubeScale;
  
  void show() {
    fill(fillHue,fillSat,fillBri,fillA); // Cube HSB
    box(cubeSize);
  }
}


int[] getGrid(int gridSize, int x, int y) {
  // The top left item is placed at x,y
  int locationX = x;
  int locationY = y;
  // Declare the array which will hold all positions (first x then y)
  int[] gridArray;
  gridArray = new int[16*2];
  // Loop through grid and make placements
  int i = 0;
  for (int row = 0; row < 4; row++) {
    locationY = x + row*gridSize/4;
    for (int col = 0; col < 4; col++) {
      gridArray[i] = locationX;
      gridArray[i+16] = locationY;
      locationX = x + col*gridSize/4;
      i = i + 1;
    }
  }
  return gridArray;
}



void drawCubeGrid(float cameraZ, int[] grid, int cubeSizeInGrid, float gridZoom, float gridBri,
float gridRotate, float gridDispX) {
    for (int i = 0; i < cubes.length; i++) {
    cubes[i].fillHue = 190;
    cubes[i].fillSat = 100;
    cubes[i].fillBri = gridBri;
    cubes[i].fillA = 100;
    cubes[i].cubeScale = 1.0; // Currently not used
    cubes[i].cubeSize = cubeSizeInGrid;
    pushMatrix();
    translate((int)gridDispX + grid[i], grid[i+16], gridZoom);
    rotateZ(gridRotate);
    cubes[i].show();
    popMatrix();
  }
}
