import moonlander.library.*;

// Minim must be imported when using Moonlander with soundtrack.
import ddf.minim.*;

Moonlander moonlander;

// All these you can (must) change!
// These control how big the opened window is.
// Before you release your demo, set 960x540 these to 
// full HD resolution (1920x1080).
final int CANVAS_WIDTH = 1920;
final int CANVAS_HEIGHT = 1080;

int heightQuarter = CANVAS_HEIGHT/4;
int widthQuarter = CANVAS_WIDTH/4;

// Don't change this – needed for resolution independent rendering
// Aspect Ratio: 480/360 = 1.33333
float ASPECT_RATIO = (float)CANVAS_WIDTH/CANVAS_HEIGHT;

// An array of news headlines
String[] headlines = {
  "Kekkilae.", 
  "Graffathon 2019, Espoo - Kekkilae by mss_fly", 
  };
  
PFont f;
float xHeadline;  // horizontal location of headline
int index = 0;

float aScale = 0.0;
float sScale = 0.0;

float a2Scale = 0.0;
float s2Scale = 0.0;

Spot[] spots; // Declare array

void settings() {
  fullScreen();
  size(CANVAS_WIDTH, CANVAS_HEIGHT, P2D);
}

void setup() {
  //fullScreen();
  // Drawing options that don't change, modify as you wish
  frameRate(60);
  noStroke();
  //rectMode(CENTER);
  //fill(255);
  //smooth();
  //background(0);
  noCursor();
  
  
  f = createFont("Arial",256,true);
  
  // Initialize headline offscreen to the right 
  xHeadline = CANVAS_WIDTH;
  
  int numSpots = 70; // Number of objects
  int dia = width/numSpots ; // Calculate diameter
  spots = new Spot[numSpots]; // Create array
  for (int i = 0; i < spots.length; i++) {
    float x = dia/2 + i*dia;
    float rate = random(0.1, 2.0);
    // Create each object
    spots[i] = new Spot(x, 50, dia, rate);
  }
  
  moonlander = Moonlander.initWithSoundtrack(this, "../music/chase_pulse_faster.mp3", 88, 8);
  moonlander.start();
}

void chicken(int x, int y) {
  x=x-50;
  y=y-50;
  
  pushMatrix();
  translate(x, y);
  //resetMatrix();
  
  //scale(2.0);
  
    //red
    fill(187,51,17);
    
    rect(30, 0, 20, 10);
    rect(10, 30, 10, 20);
    
    //yellow
    fill(238,187,68);
    
    rect(0, 20, 20, 10);
    rect(40, 80, 10, 20);
    rect(70, 80, 10, 20);
    
    //white
    fill(255);
    
    rect(20, 10, 40, 10);
    rect(20, 20, 10, 10);
    rect(40, 20, 20, 10);
    rect(20, 30, 40, 30);
    rect(90, 40, 10, 10);
    rect(60, 50, 40, 10);
    rect(20, 60, 20, 10);
    rect(80, 60, 20, 10);
    rect(20, 70, 70, 10);
    popMatrix();
}

void scrollingText(){
  //println("Canvas width: " + xHeadline);
  
  // Display headline at x  location
  textFont(f,128);
  fill(242, 68, 68);
  textAlign(CENTER);
  
  //tekstin haku kannasta ja sijainti
  text(headlines[index],xHeadline,-heightQuarter);
  
  // Decrement x
  xHeadline = xHeadline - 5;
  
  // If x is less than the negative width, 
  // then it is off the screen
  float w = textWidth(headlines[index]);
  //w = w*3;
  
  println("Text: " + w);
  println("Width left: " + xHeadline);
  
  if (xHeadline < -w) {
    xHeadline = CANVAS_WIDTH; 
    index = (index + 1) % headlines.length;
  }
}


void draw() {
  //println(millis());
  
  moonlander.update();
    
  resetMatrix();
  
  translate(CANVAS_WIDTH/2.0, CANVAS_HEIGHT/2.0);
 // scale(CANVAS_WIDTH/2.0/ASPECT_RATIO, -CANVAS_HEIGHT/2.0);
  
  clear();
  
  double bg_red = moonlander.getValue("background_red");
  int bg_green = moonlander.getIntValue("background_green");
  int bg_blue = moonlander.getIntValue("background_blue");
  background((int)bg_red, bg_green, bg_blue);
  
  fill(74, 44, 24);
  for (int i=0; i < spots.length; i++) {
    spots[i].move(); // Move each object
    spots[i].display(); // Display each object
  }

  scrollingText();

  double scaleChick = moonlander.getValue("scale_chick");
  //scale((int)scaleChick);
  
  aScale = aScale + 0.04;
  sScale = cos(aScale)*3;
  
  a2Scale = a2Scale + 0.01;
  s2Scale = cos(a2Scale)*4;
  
  translate(0, 0);
  scale(sScale);
  rotate(radians(frameCount * 1  % 360));
  chicken(0, 0); 
 
  scale(s2Scale);
  rotate(radians(frameCount * -1  % 360));
  chicken(-100, 200);
  chicken(100, -200);
  
  translate(CANVAS_WIDTH/9, (int)scaleChick);
  scale(sScale);
  chicken(-10, 0); 
  
  translate(CANVAS_WIDTH/6, (int)scaleChick);
  scale(s2Scale);
  chicken(-10, 0); 
    
  if(xHeadline == -2500.0){
    exit();
  }
  
}

class Spot {
  float x, y;         // X-coordinate, y-coordinate
  float diameter;     // Diameter of the circle
  float speed;        // Distance moved each frame
  int direction = 1;  // Direction of motion (1 is down, -1 is up)
  
  // Constructor
  Spot(float xpos, float ypos, float dia, float sp) {
    x = xpos - width/2;
    y = ypos;
    diameter = dia;
    speed = sp;
  }
    
  void move() {
    y += (speed * direction); 
    if ((y > (height - diameter/2)) || (y < diameter/2)) { 
      direction *= -1; 
    } 
  }
  
  void display() {
    ellipse(x, y, diameter, diameter);
  }
}
