final int W = 1920, H = 1080;
//final int W = 800, H = 450;

import moonlander.library.*;

import ddf.minim.*;
import ddf.minim.analysis.*;

Moonlander moonlander;
Minim minim;
AudioPlayer song;
FFT fft;
PFont fatFont;
PShape fish;
PShape deadFish;  // adapted from icon CC-BY Gemma Evans
PShape seaSlice;
PImage tin;

color seaColorDark = color(0, 75, 168);
color seaColorLight = color(24, 143, 167);
color talkColor = color(221, 115, 115);
color fishColor1 = color(255, 178, 56);
color fishColor2 = color(200, 200, 0);

color pulseColor1 = color(0, 50, 100);
color pulseColor2 = color(0, 103, 255);

ParticleSystem paskapilvi;
PImage paske; 

PVector v(float x, float y) {
  return new PVector(x, y);
}

void settings() {
  size(W, H, P3D);
}

void setup() {
  frameRate(20);
  noStroke();
  
  resetTree();
  
  minim = new Minim(this);
  song = minim.loadFile("paskamusa.wav", 1024);
  fish = loadShape("fish.svg");
  fish.disableStyle();  // remove "original" color, enable using fill()
  deadFish = loadShape("dead_fish.svg");
  deadFish.disableStyle();
  seaSlice = loadShape("waves.svg");
  seaSlice.disableStyle();
  tin = loadImage("purkki.png");
  paske = loadImage("paske.png");
  paskapilvi = new ParticleSystem(500, paske);  
  narratorFont = createFont("FreeMonoBold.ttf", 30);
  fatFont = createFont("whoopass.ttf", 50);
  fft = new FFT(song.bufferSize(), song.sampleRate());  
  MinimController controller = new MinimController(song, 140, 4);
  moonlander = new Moonlander(this, controller);
  moonlander.start();
}

void draw() {
  moonlander.update(); 
  float t = (float)moonlander.getCurrentTime(); 
  //if (t > 100.0f) { exit(); }
  
  fft.forward(song.mix);
  float base = (fft.getBand(0) + fft.getBand(1) + fft.getBand(2)) / 5.0f;
  float bump = (float)moonlander.getValue("bump");

  background(seaColorLight);
  
  pushMatrix();
  scale(height / 1000.0);
  int act = moonlander.getIntValue("act"); 
  if (act == 0) {
    // ACT 0: DYING TREE
    
    float x = (float)moonlander.getValue("cameraX");
    float y = (float)moonlander.getValue("cameraY");
    float z = (float)moonlander.getValue("cameraZoom");
    translate(width/2, height/2+z, y);
    rotateX(PI * -0.5);
    rotateY(PI);
    rotateZ(x);
    float delta = (float) moonlander.getValue("delta");
    int cut = moonlander.getIntValue("cut");
    int death = moonlander.getIntValue("death");
    tree.update(delta, death, cut);

    // island
    if (death >= 0) {
      fill(color(255, 204, 0));
      noStroke();
      pushMatrix();
      translate(0, 0, -1950);
      sphere(2000);
      popMatrix();
    }
    
    // sea
    float d = (float)moonlander.getValue("death") + (float)moonlander.getValue("cut");    
    fill(0,0,255,200); // semi-transparent
    translate(0, 0, -4950-d*10);
    box(10000);
  } else {
    // ACT 1: TALKING FISH
    
    float x = (float)moonlander.getValue("cameraX");
    float y = (float)moonlander.getValue("cameraY");
    float zoom = (float)moonlander.getValue("cameraZoom");
    translate(x, y);
    scale(zoom);
  
    // draw background
    setPulseColor(0);
    float waveHeight = 10.f;
    float wavePhase = t * 3.1f;
    shape(seaSlice, 0, -400 + sin(wavePhase + 1.0) * waveHeight, 200, 1000);
    shape(seaSlice, -200, -400 + sin(wavePhase + 2.0) * waveHeight, 200, 1000);
    shape(seaSlice, -400, -400 + sin(wavePhase + 3.0) * waveHeight, 200, 1000);
    shape(seaSlice, 200, -400 + sin(wavePhase + 4.0) * waveHeight, 200, 1000);
    shape(seaSlice, 400, -400 + sin(wavePhase + 5.0) * waveHeight, 200, 1000);
    
    // draw tin
    float tinY = (float)moonlander.getValue("tinY");
    float tinX = 70 + 30 * getTravelingRandom(3);
    image(tin, tinX, tinY, 80, 80);
    
    // draw two fish
    int death = moonlander.getIntValue("deadFishCount");
    float pulseTail = 15.0f / zoom;
    drawFish(v(0, 0), 100 + base*bump, 0, pulseTail, false, fishColor2, death > 6);
    float angle = getTravelingRandom(0);
    drawFish(v(200, -100), 100, angle, pulseTail, true, fishColor1, death > 0);
    
    drawDialogue();
    
    // ACT 2: OPEN TIN
    if (act >= 2) {
      drawFish(v(-250, -140), 100, getTravelingRandom(1), pulseTail, true, fishColor1, death > 4);
      drawFish(v(-200, 60), 100, getTravelingRandom(2), pulseTail, false, fishColor1, death > 3);
      drawFish(v(370, -170), 100, getTravelingRandom(3), pulseTail, true, fishColor1, death > 1);
      drawFish(v(500, -40), 100, getTravelingRandom(2), pulseTail, false, fishColor1, death > 5);
      drawFish(v(310, 20), 100, getTravelingRandom(1), pulseTail, true, fishColor1, death > 2);
      
      paskapilvi.setEmitter(tinX, tinY);
      paskapilvi.update();
      paskapilvi.display();
      
      float creditsX = (float)moonlander.getValue("creditsX");
      float creditsY = sin(t) * 100;
      fill(0, 200, 0);
      textFont(narratorFont);
      textSize(30);
      text(credits, creditsX, creditsY);
    }    
  }
  
  popMatrix();
  
  drawNarration();
}

float[] val = { 0.f, 0.f, 0.f, 0.f, 0.f, 0.f };
float[] v = { 0.f, 0.f, 0.f, 0.f, 0.f, 0.f };
float getTravelingRandom(int i) {
  float a = -0.1 * val[i] + random(-1, 1);
  v[i] = 0.9 * (v[i] + 0.1 * a);
  val[i] += 0.1 * v[i];
  return val[i];
}