/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.glsl;

import com.jogamp.common.net.Uri;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.glsl.ShaderUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Iterator;
import jogamp.opengl.Debug;

public class ShaderCode {
    public static final boolean DEBUG_CODE = Debug.isPropertyDefined("jogl.debug.GLSLCode", true);
    public static final String SUFFIX_VERTEX_SOURCE = "vp";
    public static final String SUFFIX_VERTEX_BINARY = "bvp";
    public static final String SUFFIX_GEOMETRY_SOURCE = "gp";
    public static final String SUFFIX_GEOMETRY_BINARY = "bgp";
    public static final String SUFFIX_COMPUTE_SOURCE = "cp";
    public static final String SUFFIX_COMPUTE_BINARY = "bcp";
    public static final String SUFFIX_TESS_CONTROL_SOURCE = "tcp";
    public static final String SUFFIX_TESS_CONTROL_BINARY = "btcp";
    public static final String SUFFIX_TESS_EVALUATION_SOURCE = "tep";
    public static final String SUFFIX_TESS_EVALUATION_BINARY = "btep";
    public static final String SUFFIX_FRAGMENT_SOURCE = "fp";
    public static final String SUFFIX_FRAGMENT_BINARY = "bfp";
    public static final String SUB_PATH_NVIDIA = "nvidia";
    public static final String es2_default_precision_vp = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
    public static final String es2_default_precision_fp = "\nprecision mediump float;\nprecision mediump int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
    public static final String es3_default_precision_vp = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
    public static final String es3_default_precision_fp = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
    public static final String gl3_default_precision_vp_gp = "\nprecision highp float;\nprecision highp int;\n";
    public static final String gl3_default_precision_fp = "\nprecision highp float;\nprecision mediump int;\n/*precision mediump sampler2D;*/\n";
    public static final String REQUIRE = "require";
    public static final String ENABLE = "enable";
    public static final String DISABLE = "disable";
    public static final String WARN = "warn";
    protected CharSequence[][] shaderSource = null;
    protected Buffer shaderBinary = null;
    protected int shaderBinaryFormat = -1;
    protected IntBuffer shader = null;
    protected int shaderType = -1;
    protected int id = -1;
    protected boolean valid = false;
    protected static int nextID = 1;

    public ShaderCode(int n, int n2, CharSequence[][] charSequenceArray) {
        if (charSequenceArray.length != n2) {
            throw new IllegalArgumentException("shader number (" + n2 + ") and sourceFiles array (" + charSequenceArray.length + ") of different lenght.");
        }
        switch (n) {
            case 35632: 
            case 35633: 
            case 36313: 
            case 36487: 
            case 36488: 
            case 37305: {
                break;
            }
            default: {
                throw new GLException("Unknown shader type: " + n);
            }
        }
        this.shaderSource = charSequenceArray;
        this.shaderBinaryFormat = -1;
        this.shaderBinary = null;
        this.shaderType = n;
        this.shader = Buffers.newDirectIntBuffer(n2);
        this.id = ShaderCode.getNextID();
        if (DEBUG_CODE) {
            System.out.println("Created: " + this.toString());
        }
    }

    public ShaderCode(int n, int n2, int n3, Buffer buffer) {
        switch (n) {
            case 35632: 
            case 35633: 
            case 36313: 
            case 36487: 
            case 36488: 
            case 37305: {
                break;
            }
            default: {
                throw new GLException("Unknown shader type: " + n);
            }
        }
        this.shaderSource = null;
        this.shaderBinaryFormat = n3;
        this.shaderBinary = buffer;
        this.shaderType = n;
        this.shader = Buffers.newDirectIntBuffer(n2);
        this.id = ShaderCode.getNextID();
    }

    public static ShaderCode create(GL2ES2 gL2ES2, int n, int n2, Class<?> clazz, String[] stringArray, boolean bl) {
        if (null != gL2ES2 && !ShaderUtil.isShaderCompilerAvailable(gL2ES2)) {
            return null;
        }
        CharSequence[][] charSequenceArray = null;
        if (null != stringArray) {
            charSequenceArray = new CharSequence[stringArray.length][1];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    charSequenceArray[i][0] = ShaderCode.readShaderSource(clazz, stringArray[i], bl);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("readShaderSource(" + stringArray[i] + ") error: ", iOException);
                }
                if (null != charSequenceArray[i][0]) continue;
                charSequenceArray = null;
            }
        }
        if (null == charSequenceArray) {
            return null;
        }
        return new ShaderCode(n, n2, charSequenceArray);
    }

    public static ShaderCode create(GL2ES2 gL2ES2, int n, int n2, Uri[] uriArray, boolean bl) {
        if (null != gL2ES2 && !ShaderUtil.isShaderCompilerAvailable(gL2ES2)) {
            return null;
        }
        CharSequence[][] charSequenceArray = null;
        if (null != uriArray) {
            charSequenceArray = new CharSequence[uriArray.length][1];
            for (int i = 0; i < uriArray.length; ++i) {
                try {
                    charSequenceArray[i][0] = ShaderCode.readShaderSource(uriArray[i], bl);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("readShaderSource(" + uriArray[i] + ") error: ", iOException);
                }
                if (null != charSequenceArray[i][0]) continue;
                charSequenceArray = null;
            }
        }
        if (null == charSequenceArray) {
            return null;
        }
        return new ShaderCode(n, n2, charSequenceArray);
    }

    public static ShaderCode create(int n, int n2, Class<?> clazz, int n3, String string) {
        ByteBuffer byteBuffer = null;
        if (null != string && 0 <= n3) {
            try {
                byteBuffer = ShaderCode.readShaderBinary(clazz, string);
            }
            catch (IOException iOException) {
                throw new RuntimeException("readShaderBinary(" + string + ") error: ", iOException);
            }
            if (null == byteBuffer) {
                n3 = -1;
            }
        }
        if (null == byteBuffer) {
            return null;
        }
        return new ShaderCode(n, n2, n3, byteBuffer);
    }

    public static ShaderCode create(int n, int n2, int n3, Uri uri) {
        ByteBuffer byteBuffer = null;
        if (null != uri && 0 <= n3) {
            try {
                byteBuffer = ShaderCode.readShaderBinary(uri);
            }
            catch (IOException iOException) {
                throw new RuntimeException("readShaderBinary(" + uri + ") error: ", iOException);
            }
            if (null == byteBuffer) {
                n3 = -1;
            }
        }
        if (null == byteBuffer) {
            return null;
        }
        return new ShaderCode(n, n2, n3, byteBuffer);
    }

    public static String getFileSuffix(boolean bl, int n) {
        switch (n) {
            case 35633: {
                return bl ? SUFFIX_VERTEX_BINARY : SUFFIX_VERTEX_SOURCE;
            }
            case 35632: {
                return bl ? SUFFIX_FRAGMENT_BINARY : SUFFIX_FRAGMENT_SOURCE;
            }
            case 36313: {
                return bl ? SUFFIX_GEOMETRY_BINARY : SUFFIX_GEOMETRY_SOURCE;
            }
            case 36488: {
                return bl ? SUFFIX_TESS_CONTROL_BINARY : SUFFIX_TESS_CONTROL_SOURCE;
            }
            case 36487: {
                return bl ? SUFFIX_TESS_EVALUATION_BINARY : SUFFIX_TESS_EVALUATION_SOURCE;
            }
            case 37305: {
                return bl ? SUFFIX_COMPUTE_BINARY : SUFFIX_COMPUTE_SOURCE;
            }
        }
        throw new GLException("illegal shader type: " + n);
    }

    public static String getBinarySubPath(int n) {
        switch (n) {
            case 35083: {
                return SUB_PATH_NVIDIA;
            }
        }
        throw new GLException("unsupported binary format: " + n);
    }

    public static ShaderCode create(GL2ES2 gL2ES2, int n, int n2, Class<?> clazz, String string, String[] stringArray, String string2, String string3, String string4, String string5, boolean bl) {
        Object object;
        Object[] objectArray;
        ShaderCode shaderCode = null;
        String string6 = null;
        String string7 = null;
        if (null != stringArray && ShaderUtil.isShaderCompilerAvailable(gL2ES2)) {
            int n3;
            objectArray = new String[stringArray.length];
            Object object2 = object = null != string2 ? string2 : ShaderCode.getFileSuffix(false, n);
            if (null != string && string.length() > 0) {
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    objectArray[n3] = string + '/' + stringArray[n3] + "." + (String)object;
                }
            } else {
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    objectArray[n3] = stringArray[n3] + "." + (String)object;
                }
            }
            if (null != (shaderCode = ShaderCode.create(gL2ES2, n, n2, clazz, (String[])objectArray, bl))) {
                return shaderCode;
            }
            string6 = Arrays.toString(objectArray);
        } else {
            objectArray = null;
        }
        if (null != string4) {
            object = ShaderUtil.getShaderBinaryFormats(gL2ES2);
            String string8 = null != string5 ? string5 : ShaderCode.getFileSuffix(true, n);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                int n4 = (Integer)iterator2.next();
                String string9 = ShaderCode.getBinarySubPath(n4);
                if (null == string9 || null == (shaderCode = ShaderCode.create(n, n2, clazz, n4, string7 = string3 + '/' + string9 + '/' + string4 + "." + string8))) continue;
                return shaderCode;
            }
        }
        throw new GLException("No shader code found (source nor binary) for src: " + string6 + ", bin: " + string7);
    }

    public static ShaderCode create(GL2ES2 gL2ES2, int n, int n2, Class<?> clazz, String string, String[] stringArray, String string2, String string3, boolean bl) {
        return ShaderCode.create(gL2ES2, n, n2, clazz, string, stringArray, null, string2, string3, null, bl);
    }

    public static ShaderCode create(GL2ES2 gL2ES2, int n, Class<?> clazz, String string, String string2, String string3, String string4, String string5, boolean bl) {
        return ShaderCode.create(gL2ES2, n, 1, clazz, string, new String[]{string3}, string4, string2, string3, string5, bl);
    }

    public static ShaderCode create(GL2ES2 gL2ES2, int n, Class<?> clazz, String string, String string2, String string3, boolean bl) {
        return ShaderCode.create(gL2ES2, n, clazz, string, string2, string3, null, null, bl);
    }

    public int id() {
        return this.id;
    }

    public int shaderType() {
        return this.shaderType;
    }

    public String shaderTypeStr() {
        return ShaderCode.shaderTypeStr(this.shaderType);
    }

    public static String shaderTypeStr(int n) {
        switch (n) {
            case 35633: {
                return "VERTEX_SHADER";
            }
            case 35632: {
                return "FRAGMENT_SHADER";
            }
            case 36313: {
                return "GEOMETRY_SHADER";
            }
            case 36488: {
                return "TESS_CONTROL_SHADER";
            }
            case 36487: {
                return "TESS_EVALUATION_SHADER";
            }
            case 37305: {
                return "COMPUTE_SHADER";
            }
        }
        return "UNKNOWN_SHADER";
    }

    public int shaderBinaryFormat() {
        return this.shaderBinaryFormat;
    }

    public Buffer shaderBinary() {
        return this.shaderBinary;
    }

    public CharSequence[][] shaderSource() {
        return this.shaderSource;
    }

    public boolean isValid() {
        return this.valid;
    }

    public IntBuffer shader() {
        return this.shader;
    }

    public boolean compile(GL2ES2 gL2ES2) {
        return this.compile(gL2ES2, null);
    }

    public boolean compile(GL2ES2 gL2ES2, PrintStream printStream) {
        if (this.isValid()) {
            return true;
        }
        if (null != this.shaderSource) {
            if (DEBUG_CODE) {
                System.err.println("ShaderCode.compile:");
                this.dumpShaderSource(System.err);
            }
            this.valid = ShaderUtil.createAndCompileShader(gL2ES2, this.shader, this.shaderType, this.shaderSource, printStream);
        } else if (null != this.shaderBinary) {
            this.valid = ShaderUtil.createAndLoadShader(gL2ES2, this.shader, this.shaderType, this.shaderBinaryFormat, this.shaderBinary, printStream);
        } else {
            throw new GLException("no code (source or binary)");
        }
        return this.valid;
    }

    public void destroy(GL2ES2 gL2ES2) {
        if (this.isValid()) {
            if (null != gL2ES2) {
                ShaderUtil.deleteShader(gL2ES2, this.shader());
            }
            this.valid = false;
        }
        if (null != this.shaderBinary) {
            this.shaderBinary.clear();
            this.shaderBinary = null;
        }
        this.shaderSource = null;
        this.shaderBinaryFormat = -1;
        this.shaderType = -1;
        this.id = -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ShaderCode) {
            return this.id() == ((ShaderCode)object).id();
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ShaderCode[id=" + this.id + ", type=" + this.shaderTypeStr() + ", valid=" + this.valid + ", shader: ");
        for (int i = 0; i < this.shader.remaining(); ++i) {
            stringBuilder.append(" " + this.shader.get(i));
        }
        if (null != this.shaderSource) {
            stringBuilder.append(", source]");
        } else if (null != this.shaderBinary) {
            stringBuilder.append(", binary " + this.shaderBinary + "]");
        }
        return stringBuilder.toString();
    }

    public void dumpShaderSource(PrintStream printStream) {
        if (null == this.shaderSource) {
            printStream.println("<no shader source>");
            return;
        }
        int n = this.shaderSource.length;
        int n2 = null != this.shader ? this.shader.capacity() : 0;
        for (int i = 0; i < n2; ++i) {
            printStream.println("");
            printStream.println("Shader #" + i + "/" + n2 + " name " + this.shader.get(i));
            printStream.println("--------------------------------------------------------------");
            if (i >= n) {
                printStream.println("<no shader source>");
            } else {
                CharSequence[] charSequenceArray = this.shaderSource[i];
                int n3 = 0;
                for (int j = 0; j < charSequenceArray.length; ++j) {
                    printStream.printf("%4d: // Segment %d/%d: \n", n3, j, charSequenceArray.length);
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(charSequenceArray[j].toString()));
                    String string = null;
                    try {
                        while ((string = bufferedReader.readLine()) != null) {
                            printStream.printf("%4d: %s\n", ++n3, string);
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            printStream.println("--------------------------------------------------------------");
        }
    }

    public int insertShaderSource(int n, String string, int n2, CharSequence charSequence) {
        int n3;
        if (null == this.shaderSource) {
            throw new IllegalStateException("no shader source");
        }
        int n4 = n3 = null != this.shader ? this.shader.capacity() : 0;
        if (0 > n || n >= n3) {
            throw new IndexOutOfBoundsException("shaderIdx not within shader bounds [0.." + (n3 - 1) + "]: " + n);
        }
        int n5 = this.shaderSource.length;
        if (n >= n5) {
            throw new IndexOutOfBoundsException("shaderIdx not within source bounds [0.." + (n5 - 1) + "]: " + n);
        }
        CharSequence[] charSequenceArray = this.shaderSource[n];
        int n6 = 0;
        for (int i = 0; i < charSequenceArray.length; ++i) {
            int n7;
            if (!(charSequenceArray[i] instanceof StringBuilder)) {
                throw new IllegalStateException("shader source not a mutable StringBuilder, but CharSequence of type: " + charSequenceArray[i].getClass().getName());
            }
            StringBuilder stringBuilder = (StringBuilder)charSequenceArray[i];
            if (n2 >= (n6 += stringBuilder.length()) || 0 > (n7 = stringBuilder.indexOf(string, n2))) continue;
            int n8 = stringBuilder.indexOf("\n", n7 += string.length());
            if (0 > n8) {
                n8 = stringBuilder.indexOf("\r", n7);
            }
            if (0 < n8) {
                n7 = n8 + 1;
            } else {
                stringBuilder.insert(n7, "\n");
                ++n7;
            }
            stringBuilder.insert(n7, charSequence);
            return n7 + charSequence.length();
        }
        return -1;
    }

    public int replaceInShaderSource(String string, String string2) {
        if (null == this.shaderSource) {
            throw new IllegalStateException("no shader source");
        }
        if (string == string2 || string.equals(string2)) {
            return 0;
        }
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        for (CharSequence[] charSequenceArray : this.shaderSource) {
            for (int i = 0; i < charSequenceArray.length; ++i) {
                if (!(charSequenceArray[i] instanceof StringBuilder)) {
                    throw new IllegalStateException("shader source not a mutable StringBuilder, but CharSequence of type: " + charSequenceArray[i].getClass().getName());
                }
                StringBuilder stringBuilder = (StringBuilder)charSequenceArray[i];
                int n4 = 0;
                while (n4 < stringBuilder.length() - n + 1) {
                    int n5 = stringBuilder.indexOf(string, n4);
                    if (0 <= n5) {
                        int n6 = n5 + n;
                        stringBuilder.replace(n5, n6, string2);
                        n4 = n5 + n2;
                        ++n3;
                        continue;
                    }
                    n4 = stringBuilder.length();
                }
            }
        }
        return n3;
    }

    public int insertShaderSource(int n, int n2, CharSequence charSequence) {
        int n3;
        if (null == this.shaderSource) {
            throw new IllegalStateException("no shader source");
        }
        int n4 = n3 = null != this.shader ? this.shader.capacity() : 0;
        if (0 > n || n >= n3) {
            throw new IndexOutOfBoundsException("shaderIdx not within shader bounds [0.." + (n3 - 1) + "]: " + n);
        }
        int n5 = this.shaderSource.length;
        if (n >= n5) {
            throw new IndexOutOfBoundsException("shaderIdx not within source bounds [0.." + (n5 - 1) + "]: " + n);
        }
        CharSequence[] charSequenceArray = this.shaderSource[n];
        int n6 = 0;
        for (int i = 0; i < charSequenceArray.length; ++i) {
            if (!(charSequenceArray[i] instanceof StringBuilder)) {
                throw new IllegalStateException("shader source not a mutable StringBuilder, but CharSequence of type: " + charSequenceArray[i].getClass().getName());
            }
            StringBuilder stringBuilder = (StringBuilder)charSequenceArray[i];
            n6 += stringBuilder.length();
            if (0 > n2 && i == charSequenceArray.length - 1) {
                n2 = n6;
            }
            if (0 > n2 || n2 > n6) continue;
            stringBuilder.insert(n2, charSequence);
            return n2 + charSequence.length();
        }
        return n2;
    }

    public int insertShaderSource(int n, int n2, Class<?> clazz, String string) throws IOException {
        CharSequence charSequence = ShaderCode.readShaderSource(clazz, string, true);
        if (null != charSequence) {
            return this.insertShaderSource(n, n2, charSequence);
        }
        return n2;
    }

    private static int readShaderSource(Class<?> clazz, URLConnection uRLConnection, StringBuilder stringBuilder, int n) throws IOException {
        if (DEBUG_CODE) {
            if (0 == n) {
                stringBuilder.append("// " + uRLConnection.getURL().toExternalForm() + "\n");
            } else {
                stringBuilder.append("// included @ line " + n + ": " + uRLConnection.getURL().toExternalForm() + "\n");
            }
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                ++n;
                if (string.startsWith("#include ")) {
                    String string2 = string.substring(9).trim();
                    URLConnection uRLConnection2 = null;
                    Uri uri = Uri.valueOf(uRLConnection.getURL()).getRelativeOf(new Uri.Encoded(string2, "/!_-.~"));
                    uRLConnection2 = IOUtil.openURL(uri.toURL(), "ShaderCode.relativeOf ");
                    if (uRLConnection2 == null) {
                        uRLConnection2 = IOUtil.getResource(string2, clazz.getClassLoader(), clazz);
                    }
                    if (uRLConnection2 == null) {
                        throw new FileNotFoundException("Can't find include file " + string2);
                    }
                    n = ShaderCode.readShaderSource(clazz, uRLConnection2, stringBuilder, n);
                    continue;
                }
                stringBuilder.append(string + "\n");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
        finally {
            IOUtil.close(bufferedReader, false);
        }
        return n;
    }

    public static void readShaderSource(Class<?> clazz, URLConnection uRLConnection, StringBuilder stringBuilder) throws IOException {
        ShaderCode.readShaderSource(clazz, uRLConnection, stringBuilder, 0);
    }

    public static CharSequence readShaderSource(Class<?> clazz, String string, boolean bl) throws IOException {
        URLConnection uRLConnection = IOUtil.getResource(string, clazz.getClassLoader(), clazz);
        if (uRLConnection == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ShaderCode.readShaderSource(clazz, uRLConnection, stringBuilder);
        return bl ? stringBuilder : stringBuilder.toString();
    }

    public static CharSequence readShaderSource(Uri uri, boolean bl) throws IOException {
        URLConnection uRLConnection = IOUtil.openURL(uri.toURL(), "ShaderCode ");
        if (uRLConnection == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ShaderCode.readShaderSource(null, uRLConnection, stringBuilder);
        return bl ? stringBuilder : stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readShaderBinary(Class<?> clazz, String string) throws IOException {
        URLConnection uRLConnection = IOUtil.getResource(string, clazz.getClassLoader(), clazz);
        if (uRLConnection == null) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            ByteBuffer byteBuffer = IOUtil.copyStream2ByteBuffer(bufferedInputStream);
            return byteBuffer;
        }
        finally {
            IOUtil.close(bufferedInputStream, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readShaderBinary(Uri uri) throws IOException {
        URLConnection uRLConnection = IOUtil.openURL(uri.toURL(), "ShaderCode ");
        if (uRLConnection == null) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            ByteBuffer byteBuffer = IOUtil.copyStream2ByteBuffer(bufferedInputStream);
            return byteBuffer;
        }
        finally {
            IOUtil.close(bufferedInputStream, false);
        }
    }

    public static String createExtensionDirective(String string, String string2) {
        return "#extension " + string + " : " + string2 + "\n";
    }

    public final int addGLSLVersion(GL2ES2 gL2ES2) {
        return this.insertShaderSource(0, 0, gL2ES2.getContext().getGLSLVersionString());
    }

    public final int addDefaultShaderPrecision(GL2ES2 gL2ES2, int n) {
        String string;
        if (gL2ES2.isGLES3()) {
            switch (this.shaderType) {
                case 35633: {
                    string = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
                    break;
                }
                case 35632: {
                    string = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
                    break;
                }
                case 37305: {
                    string = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
                    break;
                }
                default: {
                    string = null;
                    break;
                }
            }
        } else if (gL2ES2.isGLES2()) {
            switch (this.shaderType) {
                case 35633: {
                    string = "\nprecision highp float;\nprecision highp int;\n/*precision lowp sampler2D;*/\n/*precision lowp samplerCube;*/\n";
                    break;
                }
                case 35632: {
                    string = es2_default_precision_fp;
                    break;
                }
                default: {
                    string = null;
                    break;
                }
            }
        } else if (ShaderCode.requiresGL3DefaultPrecision(gL2ES2)) {
            switch (this.shaderType) {
                case 35633: 
                case 36313: 
                case 36487: 
                case 36488: {
                    string = gl3_default_precision_vp_gp;
                    break;
                }
                case 35632: {
                    string = gl3_default_precision_fp;
                    break;
                }
                case 37305: {
                    string = gl3_default_precision_fp;
                    break;
                }
                default: {
                    string = null;
                    break;
                }
            }
        } else {
            string = null;
        }
        if (null != string) {
            n = this.insertShaderSource(0, n, string);
        }
        return n;
    }

    public static final boolean requiresDefaultPrecision(GL2ES2 gL2ES2) {
        if (gL2ES2.isGLES()) {
            return true;
        }
        return ShaderCode.requiresGL3DefaultPrecision(gL2ES2);
    }

    public static final boolean requiresGL3DefaultPrecision(GL2ES2 gL2ES2) {
        if (gL2ES2.isGL3()) {
            VersionNumber versionNumber = gL2ES2.getContext().getGLSLVersionNumber();
            return versionNumber.compareTo(GLContext.Version1_30) >= 0 && versionNumber.compareTo(GLContext.Version1_50) < 0;
        }
        return false;
    }

    public final int defaultShaderCustomization(GL2ES2 gL2ES2, boolean bl, boolean bl2) {
        int n = bl ? this.addGLSLVersion(gL2ES2) : 0;
        if (bl2) {
            n = this.addDefaultShaderPrecision(gL2ES2, n);
        }
        return n;
    }

    public final int defaultShaderCustomization(GL2ES2 gL2ES2, boolean bl, String string) {
        int n = bl ? this.addGLSLVersion(gL2ES2) : 0;
        n = gL2ES2.isGLES() && null != string ? this.insertShaderSource(0, n, string) : this.addDefaultShaderPrecision(gL2ES2, n);
        return n;
    }

    private static synchronized int getNextID() {
        return nextID++;
    }
}

