/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import com.jogamp.common.util.VersionNumber;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL2GL3;
import com.jogamp.opengl.GL3ES3;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallbackAdapter;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PMatrix3D;
import processing.core.PSurface;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PSurfaceJOGL;

public class PJOGL
extends PGL {
    public static int profile = 2;
    protected static String[] icons = null;
    public static final int AWT = 0;
    public static final int NEWT = 1;
    public GL gl;
    public GLU glu = new GLU();
    public GLContext context;
    protected static int DRAW_TIMEOUT_MILLIS = 500;
    protected GLCapabilitiesImmutable capabilities;
    protected GLDrawable drawable;
    protected GL2ES2 gl2;
    protected GL2GL3 gl3;
    protected GL2 gl2x;
    protected GL3ES3 gl3es3;
    protected Exception drawException;
    protected float[] projMatrix;
    protected float[] mvMatrix;

    static {
        MIN_DIRECT_BUFFER_SIZE = 2;
        INDEX_TYPE = 5123;
        SHAPE_TEXT_SUPPORTED = true;
        SEG_MOVETO = 0;
        SEG_LINETO = 1;
        SEG_QUADTO = 2;
        SEG_CUBICTO = 3;
        SEG_CLOSE = 4;
        FALSE = 0;
        TRUE = 1;
        INT = 5124;
        BYTE = 5120;
        SHORT = 5122;
        FLOAT = 5126;
        BOOL = 35670;
        UNSIGNED_INT = 5125;
        UNSIGNED_BYTE = 5121;
        UNSIGNED_SHORT = 5123;
        RGB = 6407;
        RGBA = 6408;
        ALPHA = 6406;
        LUMINANCE = 6409;
        LUMINANCE_ALPHA = 6410;
        UNSIGNED_SHORT_5_6_5 = 33635;
        UNSIGNED_SHORT_4_4_4_4 = 32819;
        UNSIGNED_SHORT_5_5_5_1 = 32820;
        RGBA4 = 32854;
        RGB5_A1 = 32855;
        RGB565 = 36194;
        RGB8 = 32849;
        RGBA8 = 32856;
        ALPHA8 = 32828;
        READ_ONLY = 35000;
        WRITE_ONLY = 35001;
        READ_WRITE = 35002;
        TESS_WINDING_NONZERO = 100131;
        TESS_WINDING_ODD = 100130;
        TESS_EDGE_FLAG = 100104;
        GENERATE_MIPMAP_HINT = 33170;
        FASTEST = 4353;
        NICEST = 4354;
        DONT_CARE = 4352;
        VENDOR = 7936;
        RENDERER = 7937;
        VERSION = 7938;
        EXTENSIONS = 7939;
        SHADING_LANGUAGE_VERSION = 35724;
        MAX_SAMPLES = 36183;
        SAMPLES = 32937;
        ALIASED_LINE_WIDTH_RANGE = 33902;
        ALIASED_POINT_SIZE_RANGE = 33901;
        DEPTH_BITS = 3414;
        STENCIL_BITS = 3415;
        CCW = 2305;
        CW = 2304;
        VIEWPORT = 2978;
        ARRAY_BUFFER = 34962;
        ELEMENT_ARRAY_BUFFER = 34963;
        PIXEL_PACK_BUFFER = 35051;
        MAX_VERTEX_ATTRIBS = 34921;
        STATIC_DRAW = 35044;
        DYNAMIC_DRAW = 35048;
        STREAM_DRAW = 35040;
        STREAM_READ = 35041;
        BUFFER_SIZE = 34660;
        BUFFER_USAGE = 34661;
        POINTS = 0;
        LINE_STRIP = 3;
        LINE_LOOP = 2;
        LINES = 1;
        TRIANGLE_FAN = 6;
        TRIANGLE_STRIP = 5;
        TRIANGLES = 4;
        CULL_FACE = 2884;
        FRONT = 1028;
        BACK = 1029;
        FRONT_AND_BACK = 1032;
        POLYGON_OFFSET_FILL = 32823;
        UNPACK_ALIGNMENT = 3317;
        PACK_ALIGNMENT = 3333;
        TEXTURE_2D = 3553;
        TEXTURE_RECTANGLE = 34037;
        TEXTURE_BINDING_2D = 32873;
        TEXTURE_BINDING_RECTANGLE = 34038;
        MAX_TEXTURE_SIZE = 3379;
        TEXTURE_MAX_ANISOTROPY = 34046;
        MAX_TEXTURE_MAX_ANISOTROPY = 34047;
        MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
        MAX_TEXTURE_IMAGE_UNITS = 34930;
        MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
        NUM_COMPRESSED_TEXTURE_FORMATS = 34466;
        COMPRESSED_TEXTURE_FORMATS = 34467;
        NEAREST = 9728;
        LINEAR = 9729;
        LINEAR_MIPMAP_NEAREST = 9985;
        LINEAR_MIPMAP_LINEAR = 9987;
        CLAMP_TO_EDGE = 33071;
        REPEAT = 10497;
        TEXTURE0 = 33984;
        TEXTURE1 = 33985;
        TEXTURE2 = 33986;
        TEXTURE3 = 33987;
        TEXTURE_MIN_FILTER = 10241;
        TEXTURE_MAG_FILTER = 10240;
        TEXTURE_WRAP_S = 10242;
        TEXTURE_WRAP_T = 10243;
        TEXTURE_WRAP_R = 32882;
        TEXTURE_CUBE_MAP = 34067;
        TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
        TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
        TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
        TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
        TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
        TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
        VERTEX_SHADER = 35633;
        FRAGMENT_SHADER = 35632;
        INFO_LOG_LENGTH = 35716;
        SHADER_SOURCE_LENGTH = 35720;
        COMPILE_STATUS = 35713;
        LINK_STATUS = 35714;
        VALIDATE_STATUS = 35715;
        SHADER_TYPE = 35663;
        DELETE_STATUS = 35712;
        FLOAT_VEC2 = 35664;
        FLOAT_VEC3 = 35665;
        FLOAT_VEC4 = 35666;
        FLOAT_MAT2 = 35674;
        FLOAT_MAT3 = 35675;
        FLOAT_MAT4 = 35676;
        INT_VEC2 = 35667;
        INT_VEC3 = 35668;
        INT_VEC4 = 35669;
        BOOL_VEC2 = 35671;
        BOOL_VEC3 = 35672;
        BOOL_VEC4 = 35673;
        SAMPLER_2D = 35678;
        SAMPLER_CUBE = 35680;
        LOW_FLOAT = 36336;
        MEDIUM_FLOAT = 36337;
        HIGH_FLOAT = 36338;
        LOW_INT = 36339;
        MEDIUM_INT = 36340;
        HIGH_INT = 36341;
        CURRENT_VERTEX_ATTRIB = 34342;
        VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
        VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
        VERTEX_ATTRIB_ARRAY_SIZE = 34339;
        VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
        VERTEX_ATTRIB_ARRAY_TYPE = 34341;
        VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
        VERTEX_ATTRIB_ARRAY_POINTER = 34373;
        BLEND = 3042;
        ONE = 1;
        ZERO = 0;
        SRC_ALPHA = 770;
        DST_ALPHA = 772;
        ONE_MINUS_SRC_ALPHA = 771;
        ONE_MINUS_DST_COLOR = 775;
        ONE_MINUS_SRC_COLOR = 769;
        DST_COLOR = 774;
        SRC_COLOR = 768;
        SAMPLE_ALPHA_TO_COVERAGE = 32926;
        SAMPLE_COVERAGE = 32928;
        KEEP = 7680;
        REPLACE = 7681;
        INCR = 7682;
        DECR = 7683;
        INVERT = 5386;
        INCR_WRAP = 34055;
        DECR_WRAP = 34056;
        NEVER = 512;
        ALWAYS = 519;
        EQUAL = 514;
        LESS = 513;
        LEQUAL = 515;
        GREATER = 516;
        GEQUAL = 518;
        NOTEQUAL = 517;
        FUNC_ADD = 32774;
        FUNC_MIN = 32775;
        FUNC_MAX = 32776;
        FUNC_REVERSE_SUBTRACT = 32779;
        FUNC_SUBTRACT = 32778;
        DITHER = 3024;
        CONSTANT_COLOR = 32769;
        CONSTANT_ALPHA = 32771;
        ONE_MINUS_CONSTANT_COLOR = 32770;
        ONE_MINUS_CONSTANT_ALPHA = 32772;
        SRC_ALPHA_SATURATE = 776;
        SCISSOR_TEST = 3089;
        STENCIL_TEST = 2960;
        DEPTH_TEST = 2929;
        DEPTH_WRITEMASK = 2930;
        COLOR_BUFFER_BIT = 16384;
        DEPTH_BUFFER_BIT = 256;
        STENCIL_BUFFER_BIT = 1024;
        FRAMEBUFFER = 36160;
        COLOR_ATTACHMENT0 = 36064;
        COLOR_ATTACHMENT1 = 36065;
        COLOR_ATTACHMENT2 = 36066;
        COLOR_ATTACHMENT3 = 36067;
        RENDERBUFFER = 36161;
        DEPTH_ATTACHMENT = 36096;
        STENCIL_ATTACHMENT = 36128;
        READ_FRAMEBUFFER = 36008;
        DRAW_FRAMEBUFFER = 36009;
        RGBA8 = 32856;
        DEPTH24_STENCIL8 = 35056;
        DEPTH_COMPONENT = 6402;
        DEPTH_COMPONENT16 = 33189;
        DEPTH_COMPONENT24 = 33190;
        DEPTH_COMPONENT32 = 33191;
        STENCIL_INDEX = 6401;
        STENCIL_INDEX1 = 36166;
        STENCIL_INDEX4 = 36167;
        STENCIL_INDEX8 = 36168;
        DEPTH_STENCIL = 34041;
        FRAMEBUFFER_COMPLETE = 36053;
        FRAMEBUFFER_UNDEFINED = 33305;
        FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
        FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
        FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
        FRAMEBUFFER_INCOMPLETE_FORMATS = 36058;
        FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
        FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
        FRAMEBUFFER_UNSUPPORTED = 36061;
        FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 36182;
        FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 36264;
        FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
        FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
        FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
        FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
        RENDERBUFFER_WIDTH = 36162;
        RENDERBUFFER_HEIGHT = 36163;
        RENDERBUFFER_RED_SIZE = 36176;
        RENDERBUFFER_GREEN_SIZE = 36177;
        RENDERBUFFER_BLUE_SIZE = 36178;
        RENDERBUFFER_ALPHA_SIZE = 36179;
        RENDERBUFFER_DEPTH_SIZE = 36180;
        RENDERBUFFER_STENCIL_SIZE = 36181;
        RENDERBUFFER_INTERNAL_FORMAT = 36164;
        MULTISAMPLE = 32925;
        LINE_SMOOTH = 2848;
        POLYGON_SMOOTH = 2881;
        SYNC_GPU_COMMANDS_COMPLETE = 37143;
        ALREADY_SIGNALED = 37146;
        CONDITION_SATISFIED = 37148;
    }

    public PJOGL(PGraphicsOpenGL pg) {
        super(pg);
    }

    @Override
    public Object getNative() {
        return this.sketch.getSurface().getNative();
    }

    @Override
    protected void setFrameRate(float fps) {
    }

    @Override
    protected void initSurface(int antialias) {
    }

    @Override
    protected void reinitSurface() {
    }

    @Override
    protected void registerListeners() {
    }

    public static void setIcon(String ... icons) {
        PJOGL.icons = new String[icons.length];
        PApplet.arrayCopy(icons, PJOGL.icons);
    }

    public void setCaps(GLCapabilities caps) {
        this.reqNumSamples = caps.getNumSamples();
        this.capabilities = caps;
    }

    public GLCapabilitiesImmutable getCaps() {
        return this.capabilities;
    }

    public void setFps(float fps) {
        if (!this.setFps || this.targetFps != fps) {
            if (60.0f < fps) {
                this.gl.setSwapInterval(0);
            } else if (30.0f < fps) {
                this.gl.setSwapInterval(1);
            } else {
                this.gl.setSwapInterval(2);
            }
            this.targetFps = this.currentFps = fps;
            this.setFps = true;
        }
    }

    @Override
    protected int getDepthBits() {
        return this.capabilities.getDepthBits();
    }

    @Override
    protected int getStencilBits() {
        return this.capabilities.getStencilBits();
    }

    @Override
    protected float getPixelScale() {
        PSurface surf = this.sketch.getSurface();
        if (surf == null) {
            return this.graphics.pixelDensity;
        }
        if (surf instanceof PSurfaceJOGL) {
            return ((PSurfaceJOGL)surf).getPixelScale();
        }
        throw new RuntimeException("Renderer cannot find a JOGL surface");
    }

    @Override
    protected void getGL(PGL pgl) {
        PJOGL pjogl = (PJOGL)pgl;
        this.drawable = pjogl.drawable;
        this.context = pjogl.context;
        this.glContext = pjogl.glContext;
        this.setThread(pjogl.glThread);
        this.gl = pjogl.gl;
        this.gl2 = pjogl.gl2;
        this.gl2x = pjogl.gl2x;
        this.gl3 = pjogl.gl3;
        this.gl3es3 = pjogl.gl3es3;
    }

    public void getGL(GLAutoDrawable glDrawable) {
        this.context = glDrawable.getContext();
        this.glContext = this.context.hashCode();
        this.setThread(Thread.currentThread());
        this.gl = this.context.getGL();
        this.gl2 = this.gl.getGL2ES2();
        try {
            this.gl2x = this.gl.getGL2();
        }
        catch (GLException gLException) {
            this.gl2x = null;
        }
        try {
            this.gl3 = this.gl.getGL2GL3();
        }
        catch (GLException gLException) {
            this.gl3 = null;
        }
        try {
            this.gl3es3 = this.gl.getGL3ES3();
        }
        catch (GLException gLException) {
            this.gl3es3 = null;
        }
    }

    @Override
    protected boolean canDraw() {
        return true;
    }

    @Override
    protected void requestFocus() {
    }

    @Override
    protected void requestDraw() {
    }

    @Override
    protected void swapBuffers() {
        PSurfaceJOGL surf = (PSurfaceJOGL)this.sketch.getSurface();
        surf.window.swapBuffers();
    }

    @Override
    protected void initFBOLayer() {
        if (this.sketch.frameCount > 0) {
            if (this.isES()) {
                this.initFBOLayerES();
            } else {
                this.initFBOLayerGL();
            }
        }
    }

    private void initFBOLayerES() {
        IntBuffer buf = PJOGL.allocateDirectIntBuffer(this.fboWidth * this.fboHeight);
        if (this.hasReadBuffer()) {
            this.readBuffer(BACK);
        }
        this.readPixelsImpl(0, 0, this.fboWidth, this.fboHeight, RGBA, UNSIGNED_BYTE, buf);
        this.bindTexture(TEXTURE_2D, this.glColorTex.get(this.frontTex));
        this.texSubImage2D(TEXTURE_2D, 0, 0, 0, this.fboWidth, this.fboHeight, RGBA, UNSIGNED_BYTE, buf);
        this.bindTexture(TEXTURE_2D, this.glColorTex.get(this.backTex));
        this.texSubImage2D(TEXTURE_2D, 0, 0, 0, this.fboWidth, this.fboHeight, RGBA, UNSIGNED_BYTE, buf);
        this.bindTexture(TEXTURE_2D, 0);
        this.bindFramebufferImpl(FRAMEBUFFER, 0);
    }

    private void initFBOLayerGL() {
        if (this.pclearColor || this.pgeomCount > 0 || !this.sketch.isLooping()) {
            if (this.hasReadBuffer()) {
                this.readBuffer(FRONT);
            }
        } else {
            this.readBuffer(BACK);
        }
        this.bindFramebufferImpl(DRAW_FRAMEBUFFER, this.glColorFbo.get(0));
        this.framebufferTexture2D(FRAMEBUFFER, COLOR_ATTACHMENT0, TEXTURE_2D, this.glColorTex.get(this.frontTex), 0);
        if (this.hasDrawBuffer()) {
            this.drawBuffer(COLOR_ATTACHMENT0);
        }
        this.blitFramebuffer(0, 0, this.fboWidth, this.fboHeight, 0, 0, this.fboWidth, this.fboHeight, COLOR_BUFFER_BIT, NEAREST);
        this.readBuffer(BACK);
        this.bindFramebufferImpl(DRAW_FRAMEBUFFER, this.glColorFbo.get(0));
        this.framebufferTexture2D(FRAMEBUFFER, COLOR_ATTACHMENT0, TEXTURE_2D, this.glColorTex.get(this.backTex), 0);
        this.drawBuffer(COLOR_ATTACHMENT0);
        this.blitFramebuffer(0, 0, this.fboWidth, this.fboHeight, 0, 0, this.fboWidth, this.fboHeight, COLOR_BUFFER_BIT, NEAREST);
        this.bindFramebufferImpl(FRAMEBUFFER, 0);
    }

    @Override
    protected void beginGL() {
        PMatrix3D proj = this.graphics.projection;
        PMatrix3D mdl = this.graphics.modelview;
        if (this.gl2x != null) {
            if (this.projMatrix == null) {
                this.projMatrix = new float[16];
            }
            this.gl2x.glMatrixMode(5889);
            this.projMatrix[0] = proj.m00;
            this.projMatrix[1] = proj.m10;
            this.projMatrix[2] = proj.m20;
            this.projMatrix[3] = proj.m30;
            this.projMatrix[4] = proj.m01;
            this.projMatrix[5] = proj.m11;
            this.projMatrix[6] = proj.m21;
            this.projMatrix[7] = proj.m31;
            this.projMatrix[8] = proj.m02;
            this.projMatrix[9] = proj.m12;
            this.projMatrix[10] = proj.m22;
            this.projMatrix[11] = proj.m32;
            this.projMatrix[12] = proj.m03;
            this.projMatrix[13] = proj.m13;
            this.projMatrix[14] = proj.m23;
            this.projMatrix[15] = proj.m33;
            this.gl2x.glLoadMatrixf(this.projMatrix, 0);
            if (this.mvMatrix == null) {
                this.mvMatrix = new float[16];
            }
            this.gl2x.glMatrixMode(5888);
            this.mvMatrix[0] = mdl.m00;
            this.mvMatrix[1] = mdl.m10;
            this.mvMatrix[2] = mdl.m20;
            this.mvMatrix[3] = mdl.m30;
            this.mvMatrix[4] = mdl.m01;
            this.mvMatrix[5] = mdl.m11;
            this.mvMatrix[6] = mdl.m21;
            this.mvMatrix[7] = mdl.m31;
            this.mvMatrix[8] = mdl.m02;
            this.mvMatrix[9] = mdl.m12;
            this.mvMatrix[10] = mdl.m22;
            this.mvMatrix[11] = mdl.m32;
            this.mvMatrix[12] = mdl.m03;
            this.mvMatrix[13] = mdl.m13;
            this.mvMatrix[14] = mdl.m23;
            this.mvMatrix[15] = mdl.m33;
            this.gl2x.glLoadMatrixf(this.mvMatrix, 0);
        }
    }

    @Override
    protected boolean hasFBOs() {
        if (this.context.hasBasicFBOSupport()) {
            return true;
        }
        return super.hasFBOs();
    }

    @Override
    protected boolean hasShaders() {
        if (this.context.hasGLSL()) {
            return true;
        }
        return super.hasShaders();
    }

    public void init(GLAutoDrawable glDrawable) {
        this.capabilities = glDrawable.getChosenGLCapabilities();
        if (!this.hasFBOs()) {
            throw new RuntimeException("Framebuffer objects are not supported by this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.");
        }
        if (!this.hasShaders()) {
            throw new RuntimeException("GLSL shaders are not supported by this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.");
        }
    }

    @Override
    protected void enableTexturing(int target) {
        if (target == TEXTURE_2D) {
            this.texturingTargets[0] = true;
        } else if (target == TEXTURE_RECTANGLE) {
            this.texturingTargets[1] = true;
        }
    }

    @Override
    protected void disableTexturing(int target) {
        if (target == TEXTURE_2D) {
            this.texturingTargets[0] = false;
        } else if (target == TEXTURE_RECTANGLE) {
            this.texturingTargets[1] = false;
        }
    }

    private FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    private FontRenderContext getFontRenderContext(Font font) {
        return this.getFontMetrics(font).getFontRenderContext();
    }

    @Override
    protected int getFontAscent(Object font) {
        return this.getFontMetrics((Font)font).getAscent();
    }

    @Override
    protected int getFontDescent(Object font) {
        return this.getFontMetrics((Font)font).getDescent();
    }

    @Override
    protected int getTextWidth(Object font, char[] buffer, int start, int stop) {
        int length = stop - start;
        FontMetrics metrics = this.getFontMetrics((Font)font);
        return metrics.charsWidth(buffer, start, length);
    }

    @Override
    protected Object getDerivedFont(Object font, float size) {
        return ((Font)font).deriveFont(size);
    }

    @Override
    protected int getGLSLVersion() {
        VersionNumber vn = this.context.getGLSLVersionNumber();
        return vn.getMajor() * 100 + vn.getMinor();
    }

    @Override
    protected String[] loadVertexShader(String filename) {
        return this.loadVertexShader(filename, this.getGLSLVersion());
    }

    @Override
    protected String[] loadFragmentShader(String filename) {
        return this.loadFragmentShader(filename, this.getGLSLVersion());
    }

    @Override
    protected String[] loadVertexShader(URL url) {
        return this.loadVertexShader(url, this.getGLSLVersion());
    }

    @Override
    protected String[] loadFragmentShader(URL url) {
        return this.loadFragmentShader(url, this.getGLSLVersion());
    }

    @Override
    protected String[] loadFragmentShader(String filename, int version) {
        String[] fragSrc0 = this.sketch.loadStrings(filename);
        return PJOGL.preprocessFragmentSource(fragSrc0, version);
    }

    @Override
    protected String[] loadVertexShader(String filename, int version) {
        String[] vertSrc0 = this.sketch.loadStrings(filename);
        return PJOGL.preprocessVertexSource(vertSrc0, version);
    }

    @Override
    protected String[] loadFragmentShader(URL url, int version) {
        try {
            String[] fragSrc0 = PApplet.loadStrings(url.openStream());
            return PJOGL.preprocessFragmentSource(fragSrc0, version);
        }
        catch (IOException iOException) {
            PGraphics.showException("Cannot load fragment shader " + url.getFile());
            return null;
        }
    }

    @Override
    protected String[] loadVertexShader(URL url, int version) {
        try {
            String[] vertSrc0 = PApplet.loadStrings(url.openStream());
            return PJOGL.preprocessVertexSource(vertSrc0, version);
        }
        catch (IOException iOException) {
            PGraphics.showException("Cannot load vertex shader " + url.getFile());
            return null;
        }
    }

    @Override
    protected Tessellator createTessellator(PGL.TessellatorCallback callback) {
        return new Tessellator(callback);
    }

    @Override
    protected String tessError(int err) {
        return this.glu.gluErrorString(err);
    }

    @Override
    protected FontOutline createFontOutline(char ch, Object font) {
        return new FontOutline(ch, (Font)font);
    }

    @Override
    public void flush() {
        this.gl.glFlush();
    }

    @Override
    public void finish() {
        this.gl.glFinish();
    }

    @Override
    public void hint(int target, int hint) {
        this.gl.glHint(target, hint);
    }

    @Override
    public void enable(int value) {
        if (-1 < value) {
            this.gl.glEnable(value);
        }
    }

    @Override
    public void disable(int value) {
        if (-1 < value) {
            this.gl.glDisable(value);
        }
    }

    @Override
    public void getBooleanv(int value, IntBuffer data) {
        if (-1 < value) {
            if (this.byteBuffer.capacity() < data.capacity()) {
                this.byteBuffer = PJOGL.allocateDirectByteBuffer(data.capacity());
            }
            this.gl.glGetBooleanv(value, this.byteBuffer);
            int i = 0;
            while (i < data.capacity()) {
                data.put(i, this.byteBuffer.get(i));
                ++i;
            }
        } else {
            PJOGL.fillIntBuffer(data, 0, data.capacity() - 1, 0);
        }
    }

    @Override
    public void getIntegerv(int value, IntBuffer data) {
        if (-1 < value) {
            this.gl.glGetIntegerv(value, data);
        } else {
            PJOGL.fillIntBuffer(data, 0, data.capacity() - 1, 0);
        }
    }

    @Override
    public void getFloatv(int value, FloatBuffer data) {
        if (-1 < value) {
            this.gl.glGetFloatv(value, data);
        } else {
            PJOGL.fillFloatBuffer(data, 0, data.capacity() - 1, 0.0f);
        }
    }

    @Override
    public boolean isEnabled(int value) {
        return this.gl.glIsEnabled(value);
    }

    @Override
    public String getString(int name) {
        return this.gl.glGetString(name);
    }

    @Override
    public int getError() {
        return this.gl.glGetError();
    }

    @Override
    public String errorString(int err) {
        return this.glu.gluErrorString(err);
    }

    @Override
    public void genBuffers(int n, IntBuffer buffers) {
        this.gl.glGenBuffers(n, buffers);
    }

    @Override
    public void deleteBuffers(int n, IntBuffer buffers) {
        this.gl.glDeleteBuffers(n, buffers);
    }

    @Override
    public void bindBuffer(int target, int buffer) {
        this.gl.glBindBuffer(target, buffer);
    }

    @Override
    public void bufferData(int target, int size, Buffer data, int usage) {
        this.gl.glBufferData(target, size, data, usage);
    }

    @Override
    public void bufferSubData(int target, int offset, int size, Buffer data) {
        this.gl.glBufferSubData(target, offset, size, data);
    }

    @Override
    public void isBuffer(int buffer) {
        this.gl.glIsBuffer(buffer);
    }

    @Override
    public void getBufferParameteriv(int target, int value, IntBuffer data) {
        this.gl.glGetBufferParameteriv(target, value, data);
    }

    @Override
    public ByteBuffer mapBuffer(int target, int access) {
        return this.gl2.glMapBuffer(target, access);
    }

    @Override
    public ByteBuffer mapBufferRange(int target, int offset, int length, int access) {
        if (this.gl2x != null) {
            return this.gl2x.glMapBufferRange(target, offset, length, access);
        }
        if (this.gl3 != null) {
            return this.gl3.glMapBufferRange(target, offset, length, access);
        }
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glMapBufferRange()"));
    }

    @Override
    public void unmapBuffer(int target) {
        this.gl2.glUnmapBuffer(target);
    }

    @Override
    public long fenceSync(int condition, int flags) {
        if (this.gl3es3 != null) {
            return this.gl3es3.glFenceSync(condition, flags);
        }
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "fenceSync()"));
    }

    @Override
    public void deleteSync(long sync) {
        if (this.gl3es3 == null) {
            throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "deleteSync()"));
        }
        this.gl3es3.glDeleteSync(sync);
    }

    @Override
    public int clientWaitSync(long sync, int flags, long timeout) {
        if (this.gl3es3 != null) {
            return this.gl3es3.glClientWaitSync(sync, flags, timeout);
        }
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "clientWaitSync()"));
    }

    @Override
    public void depthRangef(float n, float f) {
        this.gl.glDepthRangef(n, f);
    }

    @Override
    public void viewport(int x, int y, int w, int h) {
        float scale = this.getPixelScale();
        this.viewportImpl((int)scale * x, (int)(scale * (float)y), (int)(scale * (float)w), (int)(scale * (float)h));
    }

    @Override
    protected void viewportImpl(int x, int y, int w, int h) {
        this.gl.glViewport(x, y, w, h);
    }

    @Override
    protected void readPixelsImpl(int x, int y, int width, int height, int format, int type, Buffer buffer) {
        this.gl.glReadPixels(x, y, width, height, format, type, buffer);
    }

    @Override
    protected void readPixelsImpl(int x, int y, int width, int height, int format, int type, long offset) {
        this.gl.glReadPixels(x, y, width, height, format, type, 0L);
    }

    @Override
    public void vertexAttrib1f(int index, float value) {
        this.gl2.glVertexAttrib1f(index, value);
    }

    @Override
    public void vertexAttrib2f(int index, float value0, float value1) {
        this.gl2.glVertexAttrib2f(index, value0, value1);
    }

    @Override
    public void vertexAttrib3f(int index, float value0, float value1, float value2) {
        this.gl2.glVertexAttrib3f(index, value0, value1, value2);
    }

    @Override
    public void vertexAttrib4f(int index, float value0, float value1, float value2, float value3) {
        this.gl2.glVertexAttrib4f(index, value0, value1, value2, value3);
    }

    @Override
    public void vertexAttrib1fv(int index, FloatBuffer values2) {
        this.gl2.glVertexAttrib1fv(index, values2);
    }

    @Override
    public void vertexAttrib2fv(int index, FloatBuffer values2) {
        this.gl2.glVertexAttrib2fv(index, values2);
    }

    @Override
    public void vertexAttrib3fv(int index, FloatBuffer values2) {
        this.gl2.glVertexAttrib3fv(index, values2);
    }

    @Override
    public void vertexAttrib4fv(int index, FloatBuffer values2) {
        this.gl2.glVertexAttrib4fv(index, values2);
    }

    @Override
    public void vertexAttribPointer(int index, int size, int type, boolean normalized, int stride, int offset) {
        this.gl2.glVertexAttribPointer(index, size, type, normalized, stride, offset);
    }

    @Override
    public void enableVertexAttribArray(int index) {
        this.gl2.glEnableVertexAttribArray(index);
    }

    @Override
    public void disableVertexAttribArray(int index) {
        this.gl2.glDisableVertexAttribArray(index);
    }

    @Override
    public void drawArraysImpl(int mode, int first, int count) {
        this.gl.glDrawArrays(mode, first, count);
    }

    @Override
    public void drawElementsImpl(int mode, int count, int type, int offset) {
        this.gl.glDrawElements(mode, count, type, offset);
    }

    @Override
    public void lineWidth(float width) {
        this.gl.glLineWidth(width);
    }

    @Override
    public void frontFace(int dir) {
        this.gl.glFrontFace(dir);
    }

    @Override
    public void cullFace(int mode) {
        this.gl.glCullFace(mode);
    }

    @Override
    public void polygonOffset(float factor, float units) {
        this.gl.glPolygonOffset(factor, units);
    }

    @Override
    public void pixelStorei(int pname, int param) {
        this.gl.glPixelStorei(pname, param);
    }

    @Override
    public void texImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, Buffer data) {
        this.gl.glTexImage2D(target, level, internalFormat, width, height, border, format, type, data);
    }

    @Override
    public void copyTexImage2D(int target, int level, int internalFormat, int x, int y, int width, int height, int border) {
        this.gl.glCopyTexImage2D(target, level, internalFormat, x, y, width, height, border);
    }

    @Override
    public void texSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int type, Buffer data) {
        this.gl.glTexSubImage2D(target, level, xOffset, yOffset, width, height, format, type, data);
    }

    @Override
    public void copyTexSubImage2D(int target, int level, int xOffset, int yOffset, int x, int y, int width, int height) {
        this.gl.glCopyTexSubImage2D(target, level, x, y, xOffset, yOffset, width, height);
    }

    @Override
    public void compressedTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int imageSize, Buffer data) {
        this.gl.glCompressedTexImage2D(target, level, internalFormat, width, height, border, imageSize, data);
    }

    @Override
    public void compressedTexSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int imageSize, Buffer data) {
        this.gl.glCompressedTexSubImage2D(target, level, xOffset, yOffset, width, height, format, imageSize, data);
    }

    @Override
    public void texParameteri(int target, int pname, int param) {
        this.gl.glTexParameteri(target, pname, param);
    }

    @Override
    public void texParameterf(int target, int pname, float param) {
        this.gl.glTexParameterf(target, pname, param);
    }

    @Override
    public void texParameteriv(int target, int pname, IntBuffer params) {
        this.gl.glTexParameteriv(target, pname, params);
    }

    @Override
    public void texParameterfv(int target, int pname, FloatBuffer params) {
        this.gl.glTexParameterfv(target, pname, params);
    }

    @Override
    public void generateMipmap(int target) {
        this.gl.glGenerateMipmap(target);
    }

    @Override
    public void genTextures(int n, IntBuffer textures) {
        this.gl.glGenTextures(n, textures);
    }

    @Override
    public void deleteTextures(int n, IntBuffer textures) {
        this.gl.glDeleteTextures(n, textures);
    }

    @Override
    public void getTexParameteriv(int target, int pname, IntBuffer params) {
        this.gl.glGetTexParameteriv(target, pname, params);
    }

    @Override
    public void getTexParameterfv(int target, int pname, FloatBuffer params) {
        this.gl.glGetTexParameterfv(target, pname, params);
    }

    @Override
    public boolean isTexture(int texture) {
        return this.gl.glIsTexture(texture);
    }

    @Override
    protected void activeTextureImpl(int texture) {
        this.gl.glActiveTexture(texture);
    }

    @Override
    protected void bindTextureImpl(int target, int texture) {
        this.gl.glBindTexture(target, texture);
    }

    @Override
    public int createShader(int type) {
        return this.gl2.glCreateShader(type);
    }

    @Override
    public void shaderSource(int shader, String source) {
        this.gl2.glShaderSource(shader, 1, new String[]{source}, null, 0);
    }

    @Override
    public void compileShader(int shader) {
        this.gl2.glCompileShader(shader);
    }

    @Override
    public void releaseShaderCompiler() {
        this.gl2.glReleaseShaderCompiler();
    }

    @Override
    public void deleteShader(int shader) {
        this.gl2.glDeleteShader(shader);
    }

    @Override
    public void shaderBinary(int count, IntBuffer shaders, int binaryFormat, Buffer binary, int length) {
        this.gl2.glShaderBinary(count, shaders, binaryFormat, binary, length);
    }

    @Override
    public int createProgram() {
        return this.gl2.glCreateProgram();
    }

    @Override
    public void attachShader(int program, int shader) {
        this.gl2.glAttachShader(program, shader);
    }

    @Override
    public void detachShader(int program, int shader) {
        this.gl2.glDetachShader(program, shader);
    }

    @Override
    public void linkProgram(int program) {
        this.gl2.glLinkProgram(program);
    }

    @Override
    public void useProgram(int program) {
        this.gl2.glUseProgram(program);
    }

    @Override
    public void deleteProgram(int program) {
        this.gl2.glDeleteProgram(program);
    }

    @Override
    public String getActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        int[] tmp = new int[3];
        byte[] namebuf = new byte[1024];
        this.gl2.glGetActiveAttrib(program, index, 1024, tmp, 0, tmp, 1, tmp, 2, namebuf, 0);
        size.put(tmp[1]);
        type.put(tmp[2]);
        String name = new String(namebuf, 0, tmp[0]);
        return name;
    }

    @Override
    public int getAttribLocation(int program, String name) {
        return this.gl2.glGetAttribLocation(program, name);
    }

    @Override
    public void bindAttribLocation(int program, int index, String name) {
        this.gl2.glBindAttribLocation(program, index, name);
    }

    @Override
    public int getUniformLocation(int program, String name) {
        return this.gl2.glGetUniformLocation(program, name);
    }

    @Override
    public String getActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        int[] tmp = new int[3];
        byte[] namebuf = new byte[1024];
        this.gl2.glGetActiveUniform(program, index, 1024, tmp, 0, tmp, 1, tmp, 2, namebuf, 0);
        size.put(tmp[1]);
        type.put(tmp[2]);
        String name = new String(namebuf, 0, tmp[0]);
        return name;
    }

    @Override
    public void uniform1i(int location, int value) {
        this.gl2.glUniform1i(location, value);
    }

    @Override
    public void uniform2i(int location, int value0, int value1) {
        this.gl2.glUniform2i(location, value0, value1);
    }

    @Override
    public void uniform3i(int location, int value0, int value1, int value2) {
        this.gl2.glUniform3i(location, value0, value1, value2);
    }

    @Override
    public void uniform4i(int location, int value0, int value1, int value2, int value3) {
        this.gl2.glUniform4i(location, value0, value1, value2, value3);
    }

    @Override
    public void uniform1f(int location, float value) {
        this.gl2.glUniform1f(location, value);
    }

    @Override
    public void uniform2f(int location, float value0, float value1) {
        this.gl2.glUniform2f(location, value0, value1);
    }

    @Override
    public void uniform3f(int location, float value0, float value1, float value2) {
        this.gl2.glUniform3f(location, value0, value1, value2);
    }

    @Override
    public void uniform4f(int location, float value0, float value1, float value2, float value3) {
        this.gl2.glUniform4f(location, value0, value1, value2, value3);
    }

    @Override
    public void uniform1iv(int location, int count, IntBuffer v) {
        this.gl2.glUniform1iv(location, count, v);
    }

    @Override
    public void uniform2iv(int location, int count, IntBuffer v) {
        this.gl2.glUniform2iv(location, count, v);
    }

    @Override
    public void uniform3iv(int location, int count, IntBuffer v) {
        this.gl2.glUniform3iv(location, count, v);
    }

    @Override
    public void uniform4iv(int location, int count, IntBuffer v) {
        this.gl2.glUniform4iv(location, count, v);
    }

    @Override
    public void uniform1fv(int location, int count, FloatBuffer v) {
        this.gl2.glUniform1fv(location, count, v);
    }

    @Override
    public void uniform2fv(int location, int count, FloatBuffer v) {
        this.gl2.glUniform2fv(location, count, v);
    }

    @Override
    public void uniform3fv(int location, int count, FloatBuffer v) {
        this.gl2.glUniform3fv(location, count, v);
    }

    @Override
    public void uniform4fv(int location, int count, FloatBuffer v) {
        this.gl2.glUniform4fv(location, count, v);
    }

    @Override
    public void uniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer mat) {
        this.gl2.glUniformMatrix2fv(location, count, transpose, mat);
    }

    @Override
    public void uniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer mat) {
        this.gl2.glUniformMatrix3fv(location, count, transpose, mat);
    }

    @Override
    public void uniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer mat) {
        this.gl2.glUniformMatrix4fv(location, count, transpose, mat);
    }

    @Override
    public void validateProgram(int program) {
        this.gl2.glValidateProgram(program);
    }

    @Override
    public boolean isShader(int shader) {
        return this.gl2.glIsShader(shader);
    }

    @Override
    public void getShaderiv(int shader, int pname, IntBuffer params) {
        this.gl2.glGetShaderiv(shader, pname, params);
    }

    @Override
    public void getAttachedShaders(int program, int maxCount, IntBuffer count, IntBuffer shaders) {
        this.gl2.glGetAttachedShaders(program, maxCount, count, shaders);
    }

    @Override
    public String getShaderInfoLog(int shader) {
        int[] val = new int[1];
        this.gl2.glGetShaderiv(shader, 35716, val, 0);
        int length = val[0];
        byte[] log = new byte[length];
        this.gl2.glGetShaderInfoLog(shader, length, val, 0, log, 0);
        return new String(log);
    }

    @Override
    public String getShaderSource(int shader) {
        int[] len = new int[1];
        byte[] buf = new byte[1024];
        this.gl2.glGetShaderSource(shader, 1024, len, 0, buf, 0);
        return new String(buf, 0, len[0]);
    }

    @Override
    public void getShaderPrecisionFormat(int shaderType, int precisionType, IntBuffer range, IntBuffer precision) {
        this.gl2.glGetShaderPrecisionFormat(shaderType, precisionType, range, precision);
    }

    @Override
    public void getVertexAttribfv(int index, int pname, FloatBuffer params) {
        this.gl2.glGetVertexAttribfv(index, pname, params);
    }

    @Override
    public void getVertexAttribiv(int index, int pname, IntBuffer params) {
        this.gl2.glGetVertexAttribiv(index, pname, params);
    }

    @Override
    public void getVertexAttribPointerv(int index, int pname, ByteBuffer data) {
        throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glGetVertexAttribPointerv()"));
    }

    @Override
    public void getUniformfv(int program, int location, FloatBuffer params) {
        this.gl2.glGetUniformfv(program, location, params);
    }

    @Override
    public void getUniformiv(int program, int location, IntBuffer params) {
        this.gl2.glGetUniformiv(program, location, params);
    }

    @Override
    public boolean isProgram(int program) {
        return this.gl2.glIsProgram(program);
    }

    @Override
    public void getProgramiv(int program, int pname, IntBuffer params) {
        this.gl2.glGetProgramiv(program, pname, params);
    }

    @Override
    public String getProgramInfoLog(int program) {
        int[] val = new int[1];
        this.gl2.glGetProgramiv(program, 35716, val, 0);
        int length = val[0];
        if (length > 0) {
            byte[] log = new byte[length];
            this.gl2.glGetProgramInfoLog(program, length, val, 0, log, 0);
            return new String(log);
        }
        return "Unknown error";
    }

    @Override
    public void scissor(int x, int y, int w, int h) {
        float scale = this.getPixelScale();
        this.gl.glScissor((int)scale * x, (int)(scale * (float)y), (int)(scale * (float)w), (int)(scale * (float)h));
    }

    @Override
    public void sampleCoverage(float value, boolean invert) {
        this.gl2.glSampleCoverage(value, invert);
    }

    @Override
    public void stencilFunc(int func, int ref, int mask) {
        this.gl2.glStencilFunc(func, ref, mask);
    }

    @Override
    public void stencilFuncSeparate(int face, int func, int ref, int mask) {
        this.gl2.glStencilFuncSeparate(face, func, ref, mask);
    }

    @Override
    public void stencilOp(int sfail, int dpfail, int dppass) {
        this.gl2.glStencilOp(sfail, dpfail, dppass);
    }

    @Override
    public void stencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        this.gl2.glStencilOpSeparate(face, sfail, dpfail, dppass);
    }

    @Override
    public void depthFunc(int func) {
        this.gl.glDepthFunc(func);
    }

    @Override
    public void blendEquation(int mode) {
        this.gl.glBlendEquation(mode);
    }

    @Override
    public void blendEquationSeparate(int modeRGB, int modeAlpha) {
        this.gl.glBlendEquationSeparate(modeRGB, modeAlpha);
    }

    @Override
    public void blendFunc(int src, int dst) {
        this.gl.glBlendFunc(src, dst);
    }

    @Override
    public void blendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        this.gl.glBlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    @Override
    public void blendColor(float red, float green, float blue, float alpha) {
        this.gl2.glBlendColor(red, green, blue, alpha);
    }

    @Override
    public void colorMask(boolean r, boolean g, boolean b, boolean a) {
        this.gl.glColorMask(r, g, b, a);
    }

    @Override
    public void depthMask(boolean mask) {
        this.gl.glDepthMask(mask);
    }

    @Override
    public void stencilMask(int mask) {
        this.gl.glStencilMask(mask);
    }

    @Override
    public void stencilMaskSeparate(int face, int mask) {
        this.gl2.glStencilMaskSeparate(face, mask);
    }

    @Override
    public void clearColor(float r, float g, float b, float a) {
        this.gl.glClearColor(r, g, b, a);
    }

    @Override
    public void clearDepth(float d) {
        this.gl.glClearDepth(d);
    }

    @Override
    public void clearStencil(int s) {
        this.gl.glClearStencil(s);
    }

    @Override
    public void clear(int buf) {
        this.gl.glClear(buf);
    }

    @Override
    protected void bindFramebufferImpl(int target, int framebuffer) {
        this.gl.glBindFramebuffer(target, framebuffer);
    }

    @Override
    public void deleteFramebuffers(int n, IntBuffer framebuffers) {
        this.gl.glDeleteFramebuffers(n, framebuffers);
    }

    @Override
    public void genFramebuffers(int n, IntBuffer framebuffers) {
        this.gl.glGenFramebuffers(n, framebuffers);
    }

    @Override
    public void bindRenderbuffer(int target, int renderbuffer) {
        this.gl.glBindRenderbuffer(target, renderbuffer);
    }

    @Override
    public void deleteRenderbuffers(int n, IntBuffer renderbuffers) {
        this.gl.glDeleteRenderbuffers(n, renderbuffers);
    }

    @Override
    public void genRenderbuffers(int n, IntBuffer renderbuffers) {
        this.gl.glGenRenderbuffers(n, renderbuffers);
    }

    @Override
    public void renderbufferStorage(int target, int internalFormat, int width, int height) {
        this.gl.glRenderbufferStorage(target, internalFormat, width, height);
    }

    @Override
    public void framebufferRenderbuffer(int target, int attachment, int rendbuferfTarget, int renderbuffer) {
        this.gl.glFramebufferRenderbuffer(target, attachment, rendbuferfTarget, renderbuffer);
    }

    @Override
    public void framebufferTexture2D(int target, int attachment, int texTarget, int texture, int level) {
        this.gl.glFramebufferTexture2D(target, attachment, texTarget, texture, level);
    }

    @Override
    public int checkFramebufferStatus(int target) {
        return this.gl.glCheckFramebufferStatus(target);
    }

    @Override
    public boolean isFramebuffer(int framebuffer) {
        return this.gl2.glIsFramebuffer(framebuffer);
    }

    @Override
    public void getFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        this.gl2.glGetFramebufferAttachmentParameteriv(target, attachment, pname, params);
    }

    @Override
    public boolean isRenderbuffer(int renderbuffer) {
        return this.gl2.glIsRenderbuffer(renderbuffer);
    }

    @Override
    public void getRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        this.gl2.glGetRenderbufferParameteriv(target, pname, params);
    }

    @Override
    public void blitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        if (this.gl2x != null) {
            this.gl2x.glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
        } else if (this.gl3 != null) {
            this.gl3.glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
        } else {
            throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glBlitFramebuffer()"));
        }
    }

    @Override
    public void renderbufferStorageMultisample(int target, int samples, int format, int width, int height) {
        if (this.gl2x != null) {
            this.gl2x.glRenderbufferStorageMultisample(target, samples, format, width, height);
        } else if (this.gl3 != null) {
            this.gl3.glRenderbufferStorageMultisample(target, samples, format, width, height);
        } else {
            throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glRenderbufferStorageMultisample()"));
        }
    }

    @Override
    public void readBuffer(int buf) {
        if (this.gl2x != null) {
            this.gl2x.glReadBuffer(buf);
        } else if (this.gl3 != null) {
            this.gl3.glReadBuffer(buf);
        } else {
            throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glReadBuffer()"));
        }
    }

    @Override
    public void drawBuffer(int buf) {
        if (this.gl2x != null) {
            this.gl2x.glDrawBuffer(buf);
        } else if (this.gl3 != null) {
            this.gl3.glDrawBuffer(buf);
        } else {
            throw new RuntimeException(String.format("GL function %1$s is not available on this hardware (or driver) Read http://wiki.processing.org/w/OpenGL_Issues for help.", "glDrawBuffer()"));
        }
    }

    protected class FontOutline
    implements PGL.FontOutline {
        PathIterator iter;

        public FontOutline(char ch, Font font) {
            char[] textArray = new char[]{ch};
            FontRenderContext frc = PJOGL.this.getFontRenderContext(font);
            GlyphVector gv = font.createGlyphVector(frc, textArray);
            Shape shp = gv.getOutline();
            this.iter = shp.getPathIterator(null);
        }

        @Override
        public boolean isDone() {
            return this.iter.isDone();
        }

        @Override
        public int currentSegment(float[] coords) {
            return this.iter.currentSegment(coords);
        }

        @Override
        public void next() {
            this.iter.next();
        }
    }

    protected static class Tessellator
    implements PGL.Tessellator {
        protected GLUtessellator tess;
        protected PGL.TessellatorCallback callback;
        protected GLUCallback gluCallback;

        public Tessellator(PGL.TessellatorCallback callback) {
            this.callback = callback;
            this.tess = GLU.gluNewTess();
            this.gluCallback = new GLUCallback();
            GLU.gluTessCallback(this.tess, 100100, this.gluCallback);
            GLU.gluTessCallback(this.tess, 100102, this.gluCallback);
            GLU.gluTessCallback(this.tess, 100101, this.gluCallback);
            GLU.gluTessCallback(this.tess, 100105, this.gluCallback);
            GLU.gluTessCallback(this.tess, 100103, this.gluCallback);
        }

        @Override
        public void setCallback(int flag) {
            GLU.gluTessCallback(this.tess, flag, this.gluCallback);
        }

        @Override
        public void setWindingRule(int rule) {
            this.setProperty(100140, rule);
        }

        @Override
        public void setProperty(int property, int value) {
            GLU.gluTessProperty(this.tess, property, value);
        }

        @Override
        public void beginPolygon() {
            this.beginPolygon(null);
        }

        @Override
        public void beginPolygon(Object data) {
            GLU.gluTessBeginPolygon(this.tess, data);
        }

        @Override
        public void endPolygon() {
            GLU.gluTessEndPolygon(this.tess);
        }

        @Override
        public void beginContour() {
            GLU.gluTessBeginContour(this.tess);
        }

        @Override
        public void endContour() {
            GLU.gluTessEndContour(this.tess);
        }

        @Override
        public void addVertex(double[] v) {
            this.addVertex(v, 0, v);
        }

        @Override
        public void addVertex(double[] v, int n, Object data) {
            GLU.gluTessVertex(this.tess, v, n, data);
        }

        protected class GLUCallback
        extends GLUtessellatorCallbackAdapter {
            protected GLUCallback() {
            }

            @Override
            public void begin(int type) {
                Tessellator.this.callback.begin(type);
            }

            @Override
            public void end() {
                Tessellator.this.callback.end();
            }

            @Override
            public void vertex(Object data) {
                Tessellator.this.callback.vertex(data);
            }

            @Override
            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                Tessellator.this.callback.combine(coords, data, weight, outData);
            }

            @Override
            public void error(int errnum) {
                Tessellator.this.callback.error(errnum);
            }
        }
    }
}

