#version 330

#include light.ss;

// Textures
uniform sampler2D uDiffuseMap;
uniform sampler2D uRoughnessMap;
uniform sampler2D uMetallicMap;

in vec3 fNormal;
in vec3 wNormal;
in vec3 fPosition;
in vec3 wPosition;
in vec2 fTexCoord;

/*
Ray tracing to lights
*/

out vec4 fragColor;

void main()
{	
	vec4 textureColor = texture(uDiffuseMap, fTexCoord);
	vec4 roughnessValue = texture(uRoughnessMap, fTexCoord);
	vec4 metallicValue = texture(uMetallicMap, fTexCoord);
	
	Material mat = getMaterial(metallicValue.x, roughnessValue.x);
	
	// Lighting from inside to out, flip normal
	vec4 normalLights = calculateAllLighting(wPosition
	, fPosition
	, wNormal
	, -fNormal
	, textureColor
	, mat);
	
	float diamondRefractionIndex = 2.42;
	float airRefractionIndex = 1.0f;
	float refractionIndex = airRefractionIndex / diamondRefractionIndex;
	
	vec4 refraction = calculateRefractionColor(
		  wPosition
		, wNormal
		, uCameraPosition
		, uCubeMap
		, uSkyboxRotationMatrix
		, refractionIndex);
			
	fragColor = (normalLights + refraction);
}
