#version 330

// OpenGL 3.0 -> GLSL 1.30

uniform mat4 uWorldMatrix;
uniform mat4 uViewMatrix;
uniform mat4 uProjectionMatrix;

// attributes of our vertex
in vec3 aPosition;
out vec3 fDiffuseColor;

void main()
{
	// gl_Position is a special variable of OpenGL that must be set
	vec4 position  = uProjectionMatrix * uViewMatrix * uWorldMatrix * vec4(aPosition, 1.0);
	gl_Position =  position;
	vec4 transformed = uWorldMatrix * vec4(aPosition, 1.0);
	fDiffuseColor = transformed.xyz;
}

