#version 330

uniform mat4 uProjectionMatrix;
uniform mat4 uWorldMatrix;
uniform mat4 uViewMatrix;

// attributes of vertex
in vec3 aPosition;
in vec2 aTexCoord;
in vec3 aNormal;

out vec3 wPosition;
out vec3 fPosition;

out vec3 wNormal;
out vec3 fNormal;

out vec2 fTexCoord;

void main()
{
	
	vec4 worldPos = uWorldMatrix * vec4(aPosition, 1.0);
	vec4 viewPos = uViewMatrix * worldPos;
	gl_Position =  uProjectionMatrix * viewPos;
	
	wPosition = vec3(worldPos);
	fPosition = vec3(viewPos);

	wNormal = mat3(transpose(inverse(uWorldMatrix))) * aNormal;	
	fNormal = mat3(transpose(inverse(uViewMatrix * uWorldMatrix))) * aNormal;

	fTexCoord = vec2(aTexCoord.x, 1 - aTexCoord.y);
}

