#version 330

// OpenGL 3.0 -> GLSL 1.30

uniform mat4 uWorldMatrix;
uniform mat4 uViewMatrix;
uniform mat4 uProjectionMatrix;

// attributes of our vertex
in vec3 aPosition;
in vec2 aTexCoord;
out vec2 fTexCoord;

void main()
{
	// gl_Position is a special variable of OpenGL that must be set
	vec4 position  = uProjectionMatrix * uViewMatrix * uWorldMatrix * vec4(aPosition, 1.0);
	position.z = position.w; // Always max depth
	gl_Position =  position;
	fTexCoord = vec2(aTexCoord.x, 1.0f - aTexCoord.y);
}

