import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import moonlander.library.*; 
import ddf.minim.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class on_the_spectrum extends PApplet {




Moonlander moonlander;

PShader cshader;
float bs;
int nx;
int ny;

public void setup() {
  
  noStroke();
  
  cshader = loadShader("frag.glsl", "vert.glsl");
  
  moonlander = Moonlander.initWithSoundtrack(this, "Demotausta.mp3", 150, 4);
  moonlander.start();
}

public void rbox(float s, float rotx, float roty){
  pushMatrix();
  rotateX(rotx * 2 * PI);
  rotateY(roty * 2 * PI);
  box(s);
  popMatrix();
}

public void draw() {
  moonlander.update();
  float t = (float) moonlander.getValue("t");
  float s = (float) moonlander.getValue("s");
  float rotx = (float) moonlander.getValue("rotx");
  float roty = (float) moonlander.getValue("roty");
  float rotz = (float) moonlander.getValue("rotz");
  cshader.set("t", t);
  cshader.set("w", width);
  cshader.set("h", width);
  shader(cshader);

  bs= 16;

  nx = PApplet.parseInt(width / bs) + 2;
  ny = PApplet.parseInt(height / bs) + 2;
  background(0);
  directionalLight(255, 255, 255, 0, 0, -1);
  
  translate(-bs, -bs/2);
  for(int i=0; i<ny; i++){
    for(int j=0; j<nx; j++){
      float d = sqrt(pow(ny/2 - i, 2) + pow(nx/2 - j, 2));
      float bsize = bs + bs * s * sin(d * t * PI);
      pushMatrix();
      rotateZ(rotz);
      rbox(bsize, rotx, roty);
      popMatrix();
      translate(bs, 0);
    }
    translate(-nx * bs, bs);
  }
  
  rectMode(CENTER);
  rotateZ(rotz);
}
  public void settings() {  size(1920, 1080, P3D); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "on_the_spectrum" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
