uniform mat4 transform;
uniform mat3 normalMatrix;
uniform vec3 lightNormal;

attribute vec4 position;
attribute vec4 color;
attribute vec3 normal;

varying vec4 vertColor;
varying vec3 vertNormal;
varying vec3 vertLightDir;

uniform float t;
uniform int h; 
uniform int w;

const float PI = 3.141592;

void main() {
  gl_Position = transform * position;
  vertNormal = normalize(normalMatrix * normal);
  vertLightDir = - lightNormal;
  
  float tfac = t * 2 * PI;
  float d = sqrt(pow(position.x / w, 2.0) + pow(position.y / h, 2.0));
  vertColor = vec4( d * cos(tfac * d), (1-d) * sin((1-tfac) * d * PI), cos(tfac * 1.5 * d), 1);
}
