var mat4 = {
	// defining dimension 4 matrices
	identity: function() {
		return [
			1, 0, 0, 0,
			0, 1, 0, 0,
			0, 0, 1, 0,
			0, 0, 0, 1,
		];
	},
	rotationZ: function(rad){
		var c = Math.cos(rad);
		var s = Math.sin(rad);
		return [
			c, s, 0, 0,
			-s, c, 0, 0,
			0, 0, 1, 0,
			0, 0, 0, 1,
		];
	},
	rotationX: function(rad){
		var c = Math.cos(rad);
		var s = Math.sin(rad);
		return [
			1, 0, 0, 0,
			0, c, -s, 0,
			0, s, c, 0,
			0, 0, 0, 1,
		];
	},
	rotationY: function(rad){
		var c = Math.cos(rad);
		var s = Math.sin(rad);
		return [
			c, 0, s, 0,
			0, 1, 0, 0,
			-s, 0, c, 0,
			0, 0, 0, 1,
		];
	},
	rotation: function(rad){
		return mat4Multiply(mat4Multiply(mat4.rotationX(rad[0]),
									  	 mat4.rotationY(rad[1])),
										 mat4.rotationZ(rad[2]));
	},
	translation: function(tx, ty, tz){
		return [
			1, 0, 0, 0,
			0, 1, 0, 0,
			0, 0, 1, 0,
			tx, ty, tz, 1,
		];
	},
	scale: function(sx, sy, sz){
		return [
			sx, 0, 0, 0,
			0, sy, 0, 0,
			0, 0, sz, 0,
			0, 0, 0, 1,
		];
	},
	projection: function(width, height, depth){
		return [
			2/width, 0, 0, 0,
			0, 2/height, 0, 0,
			0, 0, 2/depth, 0,
			-1, -1, -1, 1
		];
	},
	perspective: function(fov, aspect, near, far) {
		var f = Math.tan(Math.PI * 0.5 - 0.5 * fov);
		var rangeInv = 1.0 / (near - far);

		return [
			f / aspect, 0, 0, 0,
			0, -f, 0, 0,
			0, 0, (near + far) * rangeInv, -1,
			0, 0, near * far * rangeInv * 2, 0
		];
	},

	inverse: function(m) {
		// inverse of 4x4 matrix
		var det = (
			m[0]*m[5]*m[10]*m[15]+m[0]*m[9]*m[14]*m[7]+m[0]*m[13]*m[6]*m[11]+
			m[4]*m[1]*m[14]*m[11]+m[4]*m[9]*m[2]*m[15]+m[4]*m[13]*m[10]*m[3]+
			m[8]*m[1]*m[6]*m[15]+m[8]*m[5]*m[14]*m[3]+m[8]*m[13]*m[2]*m[7]+
			m[12]*m[1]*m[10]*m[7]+m[12]*m[5]*m[2]*m[11]+m[12]*m[9]*m[6]*m[7]-
			m[0]*m[5]*m[14]*m[11]-m[0]*m[9]*m[6]*m[15]-m[0]*m[13]*m[10]*m[7]-
			m[4]*m[1]*m[10]*m[15]-m[4]*m[9]*m[14]*m[3]-m[4]*m[13]*m[2]*m[11]-
			m[8]*m[2]*m[14]*m[7]-m[8]*m[5]*m[2]*m[15]-m[8]*m[13]*m[6]*m[3]-
			m[12]*m[1]*m[6]*m[11]-m[12]*m[5]*m[10]*m[3]-m[12]*m[9]*m[2]*m[7]
		);
		// determinant cant be 0
		if (det==0){return 0;}
		return [
			(1/det)*(m[5]*m[10]*m[15]+m[9]*m[14]*m[7]+m[13]*m[6]*m[11]-
					 m[5]*m[14]*m[11]-m[9]*m[6]*m[15]-m[13]*m[10]*m[7]),

	 		(1/det)*(m[1]*m[14]*m[11]+m[9]*m[2]*m[15]+m[13]*m[10]*m[3]-
					 m[1]*m[10]*m[15]-m[9]*m[14]*m[3]-m[13]*m[2]*m[11]),

			(1/det)*(m[1]*m[6]*m[15]+m[5]*m[14]*m[3]+m[13]*m[2]*m[7]-
 					 m[1]*m[14]*m[7]-m[5]*m[2]*m[15]-m[13]*m[6]*m[3]),

			(1/det)*(m[1]*m[10]*m[7]+m[5]*m[2]*m[11]+m[9]*m[6]*m[3]-
					 m[1]*m[6]*m[11]-m[5]*m[10]*m[03]-m[9]*m[2]*m[7]),

			//------------------------------

			(1/det)*(m[4]*m[14]*m[11]+m[8]*m[6]*m[15]+m[12]*m[10]*m[7]-
					 m[4]*m[10]*m[15]-m[8]*m[14]*m[7]-m[12]*m[6]*m[11]),

 	 		(1/det)*(m[0]*m[10]*m[15]+m[8]*m[14]*m[3]+m[12]*m[2]*m[11]-
 					 m[0]*m[14]*m[11]-m[8]*m[2]*m[15]-m[12]*m[10]*m[3]),

 			(1/det)*(m[0]*m[14]*m[7]+m[4]*m[2]*m[15]+m[12]*m[6]*m[3]-
  					 m[0]*m[6]*m[15]-m[4]*m[14]*m[3]-m[12]*m[6]*m[7]),

			(1/det)*(m[0]*m[6]*m[11]+m[4]*m[10]*m[3]+m[8]*m[2]*m[7]-
  					 m[0]*m[10]*m[7]-m[4]*m[2]*m[11]-m[8]*m[6]*m[3]),

			//-------------

			(1/det)*(m[4]*m[9]*m[15]+m[8]*m[13]*m[7]+m[12]*m[5]*m[11]-
 					 m[4]*m[13]*m[11]-m[8]*m[5]*m[15]-m[12]*m[9]*m[7]),

 	 		(1/det)*(m[0]*m[13]*m[11]+m[8]*m[1]*m[15]+m[12]*m[9]*m[3]-
 					 m[0]*m[9]*m[15]-m[8]*m[13]*m[3]-m[12]*m[1]*m[11]),

 			(1/det)*(m[0]*m[5]*m[15]+m[4]*m[13]*m[3]+m[12]*m[1]*m[7]-
  					 m[0]*m[13]*m[7]-m[4]*m[1]*m[15]-m[12]*m[5]*m[3]),

 			(1/det)*(m[0]*m[9]*m[7]+m[4]*m[1]*m[11]+m[8]*m[5]*m[3]-
 					 m[0]*m[5]*m[11]-m[4]*m[9]*m[11]-m[8]*m[1]*m[7]),

 			//--------------------------------

 			(1/det)*(m[4]*m[13]*m[10]+m[8]*m[5]*m[14]+m[12]*m[9]*m[6]-
  					 m[4]*m[9]*m[14]-m[8]*m[13]*m[6]-m[12]*m[5]*m[10]),

  	 		(1/det)*(m[0]*m[9]*m[14]+m[8]*m[13]*m[2]+m[12]*m[1]*m[10]-
  					 m[0]*m[13]*m[10]-m[8]*m[1]*m[14]-m[12]*m[9]*m[1]),

  			(1/det)*(m[0]*m[13]*m[6]+m[4]*m[1]*m[14]+m[12]*m[5]*m[2]-
   					 m[0]*m[5]*m[14]-m[4]*m[13]*m[2]-m[12]*m[1]*m[6]),

  			(1/det)*(m[0]*m[5]*m[10]+m[4]*m[9]*m[2]+m[8]*m[1]*m[6]-
  					 m[0]*m[9]*m[6]-m[4]*m[1]*m[10]-m[8]*m[5]*m[2]),

		];
	},
};

function mat4Multiply(m1, m2) {
	var matrix = [];

	for (i=0; i<4; i++){
		for (j=0; j<4; j++){
			ii = 4*i;
			matrix.push(
				m1[j]*m2[ii]+m1[j+4]*m2[ii+1]+m1[j+8]*m2[ii+2]+m1[j+12]*m2[ii+3]
			);
		}
	}
	return matrix;
}

function matVec4Multiply(m, vec) {
	// 4x4 matrix and 4x1 vector multiply
	var resvec = [];

	for (i=0; i<4; i++){
		resvec.push(
			m[i+0]*vec[0]+m[i+4]*vec[1]+m[i+8]*vec[2]+m[i+12]*vec[3]
		);
	}
	return resvec;
}

function vec3Normalize(vec) {
	// Normalizes a vector of 3 components
	var abs = Math.sqrt(vec[0]*vec[0]+
			  vec[1]*vec[1]+
			  vec[2]*vec[2]);
	return [
		vec[0]/abs,
		vec[1]/abs,
		vec[2]/abs,
	];

}
