var Points = function(){

    var size = TDEMO.MAIN.getRendererSize();
    PartBase.call(this,
        {camera : new THREE.OrthographicCamera( -size[0]/2, size[0]/2, size[1]/2, -size[1]/2, 0.1, 2000 )});
    this.camera.position.z = 1;

    this.mainScene = new THREE.Scene();
    var aspect = this.width/this.height;
    this.mainCamera = new THREE.PerspectiveCamera(50, aspect, this.near, this.far);

    this.mainScene.add(this.mainCamera);
    var rtSize  = {
        width : 2048,//1024,
        height: 1024//512
    }
    this.rtt = new THREE.WebGLRenderTarget(rtSize.width, rtSize.height);
    this.rtt.texture.wrapS = THREE.MirroredRepeatWrapping;
    this.rtt.texture.wrapT = THREE.MirroredRepeatWrapping;
    this.rtt.texture.offset.x = 0;
    this.rtt.texture.offset.y = 0;

    this.composer = new THREE.EffectComposer(TDEMO.MAIN.getRenderer(), this.rtt);
    this.composer.setSize(rtSize.width, rtSize.height);
    this.rp = new THREE.RenderPass(this.mainScene, this.mainCamera);

    this.pedge = new THREE.ShaderPass( THREE.EdgeShader2 );
    this.pedge.uniforms[ "resolution" ].value =  new THREE.Vector2(rtSize.width, rtSize.height);

    this.pbloom = new THREE.BloomPass(2, 25, 4, rtSize.width);
    this.pbloom.renderToScreen = true;
    this.pbloom.needsSwap = true;
    this.pbloom.clear = true;

    this.composer.addPass(this.rp);
    this.composer.addPass(this.pedge);
    this.composer.addPass(this.pbloom);

    //POSTPROCESSING
    this.setBloom(0.1);


    var pg = new THREE.PlaneBufferGeometry(this.width, this.height);
    var pm = new THREE.MeshBasicMaterial({map: this.rtt.texture});
    this.plane = new THREE.Mesh(pg, pm);
    this.scene.add(this.plane);

    var material = new THREE.PointsMaterial({ color: 0x00FFFF/*0x55D3BA*/});
    var material2 = new THREE.PointsMaterial({ color: 0xFF00FF/*0x5D478B*/});
    var geometry = new THREE.Geometry();
    var geometry2 = new THREE.Geometry();
    geometry.dynamic = true;
    geometry2.dynamic = true;


    this.lsystem = new LSYSTEM();

    this.lsystem.interpret(6, 120, "FrFrFruFuFuFulFlFl","FuFrFFtFrFlF", 4);
    this.lsystem.moveToCenter();

    for(var k = 0; k < this.lsystem.points.length; ++k){
        var point = this.lsystem.points[k];
        geometry.vertices.push(new THREE.Vector3(-point.x, -point.y, -point.z));
        geometry2.vertices.push(new THREE.Vector3(point.x, point.y, point.z));
    }
    geometry.verticesNeedUpdate = true;
    geometry2.verticesNeedUpdate = true;
    this.container = new THREE.Object3D();

    this.points = new THREE.Points(geometry, material);
    this.points2 = new THREE.Points(geometry2, material2);

    this.container.add(this.points);
    this.container.add(this.points2);


    this.mainScene.add(this.container);

};

Points.prototype = PartBase.prototype.inheritance();

Points.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, false);

    this.near = TDEMO.SYNC.getNear();
    this.far = TDEMO.SYNC.getFar();


    this.mainCamera.near = this.near;
    this.mainCamera.far = this.far;
    this.lens = TDEMO.SYNC.getLens();
    this.mainCamera.filmGauge = this.lens.fg;
    this.mainCamera.setFocalLength(this.lens.fl);
    this.mainCamera.updateProjectionMatrix();
    
    var camp = TDEMO.SYNC.getCameraPosition();
    this.mainCamera.position.x = camp.x;
    this.mainCamera.position.y = camp.y;
    this.mainCamera.position.z = camp.z;

    var camr = TDEMO.SYNC.getCameraRotation();
    this.mainCamera.rotation.x = camr.x;
    this.mainCamera.rotation.y = camr.y;
    this.mainCamera.rotation.z = camr.z;

    var lp = TDEMO.SYNC.getObjRotation();
    this.points.rotation.x = lp.x;
    this.points.rotation.y = lp.y;
    this.points.rotation.z = lp.z;

    this.points2.rotation.x = -lp.x;
    this.points2.rotation.y = -lp.y;
    this.points2.rotation.z = -lp.z;
    
    var p = TDEMO.SYNC.getObjPosition();
    this.container.position.x = p.x;
    this.container.position.y = p.y;
    this.container.position.z = p.z;

    
    var hb = TDEMO.SYNC.getHeartBeat();
    this.rtt.texture.offset.x = hb;
    this.rtt.texture.offset.y = -hb;
    this.composer.render();
};
