import Core

// MARK: - Throwing static methods
extension RandomProtocol where Self: EmptyInitializable {
    public static func bytes(count: Int) throws -> Bytes {
        return try Self().bytes(count: count)
    }

    /// Get a random Int8
    public static func makeInt8() throws -> Int8 {
        return try Self().makeInt8()
    }

    /// Get a random UInt8
    public static func makeUInt8() throws -> UInt8 {
        return try Self().makeUInt8()
    }

    /// Get a random Int16
    public static func makeInt16() throws -> Int16 {
        return try Self().makeInt16()
    }

    /// Get a random UInt16
    public static func makeUInt16() throws -> UInt16 {
        return try Self().makeUInt16()
    }

    /// Get a random Int32
    public static func makeInt32() throws -> Int32 {
        return try Self().makeInt32()
    }

    /// Get a random UInt32
    public static func makeUInt32() throws -> UInt32 {
        return try Self().makeUInt32()
    }

    /// Get a random Int64
    public static func makeInt64() throws -> Int64 {
        return try Self().makeInt64()
    }

    /// Get a random UInt64
    public static func makeUInt64() throws -> UInt64 {
        return try Self().makeUInt64()
    }

    /// Get a random Int
    public static func makeInt() throws -> Int {
        return try Self().makeInt()
    }

    /// Get a random UInt
    public static func makeUInt() throws -> UInt {
        return try Self().makeUInt()
    }
}
